/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql;

public class SqlConstants {
    public static final String TBTP_SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String TBTP_GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
    public static final String TBTP_LOCAL_TEMPORARY = "LOCAL TEMPORARY";
    public static final String TBTP_ALIAS = "ALIAS";
    public static final String TBTP_SYNONYM = "SYNONYM";
    public static final String NULL = "NULL";
    public static final String TABLE_CAT = "TABLE_CAT";
    public static final String TABLE_SCHEM = "TABLE_SCHEM";
    public static final String TABLE_NAME = "TABLE_NAME";
    public static final String COLUMN_NAME = "COLUMN_NAME";
    public static final String DATA_TYPE = "DATA_TYPE";
    public static final String TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_SIZE = "COLUMN_SIZE";
    public static final String BUFFER_LENGTH = "BUFFER_LENGTH";
    public static final String DECIMAL_DIGITS = "DECIMAL_DIGITS";
    public static final String NUM_PREC_RADIX = "NUM_PREC_RADIX";
    public static final String NULLABLE = "NULLABLE";
    public static final String TABLE_TYPE = "TABLE_TYPE";
    public static final String REMARKS = "REMARKS";
    public static final String COLUMN_DEF = "COLUMN_DEF";
    public static final String TYPE_CAT = "TYPE_CAT";
    public static final String TYPE_SCHEM = "TYPE_SCHEM";
    public static final String SELF_REFERENCING_COL_NAME = "SELF_REFERENCING_COL_NAME";
    public static final String REF_GENERATION = "REF_GENERATION";
    public static final String SQL_DATA_TYPE = "SQL_DATA_TYPE";
    public static final String SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    public static final String CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    public static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    public static final String IS_NULLABLE = "IS_NULLABLE";
    public static final String SCOPE_CATLOG = "SCOPE_CATLOG";
    public static final String SCOPE_SCHEMA = "SCOPE_SCHEMA";
    public static final String SCOPE_TABLE = "SCOPE_TABLE";
    public static final String SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    public static final String TABLE_QUALIFIER = "TABLE_QUALIFIER";
    public static final String TABLE_OWNER = "TABLE_OWNER";
    public static final String PRECISION = "PRECISION";
    public static final String SCALE = "SCALE";
    public static final String RADIX = "RADIX";
    public static final String ORDINAL = "ORDINAL";
    public static final String PK_NAME = "PK_NAME";
    public static final String KEY_SEQ = "KEY_SEQ";
    public static final String NON_UNIQUE = "NON_UNIQUE";
    public static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    public static final String INDEX_NAME = "INDEX_NAME";
    public static final String TYPE = "TYPE";
    public static final String ASC_OR_DESC = "ASC_OR_DESC";
    public static final String CARDINALITY = "CARDINALITY";
    public static final String PAGES = "PAGES";
    public static final String FILTER_CONDITION = "FILTER_CONDITION";
    public static final String AS = " AS ";
    public static final String OR = " OR ";
    private static boolean isDebug;

    private SqlConstants() {
    }

    public static boolean getDebug() {
        return isDebug;
    }

    public static void setDebug(boolean isDebug2) {
        isDebug = isDebug2;
    }

    public static enum DatabaseProduct {
        H2("H2", 101),
        HSQLDB("HyperSQL", 201),
        Derby("Apache Derby", 301),
        PostgreSQL("PostgreSQL", 401),
        MySQL("MySQL", 501),
        Oracle("Oracle", 601),
        SQLServer("Microsoft SQL Server", 701),
        ACCESS("ACCESS", 702),
        DB2("DB2", 901);

        public final int id;
        public final String productName;

        private DatabaseProduct(String productName, int productId) {
            this.productName = productName;
            this.id = productId;
        }

        public static DatabaseProduct getById(int productId) {
            DatabaseProduct[] databaseProductArray = DatabaseProduct.values();
            int n = databaseProductArray.length;
            int n2 = 0;
            while (n2 < n) {
                DatabaseProduct databaseProduct = databaseProductArray[n2];
                if (databaseProduct.id == productId) {
                    return databaseProduct;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum DatasourceProperty {
        driver,
        url,
        user,
        password,
        charSet;

    }

    public static enum PatternMatch {
        partialMatch(1, "Partial Match", "\u90e8\u5206\u4e00\u81f4"),
        exactMatch(2, "Exact Match", "\u5b8c\u5168\u4e00\u81f4"),
        forwardMatch(3, "Forward Match", "\u524d\u65b9\u4e00\u81f4"),
        backwardMatch(4, "Backward Match", "\u5f8c\u65b9\u4e00\u81f4");

        public final short id;
        public final String nameEn;
        public final String nameJp;

        private PatternMatch(int id, String nameEn, String nameJp) {
            this.id = (short)id;
            this.nameEn = nameEn;
            this.nameJp = nameJp;
        }
    }

    public static enum SqlType {
        ARRAY(2003),
        BIGINT(-5),
        BINARY(-2),
        BIT(-7),
        BLOB(2004),
        BOOLEAN(16),
        CHAR(1),
        CLOB(2005),
        DATALINK(70),
        DATE(91),
        DECIMAL(3),
        DISTINCT(2001),
        DOUBLE(8),
        FLOAT(6),
        INTEGER(4),
        JAVA_OBJECT(2000),
        LONGNVARCHAR(-16),
        LONGVARBINARY(-4),
        LONGVARCHAR(-1),
        NCHAR(-15),
        NCLOB(2011),
        NULL(0),
        NUMERIC(2),
        NVARCHAR(-9),
        OTHER(1111),
        REAL(7),
        REF(2006),
        ROWID(-8),
        SMALLINT(5),
        SQLXML(2009),
        STRUCT(2002),
        TIME(92),
        TIMESTAMP(93),
        TINYINT(-6),
        VARBINARY(-3),
        VARCHAR(12);

        public final int id;

        private SqlType(int id) {
            this.id = id;
        }

        public static SqlType getById(int id) {
            SqlType[] sqlTypeArray = SqlType.values();
            int n = sqlTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SqlType sqlType = sqlTypeArray[n2];
                if (sqlType.id == id) {
                    return sqlType;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum TableType {
        TABLE,
        VIEW,
        SYSTEM_TABLE,
        GLOBAL_TEMPORARY,
        LOCAL_TEMPORARY,
        ALIAS,
        SYNONYM;

        public final String value = this.name().replace('_', ' ');
    }
}

