/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.pdf;

import ext.base.util.BcCollectionUtil;
import ext.lib.pdf.XrefEntry;
import ext.lib.pdf.object.PdfObject;
import java.util.ArrayList;

public class Xref {
    protected ArrayList xrefEntries = new ArrayList();
    protected int pos;

    public Xref() {
        XrefEntry rootEntry = new XrefEntry();
        rootEntry.setGenerationNumber(65535);
        this.xrefEntries.add(rootEntry);
    }

    protected void addEntry(PdfObject obj) {
        int objectId = obj.getObjectId();
        if (objectId >= this.xrefEntries.size()) {
            BcCollectionUtil.fill(this.xrefEntries, objectId + 1);
        }
        XrefEntry entry = new XrefEntry();
        this.xrefEntries.set(objectId, entry);
        entry.setEntryType('n');
    }

    protected XrefEntry getEntry(int index) {
        XrefEntry entry = (XrefEntry)this.xrefEntries.get(index);
        if (entry == null) {
            entry = new XrefEntry();
        }
        return entry;
    }

    protected int size() {
        return this.xrefEntries.size();
    }

    protected String getObjectString() {
        StringBuilder sb = new StringBuilder("xref\r\n0 " + new String(new Integer(this.size()).toString()) + "\r\n");
        int i = 0;
        while (i < this.size()) {
            sb.append(String.valueOf(this.getEntry(i).toString()) + "\r\n");
            ++i;
        }
        return sb.toString();
    }

    protected void setPos(int value) {
        this.pos = value;
    }

    protected int getPos() {
        return this.pos;
    }
}

