/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.orm.persistence;

import ext.base.core.BcInteger;
import ext.base.core.BcLangUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.common.OrmConstants;
import ext.lib.orm.dao.OrmSequenceDAO;
import ext.lib.orm.entity.OrmAddOnly;
import ext.lib.orm.entity.OrmAddition;
import ext.lib.orm.entity.OrmDataId;
import ext.lib.orm.entity.OrmOverwrite;
import ext.lib.orm.entity.OrmPersistenceEntity;
import ext.lib.orm.entity.OrmPersistenceField;
import ext.lib.orm.persistence.OrmAcquisitionHandler;
import ext.lib.orm.persistence.OrmEntityContext;
import ext.lib.orm.persistence.OrmEntityContextManager;
import ext.lib.orm.persistence.OrmPersistenceAddition;
import ext.lib.orm.persistence.OrmPersistenceProxy;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlWhereElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;

public class OrmPersistenceUtil {
    private OrmPersistenceUtil() {
    }

    public static boolean isPersistence(Class clazz) throws Exception {
        boolean b = false;
        if (clazz.isPrimitive() || BcLangUtil.isWrapperClass(clazz)) {
            b = true;
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            b = true;
        } else if (Calendar.class.isAssignableFrom(clazz)) {
            b = true;
        } else if (BigDecimal.class.isAssignableFrom(clazz)) {
            b = true;
        }
        return b;
    }

    public static Class getComponentType(Class array) throws Exception {
        Class<?> componentType;
        while ((componentType = array.getComponentType()).isArray()) {
            array = componentType;
        }
        return componentType;
    }

    public static boolean isPersistence(Field field) throws Exception {
        int modifier = field.getModifiers();
        if (Modifier.isFinal(modifier)) {
            return false;
        }
        if (Modifier.isTransient(modifier)) {
            return false;
        }
        OrmPersistenceField persistenceField = field.getAnnotation(OrmPersistenceField.class);
        return persistenceField == null || persistenceField.enable();
    }

    public static String toColumnName(String src) throws Exception {
        String newStr = BcStringUtil.toSnakeCase(src);
        int i = 0;
        while (i < OrmConstants.RESERVE_COLUMN_NAMES.length) {
            if (BcStringUtil.equalsIgnoreCase(newStr, OrmConstants.RESERVE_COLUMN_NAMES[i])) {
                newStr = String.valueOf(newStr) + BcStringUtil.UNDER_SCORE_STR;
                break;
            }
            ++i;
        }
        return newStr;
    }

    public static String toColumnName(Field field, String prefix, boolean isColumnNameConvert) throws Exception {
        OrmPersistenceField persistenceField = field.getAnnotation(OrmPersistenceField.class);
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(prefix)) {
            sb.append(prefix);
        }
        if (persistenceField == null) {
            if (isColumnNameConvert) {
                sb.append(OrmPersistenceUtil.toColumnName(field.getName()));
            } else {
                sb.append(field.getName());
            }
        } else {
            String columnName = null;
            if (persistenceField.columnName().length > 0) {
                columnName = persistenceField.columnName()[0];
            }
            if (BcStringUtil.isEmpty(columnName)) {
                if (isColumnNameConvert) {
                    sb.append(OrmPersistenceUtil.toColumnName(field.getName()));
                } else {
                    sb.append(field.getName());
                }
            } else if (!OrmConstants.NULL.equals(columnName)) {
                sb.append(columnName);
            }
        }
        return sb.toString();
    }

    public static String toColumnName(OrmPersistenceEntity persistenceEntity, Field field, String prefix) throws Exception {
        boolean isColumnNameConvert = OrmPersistenceUtil.isColumnNameConvert(persistenceEntity);
        return OrmPersistenceUtil.toColumnName(field, prefix, isColumnNameConvert);
    }

    public static String toColumnName(OrmPersistenceEntity persistenceEntity, Field field) throws Exception {
        return OrmPersistenceUtil.toColumnName(persistenceEntity, field, null);
    }

    public static boolean isColumnNameConvert(OrmPersistenceEntity persistenceEntity) throws Exception {
        boolean isColumnNameConvert = true;
        if (persistenceEntity != null) {
            isColumnNameConvert = persistenceEntity.columnNameConvert();
        }
        return isColumnNameConvert;
    }

    public static String toFieldName(String columnName) throws Exception {
        StringBuilder sb = new StringBuilder(columnName.length());
        int pos = -1;
        int preChar = 0;
        while (++pos < columnName.length()) {
            char char1 = columnName.charAt(pos);
            if (preChar == 95) {
                sb.append(Character.toUpperCase(char1));
            } else {
                sb.append(char1);
            }
            preChar = char1;
        }
        return sb.toString();
    }

    public static List<SqlWhereElement> createWhereClauseList(Class entityClass, OrmPersistenceEntity persistenceEntity, Object entity) throws Exception {
        List<SqlWhereElement> whereElementList2;
        boolean isColumnNameConvert = OrmPersistenceUtil.isColumnNameConvert(persistenceEntity);
        ArrayList<SqlWhereElement> whereElementList = new ArrayList<SqlWhereElement>();
        if (!BcStringUtil.isEmpty(persistenceEntity.primaryKeyField())) {
            whereElementList2 = OrmPersistenceUtil.createWhereClauseList_filed(entityClass, persistenceEntity.primaryKeyField(), null, isColumnNameConvert, entity);
            whereElementList.addAll(whereElementList2);
        }
        if (!BcStringUtil.isEmpty(persistenceEntity.primaryKeyMethod())) {
            whereElementList2 = OrmPersistenceUtil.createWhereClauseList_method(entityClass, persistenceEntity.primaryKeyMethod(), null, isColumnNameConvert);
            whereElementList.addAll(whereElementList2);
        }
        return whereElementList;
    }

    public static List<SqlWhereElement> createWhereClauseList_filed(Class entityClass, String fieldNames, String prefix, boolean isColumnNameConvert, Object entity) throws Exception {
        ArrayList<SqlWhereElement> whereElementList = new ArrayList<SqlWhereElement>();
        List<String> fieldNameList = BcStringUtil.stringTokenize((CharSequence)fieldNames, ',', false, true);
        int i = 0;
        while (i < fieldNameList.size()) {
            Field field = entityClass.getField(fieldNameList.get(i));
            SqlWhereElement whereElement = OrmPersistenceUtil.createWhereClause(field, prefix, isColumnNameConvert, entity);
            whereElementList.add(whereElement);
            ++i;
        }
        return whereElementList;
    }

    public static SqlWhereElement createWhereClause(Field field, String prefix, boolean isColumnNameConvert, Object entity) throws Exception {
        String columnName = OrmPersistenceUtil.toColumnName(field, prefix, isColumnNameConvert);
        Object value = OrmPersistenceUtil.getFieldValue(field, entity);
        SqlWhereElement whereElement = new SqlWhereElement();
        whereElement.setLogical_AND();
        whereElement.setFormula(String.valueOf(columnName) + " = " + value);
        return whereElement;
    }

    public static Object getFieldValue(Field field, Object entity) throws Exception {
        Object value = null;
        value = entity == null ? BcStringUtil.QUESTION_STR : field.get(entity);
        return value;
    }

    public static List<SqlWhereElement> createWhereClauseList_method(Class entityClass, CharSequence methodNames, CharSequence prefix, boolean isColumnNameConvert) throws Exception {
        ArrayList<SqlWhereElement> whereElementList = new ArrayList<SqlWhereElement>();
        List<String> keyMethodNameList = BcStringUtil.stringTokenize(methodNames, ',', false, true);
        int i = 0;
        while (i < keyMethodNameList.size()) {
            Method method = entityClass.getMethod(keyMethodNameList.get(i), null);
            OrmPersistenceField persistenceField = method.getAnnotation(OrmPersistenceField.class);
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(persistenceField.columnName()[0]) + " = ?");
            whereElementList.add(whereElement);
            ++i;
        }
        return whereElementList;
    }

    public static void getEntity(OrmPersistenceProxy persistenceProxy, DtsSession dtsSession, SqlResultSet rs, Object entity) throws Exception {
        persistenceProxy.getEntity(dtsSession, rs, entity);
    }

    public static Object getEntity(OrmPersistenceProxy persistenceProxy, DtsSession dtsSession, Class entityClass, String query) throws Exception {
        Object entity = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            try {
                SqlResultSet rs = stmt.executeQuery(query);
                if (rs.next()) {
                    entity = entityClass.newInstance();
                    OrmPersistenceUtil.getEntity(persistenceProxy, dtsSession, rs, entity);
                }
                rs.close();
            }
            catch (Exception ex) {
                BcLogUtil.error("query=" + query);
                throw ex;
            }
        }
        return entity;
    }

    public static void getEntitys(OrmPersistenceProxy persistenceProxy, DtsSession dtsSession, Class entityClass, String sql, Collection entityCollection) throws Exception {
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Object entity = entityClass.newInstance();
                OrmPersistenceUtil.getEntity(persistenceProxy, dtsSession, rs, entity);
                entityCollection.add(entity);
            }
            rs.close();
        }
    }

    public static void getEntitys(OrmPersistenceProxy persistenceProxy, DtsSession dtsSession, Class entityClass, String sql, OrmAcquisitionHandler acquisitionHandler) throws Exception {
        SqlStatement stmt = dtsSession.getConnection().createStatement();
        acquisitionHandler.statementCreated(dtsSession, stmt);
        try {
            SqlResultSet rs = stmt.executeQuery(sql);
            acquisitionHandler.resultSetCreated(dtsSession, rs);
            long rowNumber = 0L;
            while (rs.next()) {
                Object entity = entityClass.newInstance();
                OrmPersistenceUtil.getEntity(persistenceProxy, dtsSession, rs, entity);
                acquisitionHandler.entityAcquired(dtsSession, ++rowNumber, entity);
            }
            acquisitionHandler.entityAcquiredFinished(dtsSession, rowNumber);
            rs.close();
            acquisitionHandler.resultSetClosed(dtsSession, rs);
        }
        finally {
            stmt.close();
            acquisitionHandler.statementClosed(dtsSession, stmt);
        }
    }

    public static void addValues(Object entity, OrmPersistenceField persistenceField, boolean isPpst, List<Integer> sqlTypeList1, List<Integer> sqlTypeList2, BcInteger typeIndex, Collection<Object> valueCollection, BcInteger arrayIndex) throws Exception {
        ArrayList valueList1 = new ArrayList();
        if (!OrmPersistenceUtil.isAdd(persistenceField, isPpst)) {
            ++typeIndex.value;
            return;
        }
        if (entity == null) {
            if (!OrmPersistenceUtil.isTarget(persistenceField, arrayIndex)) {
                return;
            }
            valueCollection.add(null);
            sqlTypeList2.add(sqlTypeList1.get(typeIndex.value));
            ++typeIndex.value;
            return;
        }
        Class<?> valueClass = entity.getClass();
        if (valueClass.isArray()) {
            List<Object> valueList2 = OrmPersistenceUtil.getValueList_Array(entity, persistenceField, isPpst, sqlTypeList1, sqlTypeList2, typeIndex, arrayIndex);
            valueCollection.addAll(valueList2);
        } else if (OrmPersistenceUtil.isPersistence(valueClass)) {
            if (!OrmPersistenceUtil.isTarget(persistenceField, arrayIndex)) {
                return;
            }
            valueCollection.add(entity);
            sqlTypeList2.add(sqlTypeList1.get(typeIndex.value));
            ++typeIndex.value;
        } else {
            OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(valueClass);
            List<Object> valueList2 = entityContext.createValueList(entity, isPpst, sqlTypeList1, sqlTypeList2, typeIndex, arrayIndex);
            valueCollection.addAll(valueList2);
            List<Method> methodList = entityContext.getGetterMethodList();
            int i = 0;
            while (i < methodList.size()) {
                Method method = methodList.get(i);
                Object methodValue = method.invoke(valueClass, new Object[0]);
                valueCollection.add(methodValue);
                ++i;
            }
        }
    }

    public static boolean isTarget(OrmPersistenceField persistenceField, BcInteger arrayIndex) throws Exception {
        String columnName;
        if (arrayIndex == null) {
            return true;
        }
        boolean b = true;
        if (persistenceField != null && persistenceField.columnName().length > arrayIndex.value && BcStringUtil.isEmpty(columnName = persistenceField.columnName()[arrayIndex.value])) {
            b = false;
        }
        ++arrayIndex.value;
        return b;
    }

    public static List<Object> getValueList_Array(Object entity, OrmPersistenceField persistenceField, boolean isPpst, List<Integer> sqlTypeList1, List<Integer> sqlTypeList2, BcInteger typeIndex, BcInteger arrayIndex) throws Exception {
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (entity == null) {
            return valueList;
        }
        if (arrayIndex == null) {
            arrayIndex = new BcInteger();
        }
        int arrayLength = Array.getLength(entity);
        int i = 0;
        while (i < arrayLength) {
            Object entity2 = Array.get(entity, i);
            OrmPersistenceUtil.addValues(entity2, persistenceField, isPpst, sqlTypeList1, sqlTypeList2, typeIndex, valueList, arrayIndex);
            ++i;
        }
        return valueList;
    }

    public static boolean isAdd(OrmPersistenceField persistenceField, boolean isPpst) throws Exception {
        boolean isAdd = true;
        if (persistenceField != null && isPpst && persistenceField.isTimestamp()) {
            isAdd = false;
        }
        return isAdd;
    }

    public static void putPreTrans(DtsSession dtsSession, Object entity, String tableName) throws Exception {
        OrmOverwrite etdmOverwrite;
        OrmAddOnly etdmAddOnly;
        OrmDataId etdmDataId;
        Class<?> entityClass = entity.getClass();
        if (OrmAddition.class.isAssignableFrom(entityClass)) {
            OrmDataId etdmDataId2;
            long newOid;
            String dataName;
            OrmAddition etdmAddition = (OrmAddition)entity;
            if (etdmAddition.isAddition()) {
                dataName = MmdUtil.createTableColumnName(tableName, "sy_oid");
                newOid = OrmSequenceDAO.getInstance().generateNumber(dtsSession, dataName);
                OrmPersistenceUtil.insertNewRecord(dtsSession, tableName, "sy_oid", newOid);
                OrmPersistenceAddition.updateNextObjectId(dtsSession, tableName, etdmAddition.getObjectId(), newOid);
                etdmAddition.setObjectId((int)newOid);
                etdmAddition.setNoid(-1L);
            } else if (etdmAddition.getObjectId() <= 0L) {
                dataName = MmdUtil.createTableColumnName(tableName, "sy_oid");
                newOid = OrmSequenceDAO.getInstance().generateNumber(dtsSession, dataName);
                OrmPersistenceUtil.insertNewRecord(dtsSession, tableName, "sy_oid", newOid);
                etdmAddition.setObjectId(newOid);
                etdmAddition.setNoid(-1L);
            }
            etdmAddition.setAddTimestamp(BcTimeUtil.createCalendar());
            if (OrmDataId.class.isAssignableFrom(entityClass) && (etdmDataId2 = (OrmDataId)entity).getDataId() <= 0) {
                int newDataId = OrmSequenceDAO.getInstance().generateNumber_int(dtsSession, MmdUtil.createTableColumnName(tableName, "id"));
                etdmDataId2.setDataId(newDataId);
            }
        } else if (OrmDataId.class.isAssignableFrom(entityClass) && (etdmDataId = (OrmDataId)entity).getDataId() <= 0) {
            int newDataId = OrmSequenceDAO.getInstance().generateNumber_int(dtsSession, MmdUtil.createTableColumnName(tableName, "id"));
            etdmDataId.setDataId(newDataId);
            OrmPersistenceUtil.insertNewRecord(dtsSession, tableName, "id", newDataId);
        }
        if (OrmAddOnly.class.isAssignableFrom(entityClass) && (etdmAddOnly = (OrmAddOnly)entity).getDataId() <= 0) {
            int newDataId = OrmSequenceDAO.getInstance().generateNumber_int(dtsSession, MmdUtil.createTableColumnName(tableName, "id"));
            etdmAddOnly.setDataId(newDataId);
            OrmPersistenceUtil.insertNewRecord(dtsSession, tableName, "id", newDataId);
            etdmAddOnly.setAddTimestamp(BcTimeUtil.createCalendar());
        }
        if (OrmOverwrite.class.isAssignableFrom(entityClass) && (etdmOverwrite = (OrmOverwrite)entity).getDataId() > 0) {
            etdmOverwrite.setUpdateTimestamp(BcTimeUtil.createCalendar());
        }
    }

    public static int insertNewRecord(DtsSession dtsSession, String tableName, String columnName, long objectId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = " INSERT INTO " + tableName + " (" + columnName + ")" + " VALUES" + " (" + objectId + ")";
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }
}

