/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.comm.fx;

import ext.base.core.BcStringUtil;
import ext.lib.comm.CommSerialConstants;
import ext.lib.comm.CommSerialParameters;
import ext.lib.comm.common.CommWords;
import ext.lib.fx.control.FxComboBox;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import javafx.scene.Node;

public class CommSerialPortPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxComboBox portNameCombo = new FxComboBox();
    FxComboBox baudCombo = new FxComboBox();
    FxComboBox dataBitCombo = new FxComboBox();
    FxComboBox stopBitCombo = new FxComboBox();
    FxComboBox parityCombo = new FxComboBox();
    FxComboBox flowInCombo = new FxComboBox();
    FxComboBox flowOutCombo = new FxComboBox();

    public CommSerialPortPane() throws Exception {
        this.setComponent();
    }

    protected void setComponent() throws Exception {
        this.setCenter((Node)this.centerPane);
        this.portNameCombo.columnCount.set(8);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcStringUtil.margeArray2(CommWords.getInstance().Port_Name)), new Node[]{this.portNameCombo});
        this.centerPane.addNodeUnit(nodeUnit);
        int i = 0;
        while (i < CommSerialConstants.baudRates.length) {
            this.baudCombo.getItems().add((Object)Integer.toString(CommSerialConstants.baudRates[i]));
            ++i;
        }
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcStringUtil.margeArray2(CommWords.getInstance().Baud_Rate)), new Node[]{this.baudCombo});
        this.centerPane.addNodeUnit(nodeUnit);
        i = 0;
        while (i < CommSerialConstants.dataBits.length) {
            this.dataBitCombo.getItems().add((Object)Integer.toString(CommSerialConstants.dataBits[i]));
            ++i;
        }
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcStringUtil.margeArray2(CommWords.getInstance().Data_Bits)), new Node[]{this.dataBitCombo});
        this.centerPane.addNodeUnit(nodeUnit);
        i = 0;
        while (i < CommSerialConstants.stopBits.length) {
            this.stopBitCombo.getItems().add((Object)Float.toString(CommSerialConstants.stopBits[i]));
            ++i;
        }
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcStringUtil.margeArray2(CommWords.getInstance().Stop_Bits)), new Node[]{this.stopBitCombo});
        this.centerPane.addNodeUnit(nodeUnit);
        i = 0;
        while (i < CommSerialConstants.paritys.length) {
            this.parityCombo.getItems().add((Object)CommSerialConstants.paritys[i]);
            ++i;
        }
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcStringUtil.margeArray2(CommWords.getInstance().Parity)), new Node[]{this.parityCombo});
        this.centerPane.addNodeUnit(nodeUnit);
        i = 0;
        while (i < CommSerialConstants.flowIns.length) {
            this.flowInCombo.getItems().add((Object)CommSerialConstants.flowIns[i]);
            ++i;
        }
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcStringUtil.margeArray2(CommWords.getInstance().Flow_Control_In)), new Node[]{this.flowInCombo});
        this.centerPane.addNodeUnit(nodeUnit);
        i = 0;
        while (i < CommSerialConstants.flowOuts.length) {
            this.flowOutCombo.getItems().add((Object)CommSerialConstants.flowOuts[i]);
            ++i;
        }
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcStringUtil.margeArray2(CommWords.getInstance().Flow_Control_Out)), new Node[]{this.flowOutCombo});
        this.centerPane.addNodeUnit(nodeUnit);
    }

    public void setSerialParameters(CommSerialParameters serialParameters) {
        this.portNameCombo.getSelectionModel().select((Object)serialParameters.getPortName());
        this.baudCombo.getSelectionModel().select((Object)Integer.toString(serialParameters.getBaudRate()));
        this.dataBitCombo.getSelectionModel().select((Object)serialParameters.getDataBitsString());
        this.stopBitCombo.getSelectionModel().select((Object)serialParameters.getStopBitsString());
        this.parityCombo.getSelectionModel().select((Object)serialParameters.getParityString());
        this.flowInCombo.getSelectionModel().select((Object)serialParameters.getFlowControlInString());
        this.flowOutCombo.getSelectionModel().select((Object)serialParameters.getFlowControlOutString());
    }

    public CommSerialParameters getSerialParameters(CommSerialParameters serialParameters) throws Exception {
        if (serialParameters == null) {
            serialParameters = new CommSerialParameters();
        }
        serialParameters.setPortName((String)this.portNameCombo.getSelectionModel().getSelectedItem());
        serialParameters.setBaudRate((String)this.baudCombo.getSelectionModel().getSelectedItem());
        serialParameters.setDataBits((String)this.dataBitCombo.getSelectionModel().getSelectedItem());
        serialParameters.setStopBits((String)this.stopBitCombo.getSelectionModel().getSelectedItem());
        serialParameters.setParity((String)this.parityCombo.getSelectionModel().getSelectedItem());
        serialParameters.setFlowControlIn((String)this.flowInCombo.getSelectionModel().getSelectedItem());
        serialParameters.setFlowControlOut((String)this.flowOutCombo.getSelectionModel().getSelectedItem());
        return serialParameters;
    }
}

