/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.log.BcLogUtil;
import ext.base.util.BcISO;
import ext.base.util.BcLocaleEventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class BcLocaleUtil {
    protected static List<BcLocaleEventHandler> localeEventHandlerList = new ArrayList<BcLocaleEventHandler>();

    private BcLocaleUtil() {
    }

    public static Locale getLocaleByLangageCode(String langageCode) throws Exception {
        BcLogUtil.debug("getLocaleByLangageCode:langageCode=" + langageCode);
        Locale locale = null;
        if (BcISO.ISO_639_1.English.code.equals(langageCode)) {
            locale = Locale.US;
        } else if (BcISO.ISO_639_1.Japanese.code.equals(langageCode)) {
            locale = Locale.JAPANESE;
        }
        return locale;
    }

    public static void setDefault(Locale newLocale) throws Exception {
        Locale.setDefault(newLocale);
        BcLocaleUtil.fireLocaleChanged(newLocale);
    }

    public static void addLocaleEventHandler(BcLocaleEventHandler eventHandler) {
        localeEventHandlerList.add(eventHandler);
    }

    public static void removeLocaleEventHandler(BcLocaleEventHandler eventHandler) {
        localeEventHandlerList.remove(eventHandler);
    }

    public static void fireLocaleChanged(Locale newLocale) throws Exception {
        BcLocaleEventHandler[] eventHandlers = localeEventHandlerList.toArray(new BcLocaleEventHandler[0]);
        int i = 0;
        while (i < eventHandlers.length) {
            BcLocaleEventHandler eventHandler = eventHandlers[i];
            try {
                eventHandler.localeChanged(newLocale);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i;
        }
    }
}

