/*
 * Decompiled with CFR 0.152.
 */
package ext.base.thread;

import ext.base.log.BcLogUtil;
import ext.base.reflect.BcReflectUtil;

public final class BcThreadUtil {
    private BcThreadUtil() {
    }

    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup rootThreadGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup parentThreadGroup = rootThreadGroup.getParent();
        while (parentThreadGroup != null) {
            rootThreadGroup = parentThreadGroup;
            parentThreadGroup = parentThreadGroup.getParent();
        }
        return rootThreadGroup;
    }

    public static StringBuilder toStackTree(StackTraceElement[] stackTraceElements, int offset, int cnt) {
        int cnt2;
        StringBuilder sb = new StringBuilder();
        int offset2 = offset;
        if (offset2 <= 0) {
            offset = 0;
        }
        if ((cnt2 = cnt) <= 0) {
            cnt2 = stackTraceElements.length;
        }
        try {
            int i = 0;
            while (i < cnt2) {
                int index = stackTraceElements.length - i - 1 - offset;
                StackTraceElement stackTraceElement = stackTraceElements[index];
                if (i > 0) {
                    sb.append('/');
                }
                sb.append(BcReflectUtil.extractClassName(stackTraceElement.getClassName()));
                sb.append('#');
                sb.append(stackTraceElement.getMethodName());
                sb.append("[L" + stackTraceElement.getLineNumber() + "]");
                ++i;
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return sb;
    }

    public static StringBuilder toStackTree(int offset, int cnt) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        return BcThreadUtil.toStackTree(stackTraceElements, offset, cnt);
    }

    public static StringBuilder toStackTree() {
        return BcThreadUtil.toStackTree(-1, -1);
    }
}

