/*
 * Decompiled with CFR 0.152.
 */
package ext.base.thread;

import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.thread.BcThreadGroup;

public abstract class BcThread
extends Thread {
    protected final BcMonitor threadMonitor = new BcMonitor();
    protected boolean isStop;

    public BcThread() {
        super((ThreadGroup)BcThreadGroup.defaultThreadGroup, "no name");
        this.initThread();
    }

    public BcThread(String name) {
        super((ThreadGroup)BcThreadGroup.defaultThreadGroup, name);
        this.initThread();
    }

    public BcThread(ThreadGroup threadGroup, String name) {
        super(threadGroup, name);
        this.initThread();
    }

    public BcThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
        this.initThread();
    }

    protected void initThread() {
        this.setPriority(5);
    }

    @Override
    public final void run() {
        this.threadStratted();
        while (true) {
            this.threadMonitor.sync();
            if (this.isStop) break;
            try {
                this.run2();
            }
            catch (Exception ex) {
                this.threadError(ex);
            }
        }
        this.threadStoped();
    }

    public void startThread() {
        if (this.isAlive()) {
            this.threadMonitor.unLock();
        } else {
            this.start();
        }
    }

    public void stopThread() {
        this.isStop = true;
    }

    public synchronized void suspendThread() {
        if (this.isAlive()) {
            if (this.isStop()) {
                BcLogUtil.debug(String.valueOf(this.getName()) + " is stopped.");
            } else if (this.threadMonitor.isLock()) {
                BcLogUtil.debug("monitor is locked.");
            } else {
                this.threadMonitor.lock();
            }
        } else {
            BcLogUtil.debug(String.valueOf(this.getName()) + " is not alive.");
        }
    }

    public boolean isStop() {
        return this.isStop;
    }

    protected void threadError(Throwable throwable) {
        BcLogUtil.error(throwable);
    }

    protected void threadStratted() {
    }

    protected abstract void run2() throws Exception;

    protected void threadStoped() {
    }
}

