/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class NimRODSpinnerUI
extends BasicSpinnerUI {
    protected boolean oldOpaque;

    public static ComponentUI createUI(JComponent c) {
        return new NimRODSpinnerUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.oldOpaque = this.spinner.isOpaque();
        this.spinner.setOpaque(false);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.spinner.setOpaque(this.oldOpaque);
    }

    @Override
    protected Component createPreviousButton() {
        Component c = this.createArrowButton(5);
        c.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(c);
        return c;
    }

    @Override
    protected Component createNextButton() {
        Component c = this.createArrowButton(1);
        c.setName("Spinner.nextButton");
        this.installNextButtonListeners(c);
        return c;
    }

    private Component createArrowButton(int direction) {
        NimRODArrowButton b = new NimRODArrowButton(direction);
        b.setInheritsPopupMenu(true);
        return b;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        g.setColor(c.getBackground());
        g.fillRect(2, 3, c.getWidth() - 4, c.getHeight() - 6);
        g.drawLine(3, 2, c.getWidth() - 4, 2);
        g.drawLine(3, c.getHeight() - 3, c.getWidth() - 4, c.getHeight() - 3);
        JComponent editor = this.spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            JFormattedTextField text = ((JSpinner.DefaultEditor)editor).getTextField();
            text.setBackground(c.getBackground());
        }
    }

    class NimRODArrowButton
    extends JButton {
        private static final long serialVersionUID = 3031842923932443184L;
        private int dir;

        public NimRODArrowButton(int direction) {
            this.setRequestFocusEnabled(false);
            this.dir = direction;
            if (direction == 1) {
                this.setIcon(UIManager.getIcon("Spinner.nextIcon"));
            } else {
                this.setIcon(UIManager.getIcon("Spinner.previousIcon"));
            }
            this.setOpaque(false);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(15, this.getIcon().getIconHeight());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void paint(Graphics g) {
            int y;
            Icon icon = this.getIcon();
            int w = this.getWidth() - 1;
            int h = this.getHeight() - 1;
            int x = (w - icon.getIconWidth()) / 2;
            int yf = y = (h - icon.getIconHeight()) / 2;
            Border bb = ((JSpinner)this.getParent()).getBorder();
            if (bb != null) {
                if (this.dir == 1) {
                    y += bb.getBorderInsets((Component)this).top / 2;
                    yf = bb.getBorderInsets((Component)this).top - 2;
                } else {
                    yf = this.getHeight() - bb.getBorderInsets((Component)this).bottom;
                }
                w -= 3;
            }
            icon.paintIcon(this, g, x, y);
            if (this.dir == 1) {
                g.setColor(NimRODUtils.getBrillo());
                g.drawLine(1, yf, 1, h);
                g.setColor(NimRODUtils.getSombra());
                g.drawLine(1, h, w, h);
                g.drawLine(0, yf, 0, h);
            } else {
                g.setColor(NimRODUtils.getBrillo());
                g.drawLine(1, 0, w, 0);
                g.drawLine(1, 0, 1, yf);
                g.setColor(NimRODUtils.getSombra());
                g.drawLine(0, 0, 0, yf);
            }
        }
    }
}

