/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.dao;

import java.sql.ResultSet;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWarningException;
import jp.co.extreme.datasource.DtsConnectionManager;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.orm.persistence.OrmEntityContext;
import jp.co.extreme.orm.persistence.OrmEntityContextManager;
import jp.co.extreme.scf4.model.ScfLock;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class ScfLockDAO
extends OrmAbstractDAO<ScfLock> {
    protected DtsConnectionManager connectionManager;

    private ScfLockDAO() {
        super(new ScfLock[0]);
        this.setTableName("frwk_lock");
    }

    public static ScfLockDAO getInstance() {
        return SingletonHolder.instance;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean lock(String lockName, String groupName, Object owner, String note) throws Exception {
        status = -1;
        recordExist = false;
        updateCount = 0;
        sqlConn = this.getConnection();
        sqlContext = sqlConn.getSqlContext();
        try {
            block14: {
                block15: {
                    query = "SELECT status FROM " + this.tableName + " WHERE name" + sqlContext.toCondition_string("=", lockName) + " FOR UPDATE";
                    stmt = sqlConn.createStatement();
                    try {
                        rs = stmt.executeQuery(query);
                        if (rs.next()) {
                            status = rs.getShort(1);
                            recordExist = true;
                        }
                        rs.close();
                    }
                    finally {
                        stmt.close();
                    }
                    if (!recordExist) break block14;
                    if (status != 0) break block15;
                    updateCount = this.updateToLock(sqlConn, lockName, groupName, owner, note);
                    ** GOTO lbl32
                }
                return false;
            }
            updateCount = this.insertLock(sqlConn, lockName, groupName, owner, note);
lbl32:
            // 2 sources

            sqlConn.commit();
        }
        finally {
            sqlConn.close();
        }
        return updateCount > 0;
    }

    public synchronized boolean lock(String lockName, Object owner, String note) throws Exception {
        return this.lock(lockName, null, owner, note);
    }

    public synchronized boolean lock(String lockName, Object owner) throws Exception {
        return this.lock(lockName, owner, null);
    }

    public synchronized boolean lock(String lockName, long intervalMiilis, int tryMax, String groupName, Object owner, String note) throws Exception {
        int tryCnt = 0;
        while (++tryCnt <= tryMax) {
            if (this.lock(lockName, groupName, owner, note)) {
                return true;
            }
            BcLogUtil.debug("\u30ed\u30c3\u30af\u5931\u6557 \uff1a\u30ed\u30c3\u30af\u540d=" + lockName + " \u8a66\u884c\u9593\u9694\uff08\u30df\u30ea\u79d2\uff09=" + intervalMiilis + " \u8a66\u884c\u56de\u6570=" + tryCnt + "/" + tryMax);
            Thread.sleep(intervalMiilis);
        }
        return false;
    }

    public synchronized boolean lock(String lockName, long intervalMiilis, int tryMax, String groupName, Object owner) throws Exception {
        return this.lock(lockName, intervalMiilis, tryMax, groupName, owner, null);
    }

    public synchronized boolean lock(String lockName, Object owner, long intervalMiilis, int tryMax) throws Exception {
        return this.lock(lockName, intervalMiilis, tryMax, null, owner);
    }

    public synchronized boolean lockExeption(String lockName, String groupName, Object owner, String note) throws Exception {
        boolean locked = this.lock(lockName, groupName, owner, note);
        if (!locked) {
            String note2 = this.getNote(lockName);
            throw new BcWarningException(this.lockSFailureMessage(lockName, note2));
        }
        return true;
    }

    public synchronized boolean lockExeption(String lockName, Object owner, String note) throws Exception {
        return this.lockExeption(lockName, null, owner, note);
    }

    public synchronized boolean lockExeption(String lockName, long intervalMiilis, int tryMax, String groupName, Object owner, String note) throws Exception {
        boolean locked = this.lock(lockName, intervalMiilis, tryMax, groupName, owner, note);
        if (!locked) {
            String note2 = this.getNote(lockName);
            throw new BcWarningException(this.lockSFailureMessage(lockName, note2));
        }
        return true;
    }

    public synchronized boolean lockExeption(String lockName, Object owner, String note, long intervalMiilis, int tryMax) throws Exception {
        return this.lockExeption(lockName, intervalMiilis, tryMax, null, owner, note);
    }

    public synchronized boolean lockExeption(String lockName, Object owner, long intervalMiilis, int tryMax) throws Exception {
        return this.lockExeption(lockName, owner, null, intervalMiilis, tryMax);
    }

    public synchronized boolean unlock(String lockName, boolean doDelete) throws Exception {
        int updateCount = 0;
        try (SqlConnection sqlConn = this.getConnection();){
            updateCount = doDelete ? this.deleteLock(sqlConn, lockName) : this.updateToUnock(sqlConn, lockName);
            sqlConn.commit();
        }
        return updateCount > 0;
    }

    public synchronized boolean unlock(String lockName) throws Exception {
        return this.unlock(lockName, false);
    }

    public List<ScfLock> getListByGroupName(DtsSession dtsSession, String groupName, Integer status) throws Exception {
        SqlWhereElement whereElement;
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        OrmEntityContext entityContext = OrmEntityContextManager.getInstance().getEntityContext(this.getEntityClass());
        selectQuery.getSelectColumnList().addAll(entityContext.getColumnNameList(null));
        selectQuery.setFromClause(this.tableName);
        if (!BcStringUtil.isEmpty(groupName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("group_name" + sqlContext.toCondition_string("=", groupName));
            selectQuery.addWhereElement(whereElement);
        }
        if (status != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("status = " + status);
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.getOrderByList().add("group_name");
        selectQuery.getOrderByList().add("name");
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    protected int insertLock(SqlConnection sqlConn, String lockName, String groupName, Object owner, Object note) throws Exception {
        SqlContext sqlContext = sqlConn.getSqlContext();
        String query = "INSERT INTO " + this.tableName + " (name, status, start_timestamp, group_name, owner, note_)" + " VALUES (" + sqlContext.toSet(lockName) + "," + 1 + "," + sqlContext.func_clockTimestamp() + "," + sqlContext.toSet(groupName) + "," + sqlContext.toSet(BcStringUtil.toString(owner)) + "," + sqlContext.toSet(BcStringUtil.toString(note)) + ")";
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    protected int updateToLock(SqlConnection sqlConn, String lockName, String groupName, Object owner, Object note) throws Exception {
        SqlContext sqlContext = sqlConn.getSqlContext();
        String query = "UPDATE " + this.tableName + " SET " + "status=" + 1 + ",start_timestamp = " + sqlContext.func_clockTimestamp() + ",end_timestamp = Null" + ",group_name = " + sqlContext.toSet(groupName) + ",owner = " + sqlContext.toSet(BcStringUtil.toString(owner)) + ",note_ = " + sqlContext.toSet(BcStringUtil.toString(note)) + " WHERE name" + sqlContext.toCondition_string("=", lockName);
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    protected int updateToUnock(SqlConnection sqlConn, String lockName) throws Exception {
        SqlContext sqlContext = sqlConn.getSqlContext();
        String query = "UPDATE " + this.tableName + " SET " + "status = " + 0 + ",end_timestamp = " + sqlContext.func_clockTimestamp() + " WHERE name" + sqlContext.toCondition_string("=", lockName);
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public int deleteLock(SqlConnection sqlConn, String lockName) throws Exception {
        SqlContext sqlContext = sqlConn.getSqlContext();
        String query = "DELETE FROM " + this.tableName + " WHERE name" + sqlContext.toCondition_string("=", lockName) + " AND status = " + 1;
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public int delete(SqlConnection sqlConn, String lockName) throws Exception {
        SqlContext sqlContext = sqlConn.getSqlContext();
        String query = "DELETE FROM " + this.tableName + " WHERE name" + sqlContext.toCondition_string("=", lockName);
        return SqlUtil.executeUpdate(sqlConn, query);
    }

    public String getNote(String lockName) throws Exception {
        String sql = "SELECT note_ FROM " + this.tableName + " WHERE name='" + lockName + "'";
        String note = null;
        try (SqlConnection sqlConn = this.getConnection();){
            SqlStatement stmt = sqlConn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                note = rs.getString(1);
            }
            rs.close();
            stmt.close();
        }
        return note;
    }

    protected synchronized SqlConnection getConnection() throws Exception {
        SqlConnection sqlConn = null;
        if (this.connectionManager == null) {
            DtsSessionFactory dtsSessionFactoryMain = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
            this.connectionManager = dtsSessionFactoryMain.getConnectionManager();
        }
        sqlConn = this.connectionManager.getConnection(this);
        return sqlConn;
    }

    protected String lockSFailureMessage(String lockName, String note) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\u30ed\u30c3\u30af\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        if (!BcStringUtil.isEmpty(note)) {
            sb.append("\u88dc\u8db3\u60c5\u5831:");
            sb.append(note);
        }
        return sb.toString();
    }

    protected String unlockSFailureMessage(CharSequence lockName, CharSequence note) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\u30ed\u30c3\u30af\u89e3\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        if (!BcStringUtil.isEmpty(note)) {
            sb.append("\u88dc\u8db3\u60c5\u5831:");
            sb.append(note);
        }
        return sb.toString();
    }

    public int selectForUpdate(SqlConnection sqlConn, String lockName) throws Exception {
        SqlContext sqlContext = sqlConn.getSqlContext();
        String query = "SELECT name FROM " + this.tableName + " WHERE name" + sqlContext.toCondition_string("=", lockName) + " FOR UPDATE NOWAIT";
        int cnt = 0;
        try (SqlStatement stmt = sqlConn.createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                ++cnt;
            }
            rs.close();
        }
        return cnt;
    }

    /* synthetic */ ScfLockDAO(ScfLockDAO scfLockDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final ScfLockDAO instance = new ScfLockDAO(null);

        private SingletonHolder() {
        }
    }
}

