/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.client;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.stub.ScfHandleStub;
import jp.co.extreme.scf3.client.ScfSqlClientTask;
import jp.co.extreme.scf3.stub.ScfDatabaseStub;
import jp.co.extreme.scf4.client.ScfOnlineTableModelClient;

public class ScfSqlClientOnlineTask
extends ScfSqlClientTask {
    private ScfOnlineTableModelClient onlineTableModelClient;
    private List<Integer> rowNumberList;

    public ScfOnlineTableModelClient getOnlineTableModelClient() {
        return this.onlineTableModelClient;
    }

    public void setOnlineTableModelClient(ScfOnlineTableModelClient onlineTableModelClient) {
        this.onlineTableModelClient = onlineTableModelClient;
    }

    public List<Integer> getRowNumberList() {
        return this.rowNumberList;
    }

    @Override
    public Object taskProcess() throws Exception {
        this.setStatusId(ScfSqlClientTask.Status.running.id);
        if (this.getHandleId() == null) {
            this.started();
            RmiRespons rmiRes = this.getLocalAgent().invoke(this.getRequest());
            Object object = this.setRespons1(rmiRes);
        }
        try {
            while (!this.eod) {
                if (this.getStatusId() != ScfSqlClientTask.Status.running.id) {
                    break;
                }
                this.loadRows();
            }
        }
        finally {
            try {
                ScfHandleStub.getInstance().removeHandle(this.getLocalAgent(), this.getHandleId());
            }
            finally {
                this.setStatusId(ScfSqlClientTask.Status.idling.id);
            }
        }
        this.loaded(this.eod);
        return this.loadedRowSize;
    }

    @Override
    protected void loadRows() throws Exception {
        this.rowNumberList = this.onlineTableModelClient.getEmptyRowNumberList(this.requireRowCount);
        if (BcCollectionUtil.isEmpty(this.rowNumberList)) {
            this.eod = true;
            return;
        }
        String rowNumbers = BcStringUtil.toCsv(this.rowNumberList).toString();
        List<List> rowList = ScfDatabaseStub.getInstance().getRowByRowNumbers(this.getLocalAgent(), this.getHandleId(), rowNumbers);
        this.rowListReceived(rowList);
    }
}

