/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcObjectConvertor;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.module.mmdx.common.MmdxUtil;
import jp.co.extreme.module.xsys.validation.XsysFieldKeyCreator;
import jp.co.extreme.web.server.WbsUrlParameterMap;

public class WbxParameterUtil
extends BcLoggableObject {
    public static char delimiter = (char)46;

    public static WbxParameterUtil getInstance() {
        return SingletonHolder.instance;
    }

    protected void setFieldValue(Map<String, Object> paramMap, Object entity, String entityName, Field field, MmdField mmdField) throws Exception {
        if (mmdField.dataClass.isArray()) {
            Object array = field.get(entity);
            if (array == null) {
                return;
            }
            Class<?> componentType = array.getClass().getComponentType();
            int arrayLength = Array.getLength(array);
            int i = 0;
            while (i < arrayLength) {
                String key = XsysFieldKeyCreator.getInstance().createKey(i, entityName, field.getName());
                Object filedValue = this.conv(paramMap, field, key, componentType);
                Array.set(array, i, filedValue);
                ++i;
            }
        } else if (List.class.isAssignableFrom(mmdField.dataClass)) {
            field.setAccessible(true);
            ArrayList list = (ArrayList)field.get(entity);
            if (list == null) {
                list = new ArrayList();
            }
            String prefix = String.valueOf(XsysFieldKeyCreator.getInstance().createKey(entityName, field.getName())) + "[";
            for (Map.Entry<String, Object> mapEntry : paramMap.entrySet()) {
                if (!mapEntry.getKey().startsWith(prefix)) continue;
                String tmpStr = mapEntry.getKey().substring(prefix.length(), mapEntry.getKey().length() - 1);
                int index = Integer.parseInt(tmpStr);
                BcCollectionUtil.setElement(list, index, mapEntry.getValue());
            }
            this.getLogger().debug("list=" + list);
            BcReflectUtil.setFieldValue(mmdField.fieldName, entity, list);
        } else {
            String key = XsysFieldKeyCreator.getInstance().createKey(entityName, field.getName());
            Object filedValue = this.conv(paramMap, field, key, field.getType());
            BcReflectUtil.setFieldValue(mmdField.fieldName, entity, filedValue);
        }
    }

    protected Object conv(Map<String, Object> paramMap, Field field, String key, Class type) throws Exception {
        Object mapValue = paramMap.get(key);
        if (mapValue == null) {
            String key2 = String.valueOf(key) + "[]";
            mapValue = paramMap.get(key2);
        }
        Object filedValue = null;
        if (mapValue instanceof List) {
            List valueList = (List)mapValue;
            filedValue = BcStringUtil.toCsv(valueList);
        } else if (Boolean.class.isAssignableFrom(field.getType())) {
            if (mapValue != null) {
                filedValue = true;
            }
        } else if (!BcStringUtil.isEmpty(mapValue)) {
            filedValue = BcObjectConvertor.getInstance().convert(mapValue, type);
        }
        return filedValue;
    }

    protected boolean enabled(Field field, MmdField mmdField) throws Exception {
        return !Modifier.isTransient(field.getModifiers());
    }

    public void setFieldValue(Map<String, Object> paramMap, Object entity, String entityName) throws Exception {
        List<Map.Entry<Field, MmdField>> mapEntryList = MmdxUtil.createFieldEntryList(entity.getClass());
        int i = 0;
        while (i < mapEntryList.size()) {
            MmdField mmdField;
            Map.Entry<Field, MmdField> mapEntry = mapEntryList.get(i);
            Field field = mapEntry.getKey();
            if (this.enabled(field, mmdField = mapEntry.getValue())) {
                this.setFieldValue(paramMap, entity, entityName, field, mmdField);
            }
            ++i;
        }
    }

    public void setFieldValue(Map<String, Object> paramMap, Object entity) throws Exception {
        this.setFieldValue(paramMap, entity, entity.getClass().getSimpleName());
    }

    public void setToParamMap(Object entity, String entityName, Map<String, Object> paramMap) throws Exception {
        List<Map.Entry<Field, MmdField>> mapEntryList = MmdxUtil.createFieldEntryList(entity.getClass());
        int i = 0;
        while (i < mapEntryList.size()) {
            MmdField mmdField;
            Map.Entry<Field, MmdField> mapEntry = mapEntryList.get(i);
            Field field = mapEntry.getKey();
            if (this.enabled(field, mmdField = mapEntry.getValue())) {
                Object fieldValue = BcReflectUtil.getFieldValue(field, entity);
                String key = XsysFieldKeyCreator.getInstance().createKey(entityName, field.getName());
                paramMap.put(key, fieldValue);
            }
            ++i;
        }
    }

    public WbsUrlParameterMap createParamMap(Object ... entitys) throws Exception {
        WbsUrlParameterMap paramMap = new WbsUrlParameterMap();
        int i = 0;
        while (i < entitys.length) {
            Object entity = entitys[i];
            this.setToParamMap(entity, entity.getClass().getSimpleName(), paramMap);
            ++i;
        }
        return paramMap;
    }

    private static final class SingletonHolder {
        private static final WbxParameterUtil instance = new WbxParameterUtil();

        private SingletonHolder() {
        }
    }
}

