/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.util.Calendar;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.module.xweb.common.CalendarTableCreator;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;

public abstract class CalendarTableCreatorNavi
extends CalendarTableCreator {
    @Override
    public StringBuilder create(int year, int month) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.createMonthNavi(year, month));
        sb.append((CharSequence)super.create(year, month));
        return sb;
    }

    protected StringBuilder createMonthNavi(int year, int month) throws Exception {
        Calendar currentMonth = BcTimeUtil.toCalendarMonthId(year, month - 1, 1);
        StringBuilder sb = new StringBuilder();
        sb.append(this.htmlBuilder.table_start(null, "100%", null));
        sb.append(this.htmlBuilder.tr_start());
        sb.append(this.htmlBuilder.tableCell(-1, -1, 2, -1));
        Calendar preMonth = (Calendar)currentMonth.clone();
        preMonth.add(2, -1);
        String preMonthLink = this.createPreviousMonthLink(preMonth.get(1), preMonth.get(2) + 1);
        sb.append(preMonthLink);
        sb.append(this.htmlBuilder.td_end());
        sb.append(this.htmlBuilder.tableCell(-1, -1, 0, -1));
        sb.append(this.creatCurrentMonth(year, month));
        sb.append(this.htmlBuilder.td_end());
        sb.append(this.htmlBuilder.tableCell(-1, -1, 4, -1));
        Calendar nextMonth = (Calendar)currentMonth.clone();
        nextMonth.add(2, 1);
        String nextMonthLink = this.createNextMonthLink(nextMonth.get(1), nextMonth.get(2) + 1);
        sb.append(nextMonthLink);
        sb.append(this.htmlBuilder.td_end());
        sb.append(this.htmlBuilder.tr_end());
        sb.append(this.htmlBuilder.table_end());
        return sb;
    }

    protected String creatCurrentMonth(int year, int month) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(year) + " \u5e74 " + month + " \u6708");
        return sb.toString();
    }

    protected String createPreviousMonthLink(int year, int month) throws Exception {
        StringBuilder sb = new StringBuilder();
        String url = this.createMonthUrl(year, month);
        String link = XwebHtmlBuilder.getInstance().link_underLine(url, "<\u524d\u6708", null);
        sb.append(link);
        return sb.toString();
    }

    protected String createNextMonthLink(int year, int month) throws Exception {
        StringBuilder sb = new StringBuilder();
        String url = this.createMonthUrl(year, month);
        String link = XwebHtmlBuilder.getInstance().link_underLine(url, "\u6b21\u6708>", null);
        sb.append(link);
        return sb.toString();
    }

    protected abstract String createMonthUrl(int var1, int var2) throws Exception;
}

