/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.web;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.thread.BcMonitor;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.module.webserver.WebServerController;
import jp.co.extreme.module.xsys.web.XsysHttpServerTask;
import jp.co.extreme.task.TskAbstractCallable2;
import jp.co.extreme.task.TskCallableUnit;
import jp.co.extreme.task.TskTaskManager;
import jp.co.extreme.web.server.WbsSiteContext;
import org.eclipse.jetty.util.component.LifeCycle;

public class XsysWebServerController
extends BcLoggableObject
implements WebServerController {
    InnerHttpServerTask task;
    BcMonitor monitor = new BcMonitor();

    @Override
    public BcResult start(WbsSiteContext siteContext, String hostName, int port, int sessionTimeout) throws Exception {
        if (this.task == null) {
            this.task = new InnerHttpServerTask();
        }
        this.task.setLogger(this.getLogger());
        this.task.siteContext = siteContext;
        this.task.hostName = hostName;
        this.task.port = port;
        this.task.sessionTimeout = sessionTimeout;
        this.task.url = "http://" + hostName + ":" + port;
        this.monitor.lock();
        ExecutorService executorService = Executors.newCachedThreadPool();
        this.task.future = executorService.submit(this.task);
        executorService.shutdown();
        BcResult result = new BcResult();
        this.monitor.sync();
        if (this.task.getThrowable() == null) {
            TskCallableUnit callableUnit = new TskCallableUnit((TskAbstractCallable2)this.task, this.task.future);
            TskTaskManager.getInstance().addCallableUnit(callableUnit);
        } else {
            result.addError(this.task.getThrowable());
        }
        result.setUserObject(this.task.url);
        return result;
    }

    @Override
    public BcResult stop() throws Exception {
        BcResult result = new BcResult();
        try {
            this.task.server.stop();
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            result.addError(ex);
        }
        return result;
    }

    class InnerHttpServerTask
    extends XsysHttpServerTask {
        InnerHttpServerTask() {
        }

        @Override
        public void lifeCycleStarted(LifeCycle lifeCycle) {
            super.lifeCycleStarted(lifeCycle);
            XsysWebServerController.this.monitor.unLock();
        }

        @Override
        public void lifeCycleFailure(LifeCycle lifeCycle, Throwable throwable) {
            this.getLogger().warning("####### lifeCycleFailure:throwable=" + throwable);
            super.lifeCycleFailure(lifeCycle, throwable);
            XsysWebServerController.this.monitor.unLock();
        }
    }
}

