/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsys.fx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxTabPane;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.fx.XdtsWebServerSetting;
import jp.co.extreme.module.xdts.stub.XdtsHttpServerStub;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.module.xsys.common.XsysWords;
import jp.co.extreme.module.xsys.fx.XsysStagePane;
import jp.co.extreme.module.xsys.fx.XsysWebConfigPane;
import jp.co.extreme.module.xsys.fx.XsysWebServerSetting;
import jp.co.extreme.module.xsys.rmo.XsysWebServerRMO;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf4.fx.HfxProcessingPane;
import jp.co.extreme.web.server.WbsSiteContext;

public class XsysWebServerPane
extends XsysStagePane {
    FxBorderPane borderPane = new FxBorderPane();
    FxTabPane tabPane = new FxTabPane();
    FxButton startButton = FxUtil.createStartButton();
    FxButton stopButton = FxUtil.createStopButton();
    FxButton closeButton = FxUtil.createCloseButton();
    List<String> classNmaeList = new ArrayList<String>();
    List<XsysWebServerSetting> httpServerSubList = new ArrayList<XsysWebServerSetting>();
    WbsSiteContext siteContext;

    public XsysWebServerPane() throws Exception {
        this.initComponant();
        this.classNmaeList.add(XsysWebConfigPane.class.getName());
        AfbApplication application = AfbApplication.getInstance();
        String appType = application.properties.getProperty("type");
        if (XsysConstants.AppType.DatabaseClient.appType.equals(appType)) {
            this.classNmaeList.add(XdtsWebServerSetting.class.getName());
        }
        this.setupTab();
        WbsSiteContext siteContext = XdtsHttpServerStub.getInstance().getSiteContext();
        this.setData(siteContext);
    }

    protected void initComponant() throws Exception {
        this.tabPane.setSide(Side.TOP);
        this.borderPane.setCenter((Node)this.tabPane);
        this.startButton.setOnAction(this.actionEventHandler);
        this.stopButton.setOnAction(this.actionEventHandler);
        FlowPane flowPane2 = new FlowPane();
        flowPane2.setOrientation(Orientation.HORIZONTAL);
        flowPane2.setAlignment(Pos.CENTER);
        flowPane2.setHgap(8.0);
        flowPane2.getChildren().addAll((Object[])new Node[]{this.startButton, this.stopButton});
        flowPane2.setPrefHeight(40.0);
        this.borderPane.setBottom((Node)flowPane2);
        this.setCenter((Node)this.borderPane);
        this.underLineEnabled();
        this.closeButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.closeButton);
        this.stopButton.setDisable(true);
        FxUtil.defaultInitialize((Node)this);
    }

    private void setupTab() throws Exception {
        for (String classNmae : this.classNmaeList) {
            XsysWebServerSetting webServerSetting = (XsysWebServerSetting)BcReflectUtil.createInstance(classNmae);
            this.httpServerSubList.add(webServerSetting);
            webServerSetting.setTab(this.tabPane);
        }
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setData(WbsSiteContext siteContext) throws Exception {
        this.siteContext = siteContext;
        String jsonStr = siteContext.propertyMap.get(XdtsConstants.Property.webServer.name());
        Map map = (Map)JacksonUtil.getObjectMapper().readValue(jsonStr, Map.class);
        for (XsysWebServerSetting webServerSetting : this.httpServerSubList) {
            webServerSetting.setData(map);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.startButton) {
            BcResult result = new BcResult();
            for (XsysWebServerSetting webServerSetting : this.httpServerSubList) {
                result.addResult(webServerSetting.validate());
            }
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().warning, 2);
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (XsysWebServerSetting httpServerSub : this.httpServerSubList) {
                httpServerSub.storeData(map);
            }
            String jsonStr = JacksonUtil.getObjectMapper().writeValueAsString(map);
            this.siteContext.propertyMap.put(XdtsConstants.Property.webServer.name(), jsonStr);
            this.startButton.setDisable(true);
            RmiRequest rmiReq = new RmiRequest();
            rmiReq.setClassName(XsysWebServerRMO.class.getName());
            rmiReq.setMethodName(XsysWebServerRMO.Method.start.name());
            rmiReq.addData(this.siteContext);
            InnerProcessingPane processingPane = new InnerProcessingPane();
            processingPane.setRequest(rmiReq);
            processingPane.successfullyMessageEnable = false;
            processingPane.show(String.valueOf(XsysWords.getInstance().WEB_Server) + " starting...", (Window)this.getStage());
        } else if (ev.getSource() == this.stopButton) {
            this.stopButton.setDisable(true);
            try {
                BcResult result = XdtsHttpServerStub.getInstance().stop();
                this.startButton.setDisable(false);
            }
            catch (Exception ex) {
                this.stopButton.setDisable(false);
            }
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    @Override
    public void close() {
        this.getStage().hide();
    }

    @Override
    protected Stage createStage() throws Exception {
        Stage stage = super.createStage();
        stage.setWidth(960.0);
        stage.setHeight(640.0);
        stage.setResizable(false);
        stage.getIcons().clear();
        stage.getIcons().add((Object)FxImageHelper.getImage("web_64x64.png"));
        return stage;
    }

    class InnerProcessingPane
    extends HfxProcessingPane {
        @Override
        protected void successed() {
            super.successed();
            this.getLogger().error("successed:");
            try {
                FxPlatform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RmiRespons rmiRes = InnerProcessingPane.this.getResponse();
                            BcResult result3 = (BcResult)rmiRes.getData();
                            if (result3.hasError()) {
                                String msg = BcMessageCreator.getInstance().createMessage(result3.getErrorList());
                                FxOptionPane.showMessageDialog((Node)XsysWebServerPane.this, (Object)msg, BcWords.getInstance().error, 0);
                                ((InnerProcessingPane)InnerProcessingPane.this).XsysWebServerPane.this.startButton.setDisable(false);
                            } else {
                                ((InnerProcessingPane)InnerProcessingPane.this).XsysWebServerPane.this.stopButton.setDisable(false);
                                String url = (String)result3.getUserObject();
                                InnerProcessingPane.this.getLogger().info("url=" + url);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
            }
        }
    }
}

