/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.swg;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.swg.XfilImagePanel;
import jp.co.extreme.swing.SwgImagePanel;
import jp.co.extreme.swing.SwgTableCellRenderer;

class XfilThumbnailCellRenderer
extends SwgTableCellRenderer {
    int columnId_entityId;
    int columnId_image_files;
    Map<Long, Component> componentMap = new HashMap<Long, Component>();
    Label dummyLabel = new Label();
    BufferedImage emptyImage;
    ValidationTask validationTask;
    Timer validationTaskTimer;
    int columnIndex;
    JTable tableView2;

    public XfilThumbnailCellRenderer() throws Exception {
        this.columnId_entityId = this.columnId_entityId;
    }

    @Override
    public Component getTableCellRendererComponent(JTable tableView, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        Component component = null;
        try {
            BcTableModel tableModel = (BcTableModel)tableView.getModel();
            long entityId = (Long)tableModel.getValueAt(rowIndex, this.columnId_entityId);
            component = this.getComponent(value, entityId);
            if (component != null) {
                this.setColor(tableView, isSelected, hasFocus, rowIndex, columnIndex, component);
            }
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return component;
    }

    protected Component getComponent(Object value, long entityId) throws Exception {
        Component component = this.componentMap.get(entityId);
        if (component == null) {
            component = this.createComponent(value, entityId);
            if (component != null) {
                this.componentMap.put(entityId, component);
            } else {
                this.componentMap.put(entityId, this.dummyLabel);
            }
        } else if (component == this.dummyLabel) {
            component = null;
        }
        return component;
    }

    protected Component createComponent(Object value, long entityId) throws Exception {
        JPanel component = null;
        String csv = (String)value;
        List<Image> bufferedImageList = this.createBufferedImageIlist(entityId, csv);
        if (BcCollectionUtil.isEmpty(bufferedImageList)) {
            return component;
        }
        ArrayList<XfilImagePanel> ImagePanelList = new ArrayList<XfilImagePanel>();
        int i = 0;
        while (i < bufferedImageList.size()) {
            Image bufferedImage = bufferedImageList.get(i);
            XfilImagePanel imagePanel = new XfilImagePanel();
            imagePanel.setKeepRatio(true);
            imagePanel.setScaling(true);
            imagePanel.setImage(bufferedImage);
            imagePanel.setPreferredSize(new Dimension(240, 20));
            ImagePanelList.add(imagePanel);
            ++i;
        }
        JPanel panel = new JPanel();
        GridLayout gridLayout = new GridLayout();
        gridLayout.setHgap(1);
        gridLayout.setVgap(1);
        gridLayout.setColumns(5);
        panel.setLayout(gridLayout);
        int i2 = 0;
        while (i2 < ImagePanelList.size()) {
            SwgImagePanel imagePanel = (SwgImagePanel)ImagePanelList.get(i2);
            panel.add(imagePanel);
            imagePanel.setUserObject(i2);
            ++i2;
        }
        component = panel;
        return component;
    }

    protected List<Image> createBufferedImageIlist(long entityId, String csv) throws Exception {
        ArrayList<Image> bufferedImageList = null;
        if (BcStringUtil.isEmpty(csv)) {
            return bufferedImageList;
        }
        List<String> fileNameList = BcCsvUtil.parseCsvRow(csv, true);
        File dir = XfilUtil.getThumbnailDir(entityId);
        bufferedImageList = new ArrayList<Image>();
        int i = 0;
        while (i < fileNameList.size()) {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = this.createBufferedImage(entityId, fileNameList, i);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            if (bufferedImage == null) {
                bufferedImage = this.getEmptyImage();
            }
            bufferedImageList.add(bufferedImage);
            ++i;
        }
        return bufferedImageList;
    }

    protected BufferedImage createBufferedImage(long entityId, List<String> fileNameList, int index) throws Exception {
        File dir = XfilUtil.getThumbnailDir(entityId);
        String fileName = fileNameList.get(index);
        File file = new File(dir, fileName);
        BufferedImage bufferedImage = null;
        if (file.exists()) {
            bufferedImage = AwtImageUtil.loadImage(file);
        }
        return bufferedImage;
    }

    protected Object[] getImage(JTable tableView, int rowId, Point point, Rectangle cellRectangle) throws Exception {
        BcTableModel tableModel = (BcTableModel)tableView.getModel();
        long entityId = (Long)tableModel.getValueAtModel(rowId, this.columnId_entityId);
        Component component1 = this.componentMap.get(entityId);
        if (component1 == null || component1 == this.dummyLabel) {
            return null;
        }
        Container container = (Container)component1;
        Point point1 = new Point();
        point1.x = point.x - cellRectangle.x;
        point1.y = point.y - cellRectangle.y;
        Component component3 = null;
        int i = 0;
        while (i < container.getComponentCount()) {
            Component component2 = container.getComponent(i);
            Rectangle rectangle2 = component2.getBounds();
            if (rectangle2.contains(point1)) {
                component3 = component2;
            }
            ++i;
        }
        BufferedImage bufferedImage = null;
        Rectangle rectangle2 = null;
        if (component3 != null) {
            SwgImagePanel imagePanel = (SwgImagePanel)component3;
            String image_files = (String)tableModel.getValueAtModel(rowId, this.columnId_image_files);
            if (BcStringUtil.isEmpty(image_files)) {
                bufferedImage = (BufferedImage)imagePanel.getImage();
            } else {
                Integer index;
                List<String> fileNameList = BcCsvUtil.parseCsvRow(image_files, true);
                bufferedImage = this.createBufferedImage(entityId, fileNameList, index = (Integer)imagePanel.getUserObject());
                if (bufferedImage == null) {
                    bufferedImage = AwtImageHelper.getImage("skull_64x64.png");
                }
                if (bufferedImage == null) {
                    return null;
                }
            }
            Point pointWk = new Point();
            pointWk.x = cellRectangle.x + imagePanel.getX();
            pointWk.y = cellRectangle.y + imagePanel.getY();
            SwingUtilities.convertPointToScreen(pointWk, tableView);
            rectangle2 = new Rectangle(pointWk.x, pointWk.y, imagePanel.getWidth(), imagePanel.getHeight());
        }
        Object[] res = new Object[]{bufferedImage, rectangle2};
        return res;
    }

    protected BufferedImage getEmptyImage() throws Exception {
        if (this.emptyImage == null) {
            this.emptyImage = AwtImageHelper.getImage("skull_64x64.png");
        }
        return this.emptyImage;
    }

    protected void temp1(int start, int end) throws Exception {
        BcTableModel tableModel = (BcTableModel)this.tableView2.getModel();
        int i = start;
        while (i <= end) {
            long entityId = (Long)tableModel.getValueAt(i, this.columnId_entityId);
            if (!this.componentMap.containsKey(entityId)) {
                BcLogUtil.debug("temp:entityId=" + entityId);
                Object value = this.tableView2.getValueAt(i, this.columnIndex);
                Component component = this.getTableCellRendererComponent(this.tableView2, value, false, false, i, this.columnIndex);
            }
            ++i;
        }
    }

    protected void temp2(int start, int gap, int max) throws Exception {
        BcTableModel tableModel = (BcTableModel)this.tableView2.getModel();
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            int rowId = start + gap * i;
            if (rowId >= max) break;
            long entityId = (Long)tableModel.getValueAt(rowId, this.columnId_entityId);
            if (!this.componentMap.containsKey(entityId)) {
                Object value = this.tableView2.getValueAt(i, this.columnIndex);
                Component component = this.getTableCellRendererComponent(this.tableView2, value, false, false, i, this.columnIndex);
            }
            ++i;
        }
    }

    class ValidationTask
    extends TimerTask {
        int start;
        int end;
        int gap;
        int max;

        ValidationTask() {
        }

        @Override
        public void run() {
            try {
                XfilThumbnailCellRenderer.this.temp2(this.start, this.gap, this.max);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }
}

