/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.rmo;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.ffmpeg.FfmpegHelper;
import jp.co.extreme.module.ffmpeg.FfprobeHelper;
import jp.co.extreme.module.xfil.common.XfilTagUtil;
import jp.co.extreme.module.xfil.dao.XfilUriEntityDAO;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.server.XfilServerUtil;
import jp.co.extreme.rmi.common.RmiRemoteMethod;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;

public class XfilGeneralRMO
extends RmiAbstractRMO {
    public void settingValidation(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        BcResult result = XfilServerUtil.getInstance().validateCapturingCondition(dtsSession);
        rmoArg.getRespons().addData(result);
        XfilServerUtil.getInstance().checkVideoCaptureTaskStarting(FfprobeHelper.getInstance(), FfmpegHelper.getInstance());
    }

    public void fileList(RmiRmoArgument rmoArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilUriEntityDAO uriEntityDAO = XfilServerUtil.getInstance().getUriEntityDAO();
            long crawlId = -1L;
            List uriEntityList = uriEntityDAO.getList(dtsSessionWk, XfilUriEntityDAO.Mode.name, -1L, -1L, crawlId, null, null, null, null, -1, false, new long[0]);
            this.getLogger().info("uriEntityList.size()=" + uriEntityList.size());
            rmoArg.getRespons().addData(uriEntityList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void tagList(RmiRmoArgument rmoArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionWk = XfilServerUtil.getInstance().createDtsSession(this);){
            XfilUriEntityDAO uriEntityDAO = XfilServerUtil.getInstance().getUriEntityDAO();
            long crawlId = -1L;
            List uriEntityList = uriEntityDAO.getList(dtsSessionWk, XfilUriEntityDAO.Mode.name, -1L, -1L, crawlId, null, null, null, null, -1, false, new long[0]);
            this.getLogger().info("uriEntityList.size()=" + uriEntityList.size());
            ArrayList<String> tagList = new ArrayList<String>();
            int i = 0;
            while (i < uriEntityList.size()) {
                XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList.get(i);
                String tmpStr = XfilTagUtil.temp(uriEntity.tag);
                if (!BcStringUtil.isEmpty(tmpStr)) {
                    List<String> valueList = BcCsvUtil.parseCsvRow(tmpStr, false);
                    for (String tag : valueList) {
                        if (tagList.contains(tag)) continue;
                        tagList.add(tag);
                    }
                }
                ++i;
            }
            rmoArg.getRespons().addData(tagList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static enum Method implements RmiRemoteMethod
    {
        settingValidation,
        fileList,
        tagList;


        @Override
        public String getMethodName() {
            return this.name();
        }
    }
}

