/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.doc.poi.DcfExcel2Book;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.parser.XfilFileParser;
import org.apache.poi.hpbf.extractor.PublisherTextExtractor;

public class XfilMsPublisherParser
extends XfilFileParser {
    DcfExcel2Book excel2Book = new DcfExcel2Book();
    DcfShapeRenderer shapeRenderer = new DcfShapeRenderer();

    @Override
    public void parse(XfilUriEntity uriEntity, File file) throws Exception {
        if (file.exists()) {
            this.parse_L2(uriEntity, file);
            uriEntity.thumbnailTimestamp = BcTimeUtil.createCalendar();
        } else {
            BcLogUtil.warning("Not found file:" + file.getPath());
            uriEntity.missingTimestamp = BcTimeUtil.createCalendar();
        }
    }

    protected void parse_L2(XfilUriEntity uriEntity, File file) throws Exception {
        PublisherTextExtractor extractor = new PublisherTextExtractor((InputStream)new FileInputStream(file));
        uriEntity.text02 = extractor.getText();
        BcLogUtil.debug("uriEntity.text02=" + uriEntity.text02);
        extractor.close();
    }
}

