/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.doc.poi.DcfExcel2Book;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.parser.XfilFileParser;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.sl.usermodel.TextBox;

public class XfilMsPowerPointParser
extends XfilFileParser {
    DcfExcel2Book excel2Book = new DcfExcel2Book();
    DcfShapeRenderer shapeRenderer = new DcfShapeRenderer();

    @Override
    public void parse(XfilUriEntity uriEntity, File file) throws Exception {
        if (file.exists()) {
            this.parse_L2(uriEntity, file);
            uriEntity.thumbnailTimestamp = BcTimeUtil.createCalendar();
        } else {
            BcLogUtil.warning("Not found file:" + file.getPath());
            uriEntity.missingTimestamp = BcTimeUtil.createCalendar();
        }
    }

    protected void parse_L2(XfilUriEntity uriEntity, File file) throws Exception {
        HSLFSlideShow ppt = new HSLFSlideShow((InputStream)new FileInputStream(file));
        StringBuilder sb = new StringBuilder();
        List slideList = ppt.getSlides();
        BcLogUtil.debug("slideList.size()=" + slideList.size());
        int i = 0;
        while (i < slideList.size()) {
            HSLFSlide slide = (HSLFSlide)slideList.get(i);
            List shapeList = slide.getShapes();
            BcLogUtil.debug("shapeList.size()=" + shapeList.size());
            int j = 0;
            while (j < shapeList.size()) {
                HSLFShape shape = (HSLFShape)shapeList.get(j);
                BcLogUtil.debug("shape=" + shape);
                if (shape instanceof HSLFTextShape) {
                    HSLFTextShape textShape = (HSLFTextShape)shape;
                    BcStringUtil.append(sb, textShape.getText());
                } else if (shape instanceof TextBox) {
                    TextBox textBox = (TextBox)shape;
                    BcStringUtil.append(sb, textBox.getText());
                }
                ++j;
            }
            ++i;
        }
        uriEntity.text02 = sb.toString();
        BcLogUtil.debug("uriEntity.text02=" + uriEntity.text02);
        ppt.close();
    }
}

