/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.datasource.util.EtcRsmdSupplement;
import jp.co.extreme.etc.sql.ScfMmdServerUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsExtractionConditionCreator;
import jp.co.extreme.module.xdts.common.XdtsSqlConditionUtil;
import jp.co.extreme.module.xdts.common.XdtsSqlParser;
import jp.co.extreme.module.xdts.common.XdtsSqlParserUtil;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.model.XdtsProcessCondition;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.model.v001.XdtsOrderBy;
import jp.co.extreme.module.xdts.model.v001.XdtsSelect;
import jp.co.extreme.module.xdts.server.XdtsSessionFactoryManager;
import jp.co.extreme.module.xdts.server.XsysCreateInsertSqlTask;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlDefinitionCondition;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;

public class XdtsServerUtil
extends BcLoggableObject {
    private XdtsServerUtil() {
    }

    public static XdtsServerUtil getInstance() {
        return SingletonHolder.instance;
    }

    public Map<String, MmdModel> createMmdModelMap(SqlConnection sqlConnection, Collection<String> tableNameCollection) throws Exception {
        SqlContext sqlContext = sqlConnection.getSqlContext();
        TreeMap<String, MmdModel> mmdMap = new TreeMap<String, MmdModel>();
        for (String tableName : tableNameCollection) {
            MmdModel mmdModel = sqlContext.createModelMetaData(sqlConnection, tableName, true);
            mmdMap.put(tableName, mmdModel);
        }
        return mmdMap;
    }

    public Map<String, MmdModel> createMmdModelMap(DtsSession dtsSession, long dataSourceId, Collection<String> tableNameCollection) throws Exception {
        DtsSessionFactory dtsSessionFactoryWk1 = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSession, dataSourceId);
        Map<String, MmdModel> mmdMap = null;
        Throwable throwable = null;
        Object var8_9 = null;
        try (DtsSession dtsSessionWk1 = dtsSessionFactoryWk1.createSession(this);){
            mmdMap = this.createMmdModelMap(dtsSessionWk1.getConnection(), tableNameCollection);
            for (Map.Entry<String, MmdModel> mapEntry : mmdMap.entrySet()) {
                MmdModel mmdModel = mapEntry.getValue();
                int i = 0;
                while (i < mmdModel.getFieldCount()) {
                    MmdField mmdField = mmdModel.getField(i);
                    ScfMmdServerUtil.setMmdDisplayName(mmdField, dtsSessionFactoryWk1.wordManager, Locale.JAPANESE);
                    ++i;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return mmdMap;
    }

    public List<MmdField> createMmdFieldList(DtsSession dtsSession, String query, EtcRsmdSupplement rsmdSupplement) throws Exception {
        List<MmdField> mmdFieldList = null;
        try (SqlStatement stmt = dtsSession.getSqlContext().createStatementForScroll(dtsSession.getConnection());){
            stmt.setMaxRows(1);
            SqlResultSet rs = stmt.executeQuery(query);
            Map<String, Map<String, MmdField>> mmdFieldMap = null;
            DtsWordManager wordManager = dtsSession.getSessionFactory().wordManager;
            List<String> columnNameList = null;
            mmdFieldList = ScfMmdServerUtil.createMmdFieldList(rs.getMetaData(), mmdFieldMap, wordManager, rsmdSupplement, Locale.getDefault(), columnNameList);
            rs.close();
        }
        return mmdFieldList;
    }

    public BcResult createExtractionConditionByTable(DtsSession dtsSessionMain, long dataSourceId, String tableName) throws Exception {
        BcLogUtil.debug("dataSourceId=" + dataSourceId + " tableName=" + tableName);
        DtsSessionFactory dtsSessionFactoryWk = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSessionMain, dataSourceId);
        BcResult result = null;
        Throwable throwable = null;
        Object var8_9 = null;
        try (DtsSession dtsSessionWk = dtsSessionFactoryWk.createSession(this);){
            SqlContext sqlContextWk = dtsSessionWk.getSqlContext();
            MmdModel mmdModel = sqlContextWk.createModelMetaData(dtsSessionWk.getConnection(), tableName, true);
            SqlSelectQuery selectQuery = XdtsSqlConditionUtil.createSelectQuery(sqlContextWk, mmdModel);
            String query = sqlContextWk.buildSelectQuery(selectQuery);
            result = this.createExtractionConditionBySql_L2(dtsSessionWk, query, BcLogUtil.getDefaultLogger());
            if (!result.hasError()) {
                XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)result.getUserObject();
                extractionCondition.dataSourceId = dataSourceId;
                XdtsSelect xdtsSelect = BcCollectionUtil.getFirst(extractionCondition.selectList);
                xdtsSelect.orderByList = XdtsExtractionConditionCreator.getInstance().createOrderByList(mmdModel);
                ArrayList<String> optionList = new ArrayList<String>();
                for (XdtsOrderBy xdtsOrderBy : xdtsSelect.orderByList) {
                    optionList.add(XdtsSqlConditionUtil.toOrderByString(xdtsOrderBy));
                }
                int i = 0;
                while (i < xdtsSelect.controlContextList.size()) {
                    XdtsControlContext controlContext = xdtsSelect.controlContextList.get(i);
                    if (controlContext.contextType == XdtsConstants.ContextType.OrderBy) {
                        controlContext.options = BcCsvUtil.toCsv(optionList, true);
                        controlContext.defaultValue = (String)BcCollectionUtil.getFirst(optionList);
                    }
                    ++i;
                }
                extractionCondition.name = String.valueOf(tableName) + " extraction condition";
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    public BcResult createExtractionConditionBySql_L2(DtsSession dtsSession, String query, BcLogger logger) throws Exception {
        BcResult result = XdtsUtil.validateSql(query, false);
        if (result.hasError()) {
            return result;
        }
        XdtsSqlParser sqlParser = new XdtsSqlParser();
        XdtsExtractionCondition extractionCondition = sqlParser.createExtractionCondition(query);
        List<MmdField> mmdFieldList = this.createMmdFieldList(dtsSession, query, sqlParser.rsmdSupplement);
        int i = 0;
        while (i < mmdFieldList.size()) {
            MmdField mmdField = mmdFieldList.get(i);
            ++i;
        }
        XdtsSqlParserUtil.createExtractionCondition(extractionCondition, mmdFieldList, logger);
        result.setUserObject(extractionCondition);
        return result;
    }

    public MmdModel createMmdModelForSelect(ResultSetMetaData rsmd, String newTableName) throws Exception {
        Map<String, Map<String, MmdField>> mmdFieldMap = null;
        DtsWordManager wordManager = null;
        Locale locale = null;
        List<String> columnNameList = null;
        List<MmdField> mmdFieldList = ScfMmdServerUtil.createMmdFieldList(rsmd, mmdFieldMap, wordManager, null, locale, columnNameList);
        MmdModel mmdModel2 = new MmdModel();
        mmdModel2.tableName = newTableName;
        int i = 0;
        while (i < mmdFieldList.size()) {
            MmdField mmdField = mmdFieldList.get(i);
            mmdModel2.addField(mmdField);
            ++i;
        }
        return mmdModel2;
    }

    public boolean dropTable(SqlConnection sqlConn2, String tableName, boolean recreateTable, boolean truncateTable, boolean deleteRecord) throws Exception {
        SqlContext sqlContext2 = sqlConn2.getSqlContext();
        boolean existTable = sqlContext2.existTable(sqlConn2, tableName);
        this.getLogger().info("existTable=" + existTable);
        boolean doCreateTable = false;
        if (!existTable) {
            return existTable;
        }
        if (recreateTable) {
            this.getLogger().info(String.format(XdtsWords.getInstance().dropping_table_$, tableName));
            int cnt = sqlContext2.dropTable(sqlConn2, tableName);
            return false;
        }
        if (truncateTable) {
            this.getLogger().info(String.format("\u8907\u5199\u5148\u30c6\u30fc\u30d6\u30eb '%s' \u306eTRUNCATE\u4e2d...", tableName));
            int cnt = sqlContext2.truncateTable(sqlConn2, tableName);
            this.getLogger().info("\u4ef6\u6570=" + cnt);
        } else if (deleteRecord) {
            this.getLogger().info(String.format("\u8907\u5199\u5148\u30c6\u30fc\u30d6\u30eb '%s' \u306e\u30ec\u30b3\u30fc\u30c9\u3092\u524a\u9664\u4e2d...", tableName));
            int cnt = sqlContext2.deleteAllRow(sqlConn2, tableName);
            this.getLogger().info("\u4ef6\u6570=" + cnt);
        }
        return existTable;
    }

    public void createInsertQuery(DtsSession dtsSession1, Collection<XdtsSchemaObject> schemaObjectCollection, SqlContext sqlContext2, XdtsProcessCondition processCondition, BcLogger logger) throws Exception {
        SqlContext sqlContextWk1 = dtsSession1.getSqlContext();
        for (XdtsSchemaObject schemaObject : schemaObjectCollection) {
            this.createInsertQuery_L2(dtsSession1, schemaObject, sqlContext2, processCondition, logger);
        }
    }

    public void createInsertQuery_L2(DtsSession dtsSession1, XdtsSchemaObject schemaObject, SqlContext sqlContext2, XdtsProcessCondition processCondition, BcLogger logger) throws Exception {
        SqlContext sqlContext1 = dtsSession1.getSqlContext();
        File destFile = new File(processCondition.destDirPath, String.valueOf(schemaObject.name1) + ".sql");
        logger.info("destFile=" + destFile.getPath());
        BcFileUtil.makeParent(destFile);
        FileOutputStream os = new FileOutputStream(destFile, processCondition.append);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, BcConstants.charset.name());){
            String query = "SELECT * FROM " + schemaObject.name1;
            logger.info("query=" + query);
            SqlStatement stmt = dtsSession1.getConnection().createStatement();
            SqlResultSet rs = stmt.executeQuery(query);
            MmdModel mmdModel2 = XdtsServerUtil.getInstance().createMmdModelForSelect(rs.getMetaData(), schemaObject.name1);
            SqlDefinitionCondition definitionCondition = SqlDefinitionCondition.createDefault();
            List<String> removeFieldNameList = XdtsUtil.createRemoveFieldNameList(sqlContext2, mmdModel2, definitionCondition);
            XdtsUtil.removeField(mmdModel2, removeFieldNameList, false, this.getLogger());
            String insertBaseQuery = sqlContext2.createInsertQueryForPrepareStatement(mmdModel2, BcRuntimeUtil.lineSeparator, true);
            logger.debug("insertBaseQuery=" + insertBaseQuery);
            XsysCreateInsertSqlTask createInsertQueryTask = new XsysCreateInsertSqlTask();
            createInsertQueryTask.setResultSet(rs);
            createInsertQueryTask.setCondition(sqlContext2, insertBaseQuery, mmdModel2, processCondition, writer);
            createInsertQueryTask.taskProcess();
        }
    }

    /* synthetic */ XdtsServerUtil(XdtsServerUtil xdtsServerUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final XdtsServerUtil instance = new XdtsServerUtil(null);

        private SingletonHolder() {
        }
    }
}

