/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.server;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.dao.XdtsProfileDAO;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.server.XdtsSessionFactoryManager;
import jp.co.extreme.module.xdts.server.XdtsTreeCreator;
import jp.co.extreme.module.xdts.server.XdtsUserMenu;
import jp.co.extreme.scf5.dao.ScfAbstractIntPropertyDAO;
import jp.co.extreme.scf5.dao.ZScfPropertyDAOManager;
import jp.co.extreme.scf5.model.ZScfIntProperties;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.web.jquery.jstree.JsTreeItem;

public class XdtsMenuCreator
extends BcLoggableObject {
    private XdtsUserMenu userMenu;

    public static XdtsMenuCreator getInstance() {
        return SingletonHolder.instance;
    }

    public XdtsUserMenu createMenu(DtsSession dtsSessionMain) throws Exception {
        this.getLogger().info("Building menu...");
        XdtsUserMenu userMenu = new XdtsUserMenu();
        ScfAbstractIntPropertyDAO propertyDAO2 = ZScfPropertyDAOManager.getInstance().getDao(XdtsConstants.TableName.xdts_property.name());
        ZScfIntProperties intProps = propertyDAO2.getPropertyAsIntProps(dtsSessionMain);
        String jsonStr = intProps.get(XdtsConstants.Property.webServer.id);
        Map map = (Map)JacksonUtil.getObjectMapper().readValue(jsonStr, Map.class);
        String tmpStr = (String)map.get(XdtsConstants.HttpServerProperty.resultTimeout.name());
        userMenu.resultTimeout = BcNumberUtil.parseInteger(tmpStr, -1);
        this.getLogger().debug("userMenu.resultTimeout=" + userMenu.resultTimeout);
        userMenu.sw_table = BcBooleanUtil.parseBoolean((String)map.get(XdtsConstants.HttpServerProperty.table.name()));
        userMenu.sw_view = BcBooleanUtil.parseBoolean((String)map.get(XdtsConstants.HttpServerProperty.view.name()));
        userMenu.sw_sql = BcBooleanUtil.parseBoolean((String)map.get(XdtsConstants.HttpServerProperty.sql.name()));
        userMenu.sw_condition = BcBooleanUtil.parseBoolean((String)map.get(XdtsConstants.HttpServerProperty.condition.name()));
        XdtsTreeCreator treeCreator = new XdtsTreeCreator();
        treeCreator.setLogger(this.getLogger());
        treeCreator.sw_table = userMenu.sw_table;
        treeCreator.sw_view = userMenu.sw_view;
        treeCreator.sw_sql = userMenu.sw_sql;
        treeCreator.sw_condition = userMenu.sw_condition;
        userMenu.treeList = this.createTreeList(dtsSessionMain, intProps, treeCreator);
        this.getLogger().info("Number of menu routes =" + userMenu.treeList.size());
        return userMenu;
    }

    protected List<JsTreeItem> createTreeList(DtsSession dtsSessionMain, ZScfIntProperties intProps, XdtsTreeCreator treeCreator) throws Exception {
        String dataSourceIdStr = intProps.get(XdtsConstants.Property.dataSourceId.id);
        List<String> dataSourceIdList = BcCsvUtil.parseCsvRow(dataSourceIdStr, true);
        ArrayList<XdtsProfile> profileList = new ArrayList<XdtsProfile>();
        int i = 0;
        while (i < dataSourceIdList.size()) {
            long dataSourceId = Long.parseLong(dataSourceIdList.get(i));
            XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSessionMain, dataSourceId, false);
            if (profile == null) {
                this.getLogger().warning(BcWords.getInstance().$_does_not_exists("dataSourceId=" + dataSourceId));
            } else {
                profileList.add(profile);
            }
            ++i;
        }
        this.getLogger().info("Number of data sources=" + profileList.size());
        ArrayList<JsTreeItem> treeList = new ArrayList<JsTreeItem>();
        int i2 = 0;
        while (i2 < profileList.size()) {
            XdtsProfile profile = (XdtsProfile)profileList.get(i2);
            this.getLogger().info("Data sources name=" + profile.name);
            JsTreeItem rootTreeItem = new JsTreeItem();
            rootTreeItem.text = profile.name;
            rootTreeItem.note = profile.note;
            DtsSessionFactory dtsSessionFactoryWk = XdtsSessionFactoryManager.getInstance().getSessionFactory(dtsSessionMain, profile.getEntityId(), true);
            this.getLogger().info(String.format("Connecting to %s.", profile.name));
            try {
                Throwable throwable = null;
                Object var13_18 = null;
                try (SqlConnection sqlConWk = dtsSessionFactoryWk.getConnectionManager().getConnection(this);){
                    treeCreator.createTree(dtsSessionMain, sqlConWk, profile, rootTreeItem);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException ex) {
                rootTreeItem.error = ex.getMessage();
                this.getLogger().error(ex.getMessage());
            }
            catch (Exception ex) {
                rootTreeItem.error = ex.getMessage();
                this.getLogger().error(ex.getMessage());
            }
            treeList.add(rootTreeItem);
            ++i2;
        }
        return treeList;
    }

    public XdtsUserMenu getUserMenu() {
        return this.userMenu;
    }

    public void setUserMenu(XdtsUserMenu userMenu) {
        this.userMenu = userMenu;
    }

    private static final class SingletonHolder {
        private static final XdtsMenuCreator instance = new XdtsMenuCreator();

        private SingletonHolder() {
        }
    }
}

