/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.event.BcEventHandler;
import jp.co.extreme.base.event.BcEventHandlerList;
import jp.co.extreme.base.event.BcProgressEvent;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcInstanceManager;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcObjectNotFoundException;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsTaskPane;
import jp.co.extreme.module.xdts.fx.XdtsTimerPane;
import jp.co.extreme.module.xdts.model.XdtsTask;
import jp.co.extreme.module.xdts.model.XdtsTimer;
import jp.co.extreme.module.xdts.stub.XdtsTaskStub;
import jp.co.extreme.module.xdts.stub.XdtsTimerStub;

public class XdtsTimerTaskPane
extends FxDecoratePane {
    XdtsTimerPane timerPane = new XdtsTimerPane();
    Pane taskBasePane = new Pane();
    ScrollPane taskScrollPane = new ScrollPane();
    XdtsTimer timer;
    List<XdtsTask> taskList;
    List<XdtsTaskPane> taskPaneList;
    Button completionButton;
    Button cancelButton;
    Stage stage;
    BcEventHandlerList eventHandlerList = new BcEventHandlerList();

    public XdtsTimerTaskPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.completionButton = this.createButton(BcWords.getInstance().completion);
        this.cancelButton = this.createButton(BcWords.getInstance().close);
        this.setTop((Node)this.timerPane);
        this.taskScrollPane.setContent((Node)this.taskBasePane);
        this.setCenter((Node)this.taskScrollPane);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setData(XdtsTimer timer, List<XdtsTask> taskList) throws Exception {
        this.timer = timer;
        this.taskList = taskList;
        this.timerPane.setData(timer);
        double x = 4.0;
        double y = 4.0;
        double rowSpace = 6.0;
        this.taskPaneList = new ArrayList<XdtsTaskPane>();
        int i = 0;
        while (i < taskList.size()) {
            XdtsTask task = taskList.get(i);
            XdtsTaskPane taskPane = new XdtsTaskPane();
            taskPane.setData(taskList.get(0));
            FxUtil.setLocation(this.taskBasePane, (Region)taskPane, x, y, 860.0, 400.0);
            this.taskPaneList.add(taskPane);
            ++i;
        }
        this.taskBasePane.setPrefSize(860.0, 1600.0);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            BcResult result = new BcResult();
            BcInputValidator.getInstance().notNullable(BcWords.getInstance().name, this.timer.name, result.getErrorList());
            result.addResult(this.timerPane.validate());
            if (result.hasError()) {
                String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)message, BcWords.getInstance().warning, 2);
                return;
            }
            this.timerPane.storeData(this.timer);
            this.taskList = new ArrayList<XdtsTask>();
            int i = 0;
            while (i < this.taskPaneList.size()) {
                XdtsTaskPane taskPane = this.taskPaneList.get(i);
                taskPane.storeData(taskPane.task);
                this.taskList.add(taskPane.task);
                ++i;
            }
            this.timer = XdtsTimerStub.getInstance().putTimer(this.timer, this.taskList);
            this.eventHandlerList.fireEvent(new BcProgressEvent(this.timer));
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() throws Exception {
        this.stage.close();
        BcInstanceManager.getInstance().remove(((Object)((Object)this)).getClass(), this.timer.getDataId());
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    XdtsTimerTaskPane.this.timerPane.nameTextField.requestFocus();
                }
                catch (Exception ex) {
                    XdtsTimerTaskPane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsTimerTaskPane.this.close();
                }
                catch (Exception ex) {
                    XdtsTimerTaskPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(920.0);
        this.stage.setHeight(640.0);
        this.stage.setResizable(true);
        this.stage.setTitle(XdtsWords.getInstance().task);
        FxImageHelper.setStageIcon(this.stage);
        this.stage.showAndWait();
    }

    public static void show2(int timerId, BcEventHandler eventHandler) throws Exception {
        XdtsTimerTaskPane timerTaskPane = (XdtsTimerTaskPane)((Object)BcInstanceManager.getInstance().get(XdtsTimerTaskPane.class, timerId));
        if (timerTaskPane != null) {
            timerTaskPane.stage.toFront();
            return;
        }
        timerTaskPane = new XdtsTimerTaskPane();
        timerTaskPane.eventHandlerList.addEventHandler(eventHandler);
        XdtsTimer timer = null;
        List<XdtsTask> taskList = null;
        if (timerId <= 0) {
            timer = new XdtsTimer();
            timer.startTime = BcTimeUtil.createCalendar();
            timer.triggerId = 12;
            timer.value1 = "60";
            timer.value2 = "-1";
            taskList = new ArrayList<XdtsTask>();
            taskList.add(new XdtsTask());
        } else {
            timer = XdtsTimerStub.getInstance().getTimer(timerId);
            if (timer == null) {
                throw new BcObjectNotFoundException();
            }
            BcInstanceManager.getInstance().put(timer.getDataId(), (Object)timerTaskPane);
            taskList = XdtsTaskStub.getInstance().getTaskListByTimerId(timerId);
        }
        timerTaskPane.setData(timer, taskList);
        timerTaskPane.show(null);
    }

    public static void delete(Window ownerWindow, XdtsTimer timer) throws Exception {
        XdtsTimerTaskPane timerTaskPane = (XdtsTimerTaskPane)((Object)BcInstanceManager.getInstance().get(XdtsTimerTaskPane.class, timer.getDataId()));
        if (timerTaskPane != null) {
            timerTaskPane.stage.toFront();
            return;
        }
        String msg = "'" + timer.name + "' \u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f";
        if (FxOptionPane.showConfirmDialog(ownerWindow, (Object)msg, BcWords.getInstance().confirmation, 3) == 0) {
            XdtsTimerStub.getInstance().deleteTimer(timer.getDataId());
        }
    }
}

