/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.fx.tree.FxTreeCell;
import jp.co.extreme.fx.tree.FxTreeFolder;
import jp.co.extreme.fx.tree.FxTreeItem;
import jp.co.extreme.fx.tree.FxTreeItemHelperImpl;
import jp.co.extreme.fx.tree.FxTreeView;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsProfileTreeItemHelper;
import jp.co.extreme.module.xdts.fx.XdtsProfileTreeView;
import jp.co.extreme.module.xdts.fx.XdtsSchemaComparePane;
import jp.co.extreme.module.xdts.fx.XdtsTableTreeItemHelper;
import jp.co.extreme.module.xdts.fx.XdtsViewTreeItemHelper;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.sql.SqlWords;
import jp.co.extreme.sql.context.SqlContext;

class XdtsSchemaTreeItemHelper
extends XdtsProfileTreeItemHelper {
    ContextMenu contextMenu;
    MenuItem refreshMenuItem;
    MenuItem compareMenuItem;

    XdtsSchemaTreeItemHelper() {
    }

    @Override
    public void setup(FxTreeView treeView) throws Exception {
        this.childTreeItemHelperList.add(new XdtsTableTreeItemHelper());
        this.childTreeItemHelperList.add(new XdtsViewTreeItemHelper());
        super.setup(treeView);
    }

    @Override
    public FxTreeItem creaeSubTreeItem() throws Exception {
        FxTreeItem treeItem = this.creaeTreeItem();
        treeItem.setValue(new FxTreeFolder(SqlWords.getInstance().schema, (Object)FxTreeFolder.FolderType.subRoot));
        treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("tables_64x64.png"));
        treeItem.setExpanded(true);
        return treeItem;
    }

    @Override
    public void setProfile(XdtsProfile profile, SqlContext sqlContext, DtsWordManager wordManager, XdtsProfileTreeView profileTreeView) throws Exception {
        super.setProfile(profile, sqlContext, wordManager, profileTreeView);
        for (FxTreeItemHelperImpl treeItemHelperImlp : this.childTreeItemHelperList) {
            XdtsProfileTreeItemHelper tmp = (XdtsProfileTreeItemHelper)treeItemHelperImlp;
            tmp.setProfile(profile, sqlContext, wordManager, profileTreeView);
        }
    }

    @Override
    public void setContextMenu(FxTreeItem treeItem, FxTreeCell treeCell, EventHandler contextMeneEventHandler) throws Exception {
        if (this.contextMenu == null) {
            this.contextMenu = new ContextMenu();
            this.refreshMenuItem = new MenuItem(BcWords.getInstance().refresh, (Node)FxImageHelper.createImageView_icon("refresh_64x64.png"));
            this.refreshMenuItem.setOnAction(contextMeneEventHandler);
            this.compareMenuItem = new MenuItem(XdtsWords.getInstance().compareSchemas.toPlain(), (Node)FxImageHelper.createImageView_icon("compare_61x64.png"));
            this.compareMenuItem.setOnAction(contextMeneEventHandler);
        }
        this.refreshMenuItem.setUserData((Object)treeCell);
        this.compareMenuItem.setUserData((Object)treeCell);
        this.contextMenu.getItems().clear();
        if (treeItem == this.getSubTreeItem()) {
            this.contextMenu.getItems().add((Object)this.compareMenuItem);
            this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu.getItems().add((Object)this.refreshMenuItem);
        }
        treeCell.setContextMenu(this.contextMenu);
    }

    @Override
    public void contextMenuHandle(Event ev, FxTreeItem treeItem) throws Exception {
        if (ev.getSource() == this.refreshMenuItem) {
            this.refresh();
        } else if (ev.getSource() == this.compareMenuItem) {
            XdtsSchemaComparePane schemaComparePane = new XdtsSchemaComparePane();
            schemaComparePane.setProfile1(this.profile);
            schemaComparePane.show();
        }
    }
}

