/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.Map;
import javafx.scene.Node;
import jp.co.extreme.base.core.BcBooleanUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.sql.SqlWords;

class XdtsMenuSettingPane
extends FxBorderPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxNumberField resultTimeoutField = new FxNumberField();
    FxCheckBox tableCheckBox = new FxCheckBox();
    FxCheckBox viewCheckBox = new FxCheckBox();
    FxCheckBox sqlCheckBox = new FxCheckBox();
    FxCheckBox conditionCheckBox = new FxCheckBox();

    public XdtsMenuSettingPane() throws Exception {
        this.initComponant();
    }

    protected void initComponant() throws Exception {
        this.resultTimeoutField.setPrefColumnCount(5);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(String.valueOf(XdtsWords.getInstance().resultTimeout.toPlain()) + "(sec)"), new Node[]{this.resultTimeoutField});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().table), new Node[]{this.tableCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().view), new Node[]{this.viewCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(SqlWords.getInstance().sql), new Node[]{this.sqlCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().condition), new Node[]{this.conditionCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
    }

    public void storeData(Map<String, String> map) throws Exception {
        map.put(XdtsConstants.HttpServerProperty.resultTimeout.name(), this.resultTimeoutField.getBigDecimal().toString());
        map.put(XdtsConstants.HttpServerProperty.table.name(), Boolean.toString(this.tableCheckBox.isSelected()));
        map.put(XdtsConstants.HttpServerProperty.view.name(), Boolean.toString(this.viewCheckBox.isSelected()));
        map.put(XdtsConstants.HttpServerProperty.sql.name(), Boolean.toString(this.sqlCheckBox.isSelected()));
        map.put(XdtsConstants.HttpServerProperty.condition.name(), Boolean.toString(this.conditionCheckBox.isSelected()));
    }

    public void setData(Map<String, String> map) throws Exception {
        String tmpStr = map.get(XdtsConstants.HttpServerProperty.resultTimeout.name());
        this.resultTimeoutField.setValue(BcNumberUtil.parseInteger(tmpStr, 0));
        this.tableCheckBox.setSelected(BcBooleanUtil.parseBoolean(map.get(XdtsConstants.HttpServerProperty.table.name())));
        this.viewCheckBox.setSelected(BcBooleanUtil.parseBoolean(map.get(XdtsConstants.HttpServerProperty.view.name())));
        this.sqlCheckBox.setSelected(BcBooleanUtil.parseBoolean(map.get(XdtsConstants.HttpServerProperty.sql.name())));
        this.conditionCheckBox.setSelected(BcBooleanUtil.parseBoolean(map.get(XdtsConstants.HttpServerProperty.condition.name())));
    }

    public BcResult validate() throws Exception {
        BcResult result = new BcResult();
        BcInputValidator inputValidator = BcInputValidator.getInstance();
        String[] items = new String[]{BcWords.getInstance().table, BcWords.getInstance().view, SqlWords.getInstance().sql, BcWords.getInstance().condition};
        boolean[] selects = new boolean[]{this.tableCheckBox.isSelected(), this.viewCheckBox.isSelected(), this.sqlCheckBox.isSelected(), this.conditionCheckBox.isSelected()};
        inputValidator.select_$_or_more_$(items, selects, 1, result.getErrorList());
        return result;
    }
}

