/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.util.ArrayList;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.common.HtmlImageAttribute;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.common.Wbs1Words;
import jp.co.extreme.module.wbs1.dao.Wbs1AccessCountDAO;
import jp.co.extreme.module.wbs1.dao.Wbs1ShopDAO;
import jp.co.extreme.module.wbs1.model.Wbs1AccessCount;
import jp.co.extreme.module.wbs1.model.Wbs1Judgement;
import jp.co.extreme.module.wbs1.model.Wbs1Shop;
import jp.co.extreme.module.wbs1.model.WbsUrlParam;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.WbsJudgementFiledHtmlCreator;
import jp.co.extreme.module.xsys.validation.XsysValidator;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.HtmlDlCreator;
import jp.co.extreme.module.xweb.common.WbsFiledHtmlCreator;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxFormBuilder;
import jp.co.extreme.module.xweb.common.WbxFormData;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebIconManager;
import jp.co.extreme.module.xweb.common.XwebJudgementUtil;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;
import jp.co.extreme.web.server.WbsUrlParameterMap;

public class Wbs1ShopWCB
extends Wbs1AbstractWCB {
    public void form(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.form_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void form_L2(WbsArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        WbsUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
        WbsUrlParam urlParam = null;
        Wbs1Shop shop = null;
        Wbs1Judgement judgement = null;
        if (tokenContext.validationResult == null) {
            urlParam = new WbsUrlParam();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, urlParam);
            long shopId = BcNumberUtil.parseLong(urlParam.param1);
            Throwable throwable = null;
            Object var12_13 = null;
            try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
                shop = (Wbs1Shop)Wbs1ShopDAO.getInstance().getById(dtsSession, shopId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (shop == null) {
                shop = new Wbs1Shop();
            }
            judgement = new Wbs1Judgement();
            XwebJudgementUtil.judgementSet(shop, judgement);
            XwebUtil.putToMap(tokenContext.map, judgement);
        } else {
            urlParam = (WbsUrlParam)XwebUtil.getMapValue(tokenContext.map, WbsUrlParam.class);
            shop = (Wbs1Shop)XwebUtil.getMapValue(tokenContext.map, Wbs1Shop.class);
            judgement = (Wbs1Judgement)XwebUtil.getMapValue(tokenContext.map, Wbs1Judgement.class);
        }
        WbxFormData formData = new WbxFormData();
        formData.icon = XwebIconManager.createTag(XwebIconManager.WebIcon.address);
        formData.title = "\u5e97\u8217\u60c5\u5831";
        StringBuilder fileds = new StringBuilder();
        WbsFiledHtmlCreator filedHtmlCreator = new WbsFiledHtmlCreator(this.getHtmlBuilder());
        fileds.append(filedHtmlCreator.create(shop, tokenContext.validationResult));
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            formData.title = String.valueOf(formData.title) + ":" + urlParam.mode;
            WbsJudgementFiledHtmlCreator judgementFiledHtmlCreator = new WbsJudgementFiledHtmlCreator(this.getHtmlBuilder());
            fileds.append(judgementFiledHtmlCreator.create(judgement, tokenContext.validationResult));
        }
        formData.fileds = fileds.toString();
        StringBuilder controls = new StringBuilder();
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Method.submit);
        String onclickAction = WbfJslUtil.submit2(formData.getFormName(), href);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().save, onclickAction));
        onclickAction = XwebUtil.onclickActionToBack(wcbArg);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().cancel, onclickAction));
        controls.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        formData.controls = controls.toString();
        WbxFormBuilder formBuilder = new WbxFormBuilder(this.getHtmlBuilder2());
        StringBuilder sb = new StringBuilder();
        sb.append(formBuilder.build(formData));
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, formData.getTitle(), null, html, null, null);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    public void submit(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.submit_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void submit_L2(WbsArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        Wbs1Shop shop = new Wbs1Shop();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, shop);
        Wbs1Judgement judgement = new Wbs1Judgement();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, judgement);
        XsysValidator validator = XsysValidator.getInstance();
        tokenContext.validationResult = validator.validate(shop);
        if (tokenContext.validationResult.hasError()) {
            XwebUtil.putToMap(tokenContext.map, shop);
            XwebUtil.inputErrorPreprocessing(tokenContext, requestParameter, tokenContext.validationResult);
            this.form(wcbArg);
            return;
        }
        int submitMode = BcNumberUtil.parseInt(requestParameter.map.getAsString(WbxConstants.SessionAttributeKey.submitMode), Wbs1Constants.JudgementStatus.NULL.id);
        this.getLogger().debug("### submitMode=" + submitMode);
        if (submitMode == Wbs1Constants.JudgementStatus.application.id) {
            shop.setJudgementDatetime(null);
            shop.setJudgementStatusId(Wbs1Constants.JudgementStatus.application.id);
            shop.setJudgementReason(null);
        } else {
            XwebJudgementUtil.judgementSet(judgement, shop);
        }
        Wbs1ShopDAO.getInstance().putEntity(dtsSessionSite, shop);
        dtsSessionSite.commit();
        XwebUtil.removeTokenContext(wcbArg, tokenContext);
        XwebUtil.redirectPreUrl(wcbArg);
    }

    public void view(WbsArgument wcbArg) throws Exception {
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        String tmpStr = requestParameter.getAsString("shopId");
        long shopId = BcNumberUtil.parseLong(tmpStr);
        Throwable throwable = null;
        Object var7_8 = null;
        try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            Wbs1Shop shop = (Wbs1Shop)Wbs1ShopDAO.getInstance().getById(dtsSession, shopId);
            String content = this.view_L2(wcbArg, dtsSession, shop);
            StringBuilder sb = this.getBaseHtml(wcbArg);
            sb = this.replace(wcbArg, "\u30af\u30e9\u30d6\u8a73\u7d30", null, sb);
            sb = BcStringUtil.replace((CharSequence)sb, WbxConstants.PlaceHolder.content.value, content);
            WbfwUtil.outputHtml(wcbArg, sb.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected String view_L2(WbsArgument wcbArg, DtsSession dtsSession, Wbs1Shop shop) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)MdlCreator.getInstance().div_grid_cell_start(12));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className, ExtwCssUtil.ExtwClass.extw_row_wrap.className, ExtwCssUtil.ExtwClass.extw_flex_baseline.className));
        sb.append(this.getHtmlBuilder().h(3, shop.name));
        if (!BcStringUtil.isEmpty(shop.nameKana) && !BcStringUtil.equals(shop.name, shop.nameKana)) {
            sb.append(this.getHtmlBuilder().h(6, " \uff08" + shop.nameKana + "\uff09"));
        }
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        ArrayList<String> imageUrlList = new ArrayList<String>();
        if (!BcStringUtil.isEmpty(shop.shopImageUrl)) {
            imageUrlList.add(shop.shopImageUrl);
        }
        if (!BcStringUtil.isEmpty(shop.castImageUrl)) {
            imageUrlList.add(shop.castImageUrl);
        }
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = ExtwCssUtil.ExtwClass.extw_border_radius_10px.className;
        int i = 0;
        while (i < imageUrlList.size()) {
            String imageUrl = (String)imageUrlList.get(i);
            if (i > 0) {
                sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_1rem.className));
            }
            HtmlImageAttribute imageAttribute = new HtmlImageAttribute();
            imageAttribute.src = imageUrl;
            imageAttribute.width = "100%";
            sb.append(this.getHtmlBuilder().div_start());
            sb.append(this.getHtmlBuilder().image(globalAttribute, imageAttribute, null));
            sb.append(this.getHtmlBuilder().div_end());
            ++i;
        }
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(this.getHtmlBuilder().p(shop.introduction, true));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(this.getHtmlBuilder().div_start("data"));
        ArrayList<BcPair<String, String>> pairList = new ArrayList<BcPair<String, String>>();
        pairList.add(new BcPair<String, String>("\u30a8\u30ea\u30a2", HtmlUtil.encode(shop.area)));
        pairList.add(new BcPair<String, String>(Wbs1Words.getInstance().\u696d\u614b, HtmlUtil.encode(shop.businessType)));
        pairList.add(new BcPair<String, String>("\u55b6\u696d\u6642\u9593", HtmlUtil.encode(XwebUtil.toOpeningHours(shop.startTime, shop.endTime))));
        pairList.add(new BcPair<String, String>("\u4f4f\u6240", HtmlUtil.encode("\u3012" + shop.postalCode + " " + shop.cityName + " " + shop.townName)));
        pairList.add(new BcPair<String, String>("TEL", HtmlUtil.encode(shop.tel)));
        pairList.add(new BcPair<String, String>("E-mail", HtmlUtil.encode(shop.email)));
        pairList.add(new BcPair<String, String>("\u6700\u5bc4\u308a\u99c5", HtmlUtil.encode(shop.nearestStation)));
        pairList.add(new BcPair<String, String>("SET\u6599\u91d1", HtmlUtil.encode(shop.priceSet)));
        pairList.add(new BcPair<String, String>("\u30b5\u30fc\u30d3\u30b9\u6599", HtmlUtil.encode(shop.priceService)));
        pairList.add(new BcPair<String, String>("\u5229\u7528\u53ef\u80fd\u306a<br>\u30af\u30ec\u30b8\u30c3\u30c8\u30ab\u30fc\u30c9", HtmlUtil.encode(shop.creditCard)));
        pairList.add(new BcPair<String, String>("\u6599\u91d1\u5099\u8003", HtmlUtil.encode(shop.priceNote)));
        String siteUrl = null;
        if (!BcStringUtil.isEmpty(shop.siteUrl)) {
            siteUrl = String.valueOf(this.getHtmlBuilder().a_start(shop.siteUrl, null, HtmlConstants.FrameTarget._blank.name()).toString()) + shop.siteUrl + this.getHtmlBuilder().a_end();
        }
        pairList.add(new BcPair<String, Object>("\u516c\u5f0f\u30b5\u30a4\u30c8URL", siteUrl));
        HtmlDlCreator dlCreator = new HtmlDlCreator();
        dlCreator.dlClass = "dl_table";
        dlCreator.dtHorizonalAlignment = 4;
        sb.append((CharSequence)dlCreator.create(pairList));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(this.getHtmlBuilder().h(4, "\u30a2\u30af\u30bb\u30b9"));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(this.getHtmlBuilder().div_start("mapxxxx"));
        sb.append(shop.mapHtml);
        sb.append(this.getHtmlBuilder().div_end());
        String key = "shop_" + shop.id;
        Wbs1AccessCount accessCount = Wbs1AccessCountDAO.getInstance().getByKey(dtsSession, key);
        if (accessCount == null) {
            accessCount = new Wbs1AccessCount();
            accessCount.key = key;
        }
        ++accessCount.count;
        Wbs1AccessCountDAO.getInstance().putEntity(dtsSession, accessCount);
        sb.append(this.getHtmlBuilder().p("CNT=" + accessCount.count, true));
        dtsSession.commit();
        sb.append(this.getHtmlBuilder().div_end());
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        return sb.toString();
    }

    public static enum Method implements WbxPath
    {
        form("shop-form"),
        submit("shop-submit"),
        view("shop-view");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1ShopWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

