/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcSIUnitUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.common.HtmlImageAttribute;
import jp.co.extreme.html.component.WhcBuilder;
import jp.co.extreme.html.component.WhcComponent;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.lib.html.mdc.MdcLabelAndInputBuilder;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.dao.Wbs1AnswerDAO;
import jp.co.extreme.module.wbs1.dao.Wbs1FileResourceDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.Wbs1Answer;
import jp.co.extreme.module.wbs1.model.Wbs1FileResource;
import jp.co.extreme.module.wbs1.model.Wbs1Judgement;
import jp.co.extreme.module.wbs1.model.Wbs1PersonBasic;
import jp.co.extreme.module.wbs1.model.Wbs1Question;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.module.wbs1.model.WbsUrlParam;
import jp.co.extreme.module.wbs1.server.PersonManager;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractDashboardWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1ImageWCB;
import jp.co.extreme.module.wbs1.wcb.WbsFileUploadFormCreator;
import jp.co.extreme.module.wbs1.wcb.WbsJudgementFiledHtmlCreator;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.web.XdsDataViewUtil;
import jp.co.extreme.module.xsys.common.XsysWords;
import jp.co.extreme.module.xsys.validation.XsysValidator;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.PersonProfileUtil;
import jp.co.extreme.module.xweb.common.WbsFiledHtmlCreator;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxFormBuilder;
import jp.co.extreme.module.xweb.common.WbxFormData;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebFileContext;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebJudgementUtil;
import jp.co.extreme.module.xweb.common.XwebQuestionUtil;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.person.util.PsnPersonUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;
import jp.co.extreme.web.server.WbsUrlParameterMap;
import jp.co.extreme.web.upload.WebDndUtil;
import jp.co.extreme.web.upload.WebFileCheckUtil;
import jp.co.extreme.web.upload.WebImagePreviewUtil;

public class Wbs1PersonProfileWCB
extends Wbs1AbstractDashboardWCB {
    public void form(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.form_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void form_L2(WbsArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        int i;
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        WbsUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
        WbsUrlParam urlParam = null;
        Wbs1Answer answer = null;
        HashMap<Short, Wbs1Question> questionMap = null;
        Wbs1Judgement judgement = null;
        if (tokenContext.validationResult == null) {
            urlParam = new WbsUrlParam();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, urlParam);
            WbsTempCondition tmpCondition = new WbsTempCondition();
            tmpCondition.personId = Long.parseLong(urlParam.param1);
            PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
            Wbs1Account account = personManager.getAccountByPersonId(tmpCondition.personId);
            tmpCondition.questionSetId = XwebQuestionUtil.getQuestionSetId(wcbArg.getSiteContext(), account.sexCode);
            this.getLogger().debug("nickname=" + account.nickname + " questionSetId=" + tmpCondition.questionSetId);
            answer = (Wbs1Answer)Wbs1AnswerDAO.getInstance().getByPersonId(dtsSessionSite, tmpCondition, null);
            if (answer == null) {
                answer = new Wbs1Answer();
                answer.personId = account.personId;
                answer.questionSetId = tmpCondition.questionSetId;
            }
            XwebUtil.putToMap(tokenContext.map, answer);
            List<Wbs1Question> questionList = XwebQuestionUtil.getQuestionList(wcbArg, dtsSessionSite, account.sexCode);
            this.getLogger().debug("questionList.size()=" + questionList.size());
            questionMap = new HashMap<Short, Wbs1Question>();
            i = 0;
            while (i < questionList.size()) {
                Wbs1Question question = questionList.get(i);
                questionMap.put(question.number, question);
                ++i;
            }
            XwebUtil.putToMap(tokenContext.map, questionMap);
            judgement = new Wbs1Judgement();
            XwebJudgementUtil.judgementSet(answer, judgement);
            XwebUtil.putToMap(tokenContext.map, judgement);
        } else {
            urlParam = (WbsUrlParam)XwebUtil.getMapValue(tokenContext.map, WbsUrlParam.class);
            answer = (Wbs1Answer)XwebUtil.getMapValue(tokenContext.map, Wbs1Answer.class);
            questionMap = (HashMap<Short, Wbs1Question>)XwebUtil.getMapValue(tokenContext.map, Map.class);
            judgement = (Wbs1Judgement)XwebUtil.getMapValue(tokenContext.map, Wbs1Judgement.class);
        }
        this.getLogger().debug("### mode=" + urlParam.mode);
        WbxFormData formData = new WbxFormData();
        formData.title = XsysWords.getInstance().\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb;
        InnerFieldHtmlCreator filedHtmlCreator = new InnerFieldHtmlCreator(this.getHtmlBuilder());
        filedHtmlCreator.questionMap = questionMap;
        StringBuilder fileds = new StringBuilder();
        fileds.append(filedHtmlCreator.create(answer, tokenContext.validationResult));
        WbsFileUploadFormCreator uploadFormCreator = new WbsFileUploadFormCreator();
        i = 0;
        while (i < answer.fileIds.length) {
            if (i > 0) break;
            XwebFileContext fileContext = XwebUtil.createFileContext(wcbArg, dtsSessionSite, answer.fileIds[i]);
            String fileIdSuffix = Integer.toString(i + 1);
            String dndArea = WebImagePreviewUtil.temp(this.getHtmlBuilder(), uploadFormCreator, String.valueOf(Wbs1Answer.FieldName.fileIds.name()) + fileIdSuffix, fileIdSuffix, fileContext.href, fileContext.fileName);
            fileds.append(WebImagePreviewUtil.fileBox(this.getHtmlBuilder(), "\u30d7\u30ed\u30d5\u30a3\u30fc\u30eb\u753b\u50cf" + fileIdSuffix, dndArea, WebFileCheckUtil.maxSize));
            ++i;
        }
        fileds.append(this.getHtmlBuilder().hidden(WbxConstants.SessionAttributeKey.submitMode.name(), null));
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            formData.title = String.valueOf(formData.title) + ":" + urlParam.mode;
            WbsJudgementFiledHtmlCreator judgementFiledHtmlCreator = new WbsJudgementFiledHtmlCreator(this.getHtmlBuilder());
            fileds.append(judgementFiledHtmlCreator.create(judgement, tokenContext.validationResult));
        }
        formData.fileds = fileds.toString();
        StringBuilder controls = new StringBuilder();
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Method.submit);
        String onclickAction = WbfJslUtil.submit3(formData.formName, href, WbxConstants.SessionAttributeKey.submitMode.name(), Wbs1Constants.JudgementStatus.NULL.id);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().save, onclickAction));
        controls.append(this.getHtmlBuilder().br());
        controls.append(this.getHtmlBuilder().br());
        if (Wbs1Constants.OperationMode.userProfile.name().equals(urlParam.mode)) {
            onclickAction = WbfJslUtil.submit3(formData.formName, href, WbxConstants.SessionAttributeKey.submitMode.name(), Wbs1Constants.JudgementStatus.application.id);
            controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().application, onclickAction));
            controls.append(this.getHtmlBuilder().br());
            controls.append(this.getHtmlBuilder().br());
        }
        onclickAction = XwebUtil.onclickActionToBack(wcbArg);
        controls.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().cancel, onclickAction));
        controls.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        formData.controls = controls.toString();
        StringBuilder sb = new StringBuilder();
        WbxFormBuilder formBaseBuilder = new WbxFormBuilder(this.getHtmlBuilder2());
        sb.append(formBaseBuilder.build(formData));
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        ArrayList<String> bodyScriptList = new ArrayList<String>();
        bodyScriptList.add(WebImagePreviewUtil.getScript1());
        int i2 = 0;
        while (i2 < 1) {
            String fileIdSuffix = Integer.toString(i2 + 1);
            bodyScriptList.add(WebDndUtil.getScript(String.valueOf(WebDndUtil.dndAreaIdPrefix) + fileIdSuffix, String.valueOf(WebDndUtil.inputFileId) + fileIdSuffix, String.valueOf(WebImagePreviewUtil.canvasId) + fileIdSuffix, String.valueOf(WebImagePreviewUtil.canvasParentId) + fileIdSuffix));
            ++i2;
        }
        long maxSize = 0xA00000L;
        String msg = String.format("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u306f\u6700%S\u3067\u3059\u3002", BcSIUnitUtil.toByteString(maxSize));
        bodyScriptList.add(WebFileCheckUtil.getScript(maxSize, msg, new String[0]));
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, formData.getTitle(), null, html, null, bodyScriptList);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    public void submit(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.submit_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void submit_L2(WbsArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.form);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        BcLogUtil.debug("### requestParameter.map=" + requestParameter.map);
        Wbs1Answer answer = new Wbs1Answer();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, answer);
        Wbs1Judgement judgement = new Wbs1Judgement();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, judgement);
        XsysValidator validator = XsysValidator.getInstance();
        tokenContext.validationResult = validator.validate(answer);
        List<XwebFileContext> fileContextList = XwebUtil.createFileContextList(wcbArg, dtsSessionSite, this.getLogger());
        int i = 0;
        while (i < fileContextList.size()) {
            XwebFileContext fileContext = fileContextList.get(i);
            String fileSuffix = XwebUtil.getSuffix(fileContext.uploadContext.fieldName, Wbs1Answer.FieldName.fileIds.name());
            int arrayIndex = Integer.parseInt(fileSuffix) - 1;
            answer.fileIds[arrayIndex] = fileContext.fileResource.id;
            ++i;
        }
        int submitMode = BcNumberUtil.parseInt(requestParameter.map.getAsString(WbxConstants.SessionAttributeKey.submitMode), Wbs1Constants.JudgementStatus.NULL.id);
        this.getLogger().debug("### submitMode=" + submitMode);
        if (submitMode == Wbs1Constants.JudgementStatus.application.id) {
            answer.setJudgementDatetime(null);
            answer.setJudgementStatusId(Wbs1Constants.JudgementStatus.application.id);
            answer.setJudgementReason(null);
        } else {
            XwebJudgementUtil.judgementSet(judgement, answer);
        }
        if (tokenContext.validationResult.hasError()) {
            XwebUtil.putToMap(tokenContext.map, answer);
            XwebUtil.inputErrorPreprocessing(tokenContext, requestParameter, tokenContext.validationResult);
            this.form(wcbArg);
            return;
        }
        Wbs1AnswerDAO.getInstance().putEntity(dtsSessionSite, answer);
        dtsSessionSite.commit();
        PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
        personManager.crear(answer.personId);
        XwebUtil.redirectPreUrl(wcbArg);
    }

    public void view(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.view_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void view_L2(WbsArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        WbsUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
        WbsUrlParam urlParam = new WbsUrlParam();
        WbxParameterUtil.getInstance().setFieldValue(decryptMap, urlParam);
        WbsTempCondition tempCondition = new WbsTempCondition();
        tempCondition.personId = Long.parseLong(urlParam.param1);
        this.getLogger().debug("preview_l2:personId=" + tempCondition.personId);
        StringBuilder sb = new StringBuilder();
        PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
        Wbs1Account account = personManager.getAccountByPersonId(tempCondition.personId);
        Wbs1PersonBasic personBasic = personManager.getPersonBasic(account.personId);
        long questionSetId = XwebQuestionUtil.getQuestionSetId(wcbArg.getSiteContext(), account.sexCode);
        Wbs1Answer answer = personManager.getAnswer(account.personId, questionSetId);
        sb.append((CharSequence)this.createDetail(wcbArg, dtsSessionSite, urlParam, account, personBasic, answer));
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, "bbbbbbb", null, html);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    protected StringBuilder createDetail(WbsArgument wcbArg, DtsSession dtsSessionSite, WbsUrlParam urlParam, Wbs1Account account, Wbs1PersonBasic personBasic, Wbs1Answer answer) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, ExtwCssUtil.ExtwClass.extw_padding_04rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_table.className));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(ExtwCssUtil.ExtwClass.extw_table_cell.className);
        CssBuiler cssBuiler = new CssBuiler();
        globalAttribute.style = cssBuiler.width("6rem").build();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append(this.tableCellLeft(wcbArg, dtsSessionSite, answer));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_table_cell.className));
        sb.append(this.tableCellMiddle(wcbArg, dtsSessionSite, urlParam, account, personBasic, answer));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append(this.tableCellRight(wcbArg, answer, urlParam));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    protected String tableCellLeft(WbsArgument wcbArg, DtsSession dtsSessionSite, Wbs1Answer answer) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (answer == null) {
            answer = new Wbs1Answer();
        }
        int i = 0;
        while (i < answer.fileIds.length) {
            if (i > 0) break;
            long fileId = answer.fileIds[i];
            Wbs1FileResource fileResource = null;
            if (fileId > 0L) {
                fileResource = (Wbs1FileResource)Wbs1FileResourceDAO.getInstance().getById(dtsSessionSite, fileId);
            }
            String imageUrl = null;
            imageUrl = fileResource != null ? String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1ImageWCB.Method.getImage)) + "/" + fileResource.fileName3 : "images/no_image_640x480.png";
            HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
            globalAttribute.clazz = ExtwCssUtil.ExtwClass.extw_border_radius_10px.className;
            HtmlImageAttribute imageAttribute = new HtmlImageAttribute();
            imageAttribute.src = imageUrl;
            imageAttribute.width = "100%";
            sb.append(this.getHtmlBuilder().div_start());
            sb.append(this.getHtmlBuilder().image(globalAttribute, imageAttribute, null));
            sb.append(this.getHtmlBuilder().div_end());
            ++i;
        }
        return sb.toString();
    }

    protected String tableCellMiddle(WbsArgument wcbArg, DtsSession dtsSessionSite, WbsUrlParam urlParam, Wbs1Account account, Wbs1PersonBasic personBasic, Wbs1Answer answer) throws Exception {
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className, ExtwCssUtil.ExtwClass.extw_row_wrap.className, ExtwCssUtil.ExtwClass.extw_flex_baseline.className));
        String sexSymbolTag = PersonProfileUtil.toSexSymbolTag(personBasic.sexCode);
        sb.append(sexSymbolTag);
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        sb.append(this.getHtmlBuilder().h(6, account.nickname));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        String ageStr = PsnPersonUtil.toAgeBase(personBasic.birthday, BcTimeUtil.createYyyyMMdd());
        sb.append(this.getHtmlBuilder().p(ageStr, true));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className, ExtwCssUtil.ExtwClass.extw_row_wrap.className, ExtwCssUtil.ExtwClass.extw_flex_baseline.className));
        sb.append(this.getHtmlBuilder().div_start());
        if (answer != null) {
            List<Wbs1Question> questionList = XwebQuestionUtil.getQuestionList(wcbArg, dtsSessionSite, account.sexCode);
            String str1 = XwebQuestionUtil.get\u81ea\u5df1\u7d39\u4ecb(this.getHtmlBuilder(), questionList, answer);
            sb.append(HtmlUtil.encode(str1));
            String str2 = XwebQuestionUtil.getAnswerHtml(this.getHtmlBuilder(), questionList, answer, true);
            sb.append(str2);
        }
        sb.append(this.getHtmlBuilder().p("\u767b\u9332\u65e5\u6642: " + BcTimeUtil.toString(answer.addDatetime, "yyyy/MM/dd HH:mm:ss"), true));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            sb.append(XwebJudgementUtil.createJudgementHtml(this.getHtmlBuilder(), answer, wcbArg, answer.judgementPersonId));
        }
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    protected String tableCellLeft(WbsArgument wcbArg, DtsSession dtsSessionSite, long personId) throws Exception {
        PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
        Wbs1Account account = personManager.getAccountByPersonId(personId);
        long questionSetId = XwebQuestionUtil.getQuestionSetId(wcbArg.getSiteContext(), account.sexCode);
        Wbs1Answer answer = personManager.getAnswer(personId, questionSetId);
        return this.tableCellLeft(wcbArg, dtsSessionSite, answer);
    }

    protected String tableCellRight(WbsArgument wcbArg, Wbs1Answer answer, WbsUrlParam urlParam) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.viewButton(wcbArg, urlParam, answer));
        return sb.toString();
    }

    protected String viewButton(WbsArgument wcbArg, WbsUrlParam urlParam1, Wbs1Answer answer) throws Exception {
        String param1;
        WbsUrlParameterMap paramMap;
        WbsUrlParam urlParam2;
        String href = null;
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam1.mode)) {
            urlParam2 = new WbsUrlParam();
            urlParam2.mode = Wbs1Constants.OperationMode.administrator.name();
            urlParam2.param1 = Long.toString(answer.personId);
            paramMap = WbxParameterUtil.getInstance().createParamMap(urlParam2);
            param1 = WbfwUtil.createEncryptQuery(paramMap);
            href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.form)) + WbfwUtil.createUrlQuery(param1);
        } else {
            urlParam2 = new WbsUrlParam();
            urlParam2.param1 = Long.toString(answer.personId);
            paramMap = WbxParameterUtil.getInstance().createParamMap(urlParam2);
            param1 = WbfwUtil.createEncryptQuery(paramMap);
            href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.view)) + WbfwUtil.createUrlQuery(param1);
        }
        StringBuilder sb = new StringBuilder();
        String onclickAction = WbfJslUtil.locationHref(href);
        String button = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().edit, onclickAction);
        sb.append(this.getHtmlBuilder().div_start());
        sb.append(button);
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    class InnerFieldHtmlCreator
    extends WbsFiledHtmlCreator {
        Map<Short, Wbs1Question> questionMap;

        public InnerFieldHtmlCreator(HtmlBuilder htmlBuilder) {
            super(htmlBuilder);
        }

        @Override
        protected boolean isEnabled(Field field, MmdField mmdField, int arrayIndex) throws Exception {
            if (field.getName().equals(Wbs1Answer.FieldName.items.name())) {
                short questionNumber = XwebQuestionUtil.arrayIndexToQuestionNumber(arrayIndex);
                return this.questionMap.containsKey(questionNumber);
            }
            if (field.getName().equals(Wbs1Judgement.FieldName.judgementReason.name())) {
                return super.isEnabled(field, mmdField, arrayIndex);
            }
            return super.isEnabled(field, mmdField, arrayIndex);
        }

        @Override
        protected String labelAndTextField(String inputName, Object entity, Field field, MmdField mmdField, String value, Collection errMsgCollection, int arrayIndex, boolean required, boolean disabled, boolean readonly, boolean characterCounterEnabled) throws Exception {
            if (field.getName().equals(Wbs1Answer.FieldName.items.name())) {
                short questionNumber = XwebQuestionUtil.arrayIndexToQuestionNumber(arrayIndex);
                Wbs1Question question = this.questionMap.get(questionNumber);
                StringBuilder sb = new StringBuilder();
                if (ProfileInputType.textField.name().equals(question.inputType)) {
                    sb.append(super.labelAndTextField(inputName, entity, field, mmdField, value, errMsgCollection, arrayIndex, required, disabled, readonly, characterCounterEnabled));
                } else if (ProfileInputType.textArea.name().equals(question.inputType)) {
                    mmdField.columnCount = 40;
                    mmdField.fieldDisplay.rowCount = 4;
                    sb.append(super.labelAndTextField(inputName, entity, field, mmdField, value, errMsgCollection, arrayIndex, required, disabled, readonly, characterCounterEnabled));
                } else if (ProfileInputType.select.name().equals(question.inputType)) {
                    String label = this.getLabelText(entity, field, mmdField, arrayIndex);
                    String script = null;
                    String errMsg = HtmlUtil.encode(errMsgCollection);
                    String helperText = null;
                    List<String> optionList = BcCsvUtil.parseCsvRow(question.option, true);
                    String[] options = optionList.toArray(new String[optionList.size()]);
                    MdcLabelAndInputBuilder labelAndInputBuilder = this.getInputBuilder();
                    sb.append(labelAndInputBuilder.createSelect(inputName, disabled, readonly, label, value, required, helperText, script, errMsg, options));
                } else if (ProfileInputType.checkBox.name().equals(question.inputType)) {
                    String label = this.getLabelText(entity, field, mmdField, arrayIndex);
                    XdtsControlContext controlContext = new XdtsControlContext();
                    controlContext.controlType = XdtsConstants.ControlType.CheckBox;
                    controlContext.options = question.option;
                    controlContext.defaultValue = value;
                    XdtsUserSetting userSetting = null;
                    WhcComponent whcComponent = XdsDataViewUtil.createHtmlComponent(controlContext, userSetting, String.valueOf(inputName) + "[]");
                    WhcBuilder whcBuilder = new WhcBuilder(this.getHtmlBuilder());
                    sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_box_1.className));
                    sb.append(ExtwCssUtil.extw_box_title(this.getHtmlBuilder(), label, null));
                    sb.append(whcBuilder.createComponentHtml(whcComponent, true));
                    sb.append(this.getHtmlBuilder().div_end());
                } else {
                    throw new Exception("itemAttribute.inputType=" + question.inputType);
                }
                return sb.toString();
            }
            return super.labelAndTextField(inputName, entity, field, mmdField, value, errMsgCollection, arrayIndex, required, disabled, readonly, characterCounterEnabled);
        }

        @Override
        protected String getLabelText(Object entity, Field field, MmdField mmdField, int arrayIndex) throws Exception {
            if (field.getName().equals(Wbs1Answer.FieldName.items.name())) {
                short questionNumber = XwebQuestionUtil.arrayIndexToQuestionNumber(arrayIndex);
                Wbs1Question question = this.questionMap.get(questionNumber);
                return question.name;
            }
            return super.getLabelText(entity, field, mmdField, arrayIndex);
        }
    }

    public static enum Method implements WbxPath
    {
        form("profile"),
        submit("profile-submit"),
        view("profile-view");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1PersonProfileWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }

    public static enum ProfileInputType {
        textField,
        textArea,
        select,
        checkBox;

    }
}

