/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.maildistributor.MldbMailHelper;
import jp.co.extreme.module.cmsv.common.CmsvConstants;
import jp.co.extreme.module.cmsv.dao.CmsvMessageDAO;
import jp.co.extreme.module.cmsv.model.CmsvMessage;
import jp.co.extreme.module.wbs1.model.WbsMessageCondition;
import jp.co.extreme.task.TskAbstractCallable;
import jp.co.extreme.web.server.WbsContainer;
import jp.co.extreme.web.server.WbsResourceHolder;
import jp.co.extreme.web.server.WbsSiteContext;

class XwebMailSendTask
extends TskAbstractCallable {
    XwebMailSendTask() {
    }

    public Object taskProcess() throws Exception {
        WbsContainer webContainer = WbsResourceHolder.getInstance().webContainer;
        ArrayList<String> dataSourceNameList = new ArrayList<String>();
        for (Map.Entry<Integer, WbsSiteContext> mapEntry : webContainer.siteIdMap.entrySet()) {
            WbsSiteContext siteContext = mapEntry.getValue();
            if (dataSourceNameList.contains(siteContext.getDataSourceName())) continue;
            this.mailSend(siteContext);
            dataSourceNameList.add(siteContext.getDataSourceName());
        }
        return null;
    }

    protected void mailSend(WbsSiteContext siteContext) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = DtsSessionFactoryManegaer.getInstance().createSession(siteContext.getDataSourceName(), this);){
            this.mailSend_L2(dtsSessionSite, siteContext);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void mailSend_L2(DtsSession dtsSessionSite, WbsSiteContext siteContext) throws Exception {
        CmsvMessageDAO mailDAO = CmsvMessageDAO.getInstance(CmsvConstants.MessageCategory.mail.tableName);
        WbsMessageCondition messageCondition = new WbsMessageCondition();
        messageCondition.messageStatus = CmsvConstants.MessageStatus.Unsent;
        List mailList = mailDAO.getList(dtsSessionSite, CmsvMessageDAO.Mode.from, messageCondition, null);
        if (mailList.size() <= 0) {
            return;
        }
        this.getLogger().info("\u672a\u9001\u4fe1\u30e1\u30fc\u30eb\u6570=" + mailList.size());
        MldbMailHelper mailHelper = MldbMailHelper.getInstance();
        int i = 0;
        while (i < mailList.size()) {
            CmsvMessage wbs1Mail = (CmsvMessage)mailList.get(i);
            try {
                mailHelper.sendMessage(siteContext.smptProperties, siteContext.mailSenderUserName, siteContext.mailSenderPassword, wbs1Mail);
                wbs1Mail.sendEndDatetime = BcTimeUtil.createCalendar();
                mailDAO.putEntity(dtsSessionSite, wbs1Mail);
                dtsSessionSite.commit();
            }
            catch (Exception ex) {
                this.getLogger().error(ex);
                try {
                    wbs1Mail.log = ex.getMessage();
                    mailDAO.putEntity(dtsSessionSite, wbs1Mail);
                    dtsSessionSite.commit();
                }
                catch (Exception ex2) {
                    this.getLogger().error(ex2);
                }
            }
            ++i;
        }
    }
}

