/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.common;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.module.wbfw.common.WbsUploadContext;
import jp.co.extreme.web.server.WbsArgument;

public class Z_WbsMultiPartParser {
    public int buffSize = 8192;
    protected File tempDir;

    public void setTempDir(File tempDir) throws Exception {
        this.tempDir = tempDir;
    }

    public void parse(WbsArgument wcbArg) throws Exception {
        if (!wcbArg.getRequest().getContentType().toLowerCase().startsWith("multipart/form-data")) {
            throw new Exception("Content-Type \u304c 'multipart/form-data' \u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        String key = "boundary=";
        int index = wcbArg.getRequest().getContentType().indexOf(key);
        if (index < 0) {
            throw new Exception("use RFC1867!");
        }
        String boundary = wcbArg.getRequest().getContentType().substring(index + key.length());
        BcLogUtil.debug("boundary=" + boundary);
        if (BcStringUtil.isEmpty(boundary)) {
            throw new Exception("boundary \u3067\u4f55\u3082\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        this.parseL2(wcbArg, boundary);
    }

    protected void parseL2(WbsArgument wcbArg, String boundary) throws Exception {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        HttpServletRequest servReq = wcbArg.getRequest();
        String boundaryStr = "--" + boundary;
        byte[] byteArray = new byte[this.buffSize];
        ServletInputStream is = servReq.getInputStream();
        int readCnt = is.readLine(byteArray, 0, byteArray.length);
        if (readCnt == -1) {
            throw new IllegalArgumentException("InputStream truncated");
        }
        String line = new String(byteArray, 0, readCnt, BcConstants.charset);
        if (!line.startsWith(boundaryStr)) {
            throw new IllegalArgumentException("MIME boundary missing: " + line);
        }
        while ((readCnt = is.readLine(byteArray, 0, byteArray.length)) != -1) {
            line = new String(byteArray, 0, readCnt - 2, BcConstants.charset);
            String lineLower = line.toLowerCase();
            if (!lineLower.startsWith("content-disposition")) continue;
            int ind = lineLower.indexOf("content-disposition: ");
            int ind2 = lineLower.indexOf(";");
            if (ind == -1 || ind2 == -1) {
                throw new IllegalArgumentException("Content Disposition line misformatted: " + line);
            }
            String disposition = lineLower.substring(ind + 21, ind2);
            if (!disposition.equals("form-data")) {
                throw new IllegalArgumentException("Content Disposition of " + disposition + " is not supported");
            }
            int ind3 = lineLower.indexOf("name=\"", ind2);
            int ind4 = lineLower.indexOf("\"", ind3 + 7);
            if (ind3 == -1 || ind4 == -1) {
                throw new IllegalArgumentException("Content Disposition line misformatted: " + line);
            }
            String keyName = line.substring(ind3 + 6, ind4);
            int ind5 = lineLower.indexOf("filename=\"", ind4 + 2);
            int ind6 = lineLower.indexOf("\"", ind5 + 10);
            String fileName = null;
            File tempFile = null;
            OutputStream os = null;
            if (ind5 != -1 && ind6 != -1) {
                fileName = line.substring(ind5 + 10, ind6);
                BcLogUtil.debug("fileName=" + fileName);
                BcFileUtil.mkdirs(this.tempDir, new FileAttribute[0]);
                tempFile = File.createTempFile("upload_", null, this.tempDir);
                BcLogUtil.debug("tempFile.getPath()=" + tempFile.getPath());
                os = new BufferedOutputStream(new FileOutputStream(tempFile));
            } else {
                os = new ByteArrayOutputStream();
            }
            readCnt = is.readLine(byteArray, 0, byteArray.length);
            if (readCnt == -1) {
                return;
            }
            line = new String(byteArray, 0, readCnt - 2, BcConstants.charset);
            lineLower = line.toLowerCase();
            if (lineLower.startsWith("Content-Type".toLowerCase())) {
                int ind7 = lineLower.indexOf(" ");
                if (ind7 == -1) {
                    throw new IllegalArgumentException("Content-Type line misformatted: " + line);
                }
                String contentType = lineLower.substring(ind7 + 1);
                readCnt = is.readLine(byteArray, 0, byteArray.length);
                if (readCnt == -1) {
                    return;
                }
                line = new String(byteArray, 0, readCnt - 2, BcConstants.charset);
                if (line.length() != 0) {
                    throw new IllegalArgumentException("Unexpected line in MIMEpart header: " + line);
                }
            } else if (line.length() != 0) {
                throw new IllegalArgumentException("Misformatted line following disposition: " + line);
            }
            ByteArrayOutputStream receivedBuffer = new ByteArrayOutputStream();
            int size = byteArray.length;
            while ((size = is.readLine(byteArray, 0, byteArray.length)) != -1) {
                line = new String(byteArray, 0, size);
                if (line.indexOf(boundary) != -1) break;
                receivedBuffer.write(byteArray, 0, size);
            }
            byte[] buf = receivedBuffer.toByteArray();
            os.write(buf, 0, buf.length - 2);
            os.flush();
            os.close();
            if (fileName == null) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)os;
                if (parameterMap.containsKey(keyName)) {
                    Object preObj = parameterMap.get(keyName);
                    if (preObj instanceof String[]) {
                        String[] preStrings = (String[])preObj;
                        String[] newStrings = new String[preStrings.length + 1];
                        System.arraycopy(preStrings, 0, newStrings, 0, preStrings.length);
                        newStrings[preStrings.length] = new String(baos.toByteArray(), BcConstants.charset);
                        BcLogUtil.info("\u8981\u4fee\u6b63\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01" + line);
                        continue;
                    }
                    parameterMap.put(keyName, preObj.toString());
                    continue;
                }
                String strValue = new String(baos.toByteArray(), BcConstants.charset);
                parameterMap.put(keyName, strValue);
                continue;
            }
            if (tempFile.length() <= 0L) continue;
            WbsUploadContext uploadContext = new WbsUploadContext();
            uploadContext.fileName = fileName;
            uploadContext.tempFile = tempFile;
        }
        return;
    }
}

