/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.ffmpeg;

import java.io.File;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcProcessExecutor;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.module.ffmpeg.FfmpegParamBuiler;
import jp.co.extreme.module.ffmpeg.FfpegParam;
import jp.co.extreme.module.ffmpeg.FfpegText;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class FfmpegHelper
extends BcLoggableObject {
    public static final String FORMAT_time = "HH:mm:ss.SSS";
    protected BcProcessExecutor processExecutor = new BcProcessExecutor();
    private String ffmpegPath;
    private BcResult result;
    public static final String m3u8 = "m3u8";

    public FfmpegHelper() {
        BcResult result = new BcResult();
        result.addError("FFmpeg is not set.");
        this.setResult(result);
    }

    public static FfmpegHelper getInstance() {
        return SingletonHolder.instance;
    }

    @Override
    public void setLogger(BcLogger logger) {
        super.setLogger(logger);
        this.processExecutor.setLogger(logger);
    }

    public String getFfmpegPath() {
        return this.ffmpegPath;
    }

    public void setFfmpegPath(String ffmpegPath) {
        this.ffmpegPath = ffmpegPath;
        this.getLogger().info("FFmpeg path=" + ffmpegPath);
        if (!BcStringUtil.isEmpty(ffmpegPath)) {
            File file = new File(ffmpegPath);
            if (file.exists()) {
                if (!file.setExecutable(true, false)) {
                    this.result.addError(String.format("%s is not executable.", file.getName()));
                }
            } else {
                BcResult result = new BcResult();
                result.addError(BcWords.getInstance().$_does_not_exists(file.getPath()));
                this.setResult(result);
                return;
            }
        }
        try {
            this.getLogger().info(this.getVersion());
            this.setResult(new BcResult());
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
            BcResult result = new BcResult();
            result.addError(ex);
            this.setResult(result);
        }
    }

    public Integer getVersion() throws Exception {
        FfmpegParamBuiler ffmpegParamBuiler = new FfmpegParamBuiler();
        List<String> argList = ffmpegParamBuiler.version().build();
        BcProcessExecutor.BcProcessResult processResult = this.processExecutor.execute(this.ffmpegPath, argList);
        return processResult.exitValue;
    }

    public BcResult getResult() {
        return this.result;
    }

    public void setResult(BcResult result) {
        this.result = result;
    }

    public String formatDuration(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, FORMAT_time);
    }

    public List<String> createArgList(FfpegParam ffpegParam) throws Exception {
        FfmpegParamBuiler ffmpegParamBuiler = new FfmpegParamBuiler();
        ffmpegParamBuiler.startTimeMillis(ffpegParam.startTimeMillis);
        ffmpegParamBuiler.input(ffpegParam.inputPath);
        ffmpegParamBuiler.scale(ffpegParam.width, ffpegParam.height);
        if (!BcCollectionUtil.isEmpty(ffpegParam.ffpegTextList)) {
            for (FfpegText ffpegText : ffpegParam.ffpegTextList) {
                ffmpegParamBuiler.text(ffpegText);
            }
        }
        List<String> argList = ffmpegParamBuiler.build();
        argList.add("-vframes");
        argList.add("1");
        argList.add("-f");
        argList.add("image2");
        argList.add("-y");
        argList.add(ffpegParam.outputPath);
        return argList;
    }

    public BcProcessExecutor.BcProcessResult createImage(FfpegParam ffpegParam) throws Exception {
        List<String> argList = this.createArgList(ffpegParam);
        argList.add(0, this.ffmpegPath);
        BcProcessExecutor.BcProcessResult processResult = this.processExecutor.execute(argList);
        return processResult;
    }

    public List<String> createArgList(File imputFile, File outputFile, int width, int height, Collection<Long> frameNoCollection) throws Exception {
        FfmpegParamBuiler ffmpegParamBuiler = new FfmpegParamBuiler();
        ffmpegParamBuiler.input(imputFile.getPath());
        ffmpegParamBuiler.scale(width, height);
        ffmpegParamBuiler.eq(frameNoCollection);
        List<String> argList = ffmpegParamBuiler.build();
        argList.add("-vsync");
        argList.add("0");
        argList.add("-f");
        argList.add("image2");
        argList.add("-y");
        argList.add(String.valueOf(outputFile.getParentFile().getPath()) + "/out-%03d.jpg");
        return argList;
    }

    public BcProcessExecutor.BcProcessResult createImage(File imputFile, File outputFile, int width, int height, Collection<Long> frameNoCollection) throws Exception {
        List<String> argList = this.createArgList(imputFile, outputFile, width, height, frameNoCollection);
        BcProcessExecutor.BcProcessResult processResult = this.processExecutor.execute(this.ffmpegPath, argList);
        return processResult;
    }

    public BcProcessExecutor.BcProcessResult createHls(File imputFile, File outputFile) throws Exception {
        this.getLogger().debug("Creating HLS... imput=" + imputFile.getPath() + " output=" + outputFile.getPath());
        BcFileUtil.createParentIfNotExists(outputFile.toPath());
        FfmpegParamBuiler ffmpegParamBuiler = new FfmpegParamBuiler();
        ffmpegParamBuiler.input(imputFile.getPath());
        String segmentFilename = String.valueOf(BcFileUtil.getBaseName(outputFile.getName())) + "-%4d.ts";
        File segmentFile = new File(outputFile.getParentFile(), segmentFilename);
        List<String> argList = ffmpegParamBuiler.build();
        argList.add("-c:v");
        argList.add("copy");
        argList.add("-c:a");
        argList.add("copy");
        argList.add("-f");
        argList.add("hls");
        argList.add("-hls_time");
        argList.add("10");
        argList.add("-hls_playlist_type");
        argList.add("vod");
        argList.add("-hls_segment_filename");
        argList.add(segmentFile.getPath());
        argList.add(outputFile.getPath());
        BcProcessExecutor.BcProcessResult processResult = this.processExecutor.execute(this.ffmpegPath, argList);
        return processResult;
    }

    public String nameTo_m3u8(String fileName) throws Exception {
        String newFileName = BcFileUtil.createFileName(BcFileUtil.getBaseName(fileName), m3u8, null);
        return newFileName;
    }

    public static enum Resolution {
        _144p(256, 144, "144p", null),
        _240p(427, 240, "240p", null),
        _360p(640, 360, "360p", null),
        _480p(720, 480, "480p", "DVD"),
        _720p(1280, 720, "720p", "HD:\u30cf\u30a4\u30d3\u30b8\u30e7\u30f3"),
        _1080p(1920, 1080, "1080p", "\u30d5\u30ebHD:\u30d5\u30eb\u30cf\u30a4\u30d3\u30b8\u30e7\u30f3 2K"),
        _1440p(2560, 1440, "1440p", null),
        _2160p(3840, 2160, "2160p", "4K");

        public final int width;
        public final int height;
        public final String code;
        public final String note;

        private Resolution(int width, int height, String code, String note) {
            this.width = width;
            this.height = height;
            this.code = code;
            this.note = note;
        }

        public static Resolution getByCode(String code) {
            Resolution[] resolutionArray = Resolution.values();
            int n = resolutionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resolution resolution = resolutionArray[n2];
                if (resolution.code.equalsIgnoreCase(code)) {
                    return resolution;
                }
                ++n2;
            }
            return null;
        }
    }

    private static final class SingletonHolder {
        private static final FfmpegHelper instance = new FfmpegHelper();

        private SingletonHolder() {
        }
    }
}

