/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.lib.square;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.square.Environment;
import com.squareup.square.SquareClient;
import com.squareup.square.api.PaymentsApi;
import com.squareup.square.models.CreatePaymentRequest;
import com.squareup.square.models.CreatePaymentResponse;
import com.squareup.square.models.Money;
import java.io.BufferedReader;
import java.util.UUID;
import jp.co.extreme.lib.square.SquareCredentials;

public final class SquareUtil {
    private SquareUtil() {
    }

    public static CreatePaymentResponse createPaymentResponse(String accessToken, Environment environment, String nonce, long amount, Currency currency) throws Exception {
        SquareClient squareClient = new SquareClient.Builder().environment(environment).accessToken(accessToken).build();
        Money bodyAmountMoney = new Money.Builder().amount(Long.valueOf(amount)).currency(currency.name()).build();
        CreatePaymentRequest createPaymentRequest = new CreatePaymentRequest.Builder(nonce, UUID.randomUUID().toString(), bodyAmountMoney).autocomplete(Boolean.valueOf(true)).note("From a Square sample Java app").build();
        PaymentsApi paymentsApi = squareClient.getPaymentsApi();
        CreatePaymentResponse createPaymentResponse = paymentsApi.createPayment(createPaymentRequest);
        return createPaymentResponse;
    }

    public static String getNonce(BufferedReader bufferedReader) throws Exception {
        String jsonText = bufferedReader.readLine();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(jsonText);
        return jsonNode.get("nonce").asText();
    }

    public static SquareCredentials getCredentials() throws Exception {
        SquareCredentials credentials = new SquareCredentials();
        credentials.appId = "sandbox-sq0idb-AQG93h3iRq4tLuzY8WGPxA";
        credentials.accessToken = "EAAAEJ5vX3ln3CT_SeTL6xzy2kBpDzWG255JkGxoQt41nVWAkamjX1ct3Z7BOAeu";
        credentials.locationId = "70RCS7Z7TYY4N";
        return credentials;
    }

    public static enum Currency {
        JPY,
        USD;

    }
}

