/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.control;

import java.math.BigDecimal;
import javafx.geometry.Pos;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.control.FxTextField;

public class FxNumberField
extends FxTextField {
    private int integerPartDigits;
    private int decimalDigits;
    private int roundingMode = 4;
    public boolean nullable;
    private Number defauleValue = 0;
    private BigDecimal maxValue;
    private BigDecimal minValue;

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public FxNumberField(int integerPartDigits, int decimalDigits, boolean nullable) {
        this.integerPartDigits = integerPartDigits;
        this.decimalDigits = decimalDigits;
        this.nullable = nullable;
        this.setAlignment(Pos.CENTER_RIGHT);
    }

    public FxNumberField() {
        this.setAlignment(Pos.CENTER_RIGHT);
    }

    @Override
    public void textEdited() {
        if (BcStringUtil.isEmpty(this.getText())) {
            if (!this.nullable) {
                BigDecimal bigDecimal = new BigDecimal(this.defauleValue.toString());
                this.setValue(bigDecimal);
            }
            return;
        }
        try {
            BigDecimal bigDecimal = BcNumberUtil.toBigDecimal2(this.getText(), this.integerPartDigits, this.decimalDigits, this.roundingMode);
            this.setValue(bigDecimal);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            super.setText(null);
        }
    }

    public BigDecimal getBigDecimal() {
        BigDecimal bigDecimal = null;
        if (!BcStringUtil.isEmpty(this.getText())) {
            bigDecimal = new BigDecimal(this.getText());
        }
        return bigDecimal;
    }

    public void setValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.setText(null);
        } else {
            BigDecimal bigDecimal2 = this.validateValue(bigDecimal);
            this.setText(bigDecimal2.toString());
        }
    }

    public void setValue(Number number) {
        BigDecimal bigDecimal2 = null;
        if (number != null) {
            bigDecimal2 = new BigDecimal(number.toString());
        }
        this.setValue(bigDecimal2);
    }

    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    protected BigDecimal validateValue(BigDecimal value) {
        BigDecimal resValue = value;
        if (value != null) {
            if (this.minValue != null && value.compareTo(this.minValue) < 0) {
                resValue = this.minValue;
            }
            if (this.maxValue != null && value.compareTo(this.maxValue) > 0) {
                resValue = this.maxValue;
            }
        }
        return resValue;
    }
}

