/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.etc.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.sql.context.SqlContext;

public class EtcEnumStrUtil {
    public static final String DELIMITER = BcStringUtil.COMMA_STR;
    public static final String STRAT = BcStringUtil.PARENTHESES_STRAT_STR;
    public static final String END = BcStringUtil.PARENTHESES_END_STR;

    private EtcEnumStrUtil() {
    }

    public static String toElement(Object value) throws Exception {
        if (value == null) {
            String msg = "value is null.";
            throw new Exception(msg);
        }
        String str = BcStringUtil.toString(value);
        return String.valueOf(STRAT) + str + END;
    }

    public static List<String> toElementList(Collection<?> valueCollection) throws Exception {
        ArrayList<String> elementList = new ArrayList<String>();
        for (Object value : valueCollection) {
            elementList.add(EtcEnumStrUtil.toElement(value));
        }
        return elementList;
    }

    public static String elementCollectionToEnum(Collection<?> elementCollection) throws Exception {
        if (elementCollection.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int index = -1;
        for (Object element : elementCollection) {
            if (++index > 0) {
                sb.append(DELIMITER);
            }
            sb.append(element);
        }
        return sb.toString();
    }

    public static String valueCollectionToEnum(Collection<?> valueCollection) throws Exception {
        List<String> elementList = EtcEnumStrUtil.toElementList(valueCollection);
        return EtcEnumStrUtil.elementCollectionToEnum(elementList);
    }

    public static List<String> toElementList(String enumStr) throws Exception {
        ArrayList<String> elementList = null;
        if (BcStringUtil.isEmpty(enumStr)) {
            elementList = new ArrayList<String>();
            return elementList;
        }
        String[] elementArray = enumStr.split(DELIMITER, 0);
        elementList = new ArrayList<String>(Arrays.asList(elementArray));
        return elementList;
    }

    public static List<String> toValueList(String enumStr) throws Exception {
        List<String> elementList = EtcEnumStrUtil.toElementList(enumStr);
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < elementList.size()) {
            String element = elementList.get(i);
            String valus = element.substring(1, element.length() - 1);
            valueList.add(valus);
            ++i;
        }
        return valueList;
    }

    public static int getIndex(String enumStr, String value) throws Exception {
        if (BcStringUtil.isEmpty(enumStr)) {
            return -1;
        }
        String element = EtcEnumStrUtil.toElement(value);
        return enumStr.indexOf(element);
    }

    public static boolean contains(String enumStr, String value) throws Exception {
        return EtcEnumStrUtil.getIndex(enumStr, value) >= 0;
    }

    public static String addValue(String enumStr, String value, boolean duplicate) throws Exception {
        String element = EtcEnumStrUtil.toElement(value);
        List<String> elementList = EtcEnumStrUtil.toElementList(enumStr);
        if (!duplicate && elementList.contains(element)) {
            return enumStr;
        }
        elementList.add(element);
        return EtcEnumStrUtil.elementCollectionToEnum(elementList);
    }

    public static String createWhereCondition(SqlContext sqlContext, String tableName, String columnName, String enumStr) throws Exception {
        if (BcStringUtil.isEmpty(enumStr)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        List<String> elementList = EtcEnumStrUtil.toElementList(enumStr);
        int i = 0;
        while (i < elementList.size()) {
            String element = elementList.get(i);
            if (i > 0) {
                sb.append(" OR ");
            }
            if (!BcStringUtil.isEmpty(tableName)) {
                sb.append(String.valueOf(tableName) + ".");
            }
            sb.append(String.valueOf(columnName) + sqlContext.toKeyword(element));
            ++i;
        }
        return "(" + sb + ")";
    }

    public static List<Integer> toIdList(String enumStr) throws Exception {
        List<String> elementList = EtcEnumStrUtil.toElementList(enumStr);
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        int i = 0;
        while (i < elementList.size()) {
            String valueStr = elementList.get(i);
            valueStr = valueStr.replace(STRAT, "");
            valueStr = valueStr.replace(END, "");
            valueList.add(BcNumberUtil.parseInteger(valueStr));
            ++i;
        }
        return valueList;
    }
}

