/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.assembler.wbs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.assembler.wbs.TbcpCsvComparatorTask;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcSIUnitUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.lib.html.mdc.MdcCreator;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.tbcp.common.TbcpUtil;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbfw.common.WbsUploadContext;
import jp.co.extreme.module.wbfw.server.XwebMailHelper;
import jp.co.extreme.module.wbs1.common.Wbs1Words;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.WbsFileUploadFormCreator;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.WbsFiledHtmlCreator;
import jp.co.extreme.module.xweb.common.WbsProgress;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxFormBuilder;
import jp.co.extreme.module.xweb.common.WbxFormData;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.jquery.progress.JqProgressUtil;
import jp.co.extreme.web.jquery.upload.JqUploadUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;
import jp.co.extreme.web.upload.WebDndUtil;
import jp.co.extreme.web.upload.WebFileCheckUtil;
import jp.co.extreme.web.upload.WebFormValidationUtil;
import jp.co.extreme.web.upload.WebImagePreviewUtil;
import jp.co.extreme.web.upload.WebProcessUtil;

public class AsemCsvDiffWCB
extends Wbs1AbstractWCB {
    public void form(WbsArgument wcbArg) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        boolean isForm = true;
        if (tokenContext.validationResult != null) {
            this.getLogger().debug("tokenContext.validationResult.hasError()=" + tokenContext.validationResult.hasError());
            isForm = tokenContext.validationResult.hasError();
        }
        WbxFormData formData = new WbxFormData();
        formData.title = Wbs1Words.getInstance().csvComparison.toPlain();
        formData.description = "\uff12\u3064\u306eCSV\u3092\u6bd4\u8f03\u3057\u3001\u5dee\u5206\u3092 Excel \u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u51fa\u529b\u3057\u307e\u3059\u3002\u5229\u7528\u898f\u7d04\u306b\u540c\u610f\u306e\u3046\u3048\u3001\u3054\u5229\u7528\u304f\u3060\u3055\u3044\u3002";
        StringBuilder fileds = new StringBuilder();
        WbsFiledHtmlCreator filedHtmlCreator = new WbsFiledHtmlCreator(this.getHtmlBuilder());
        WbsFileUploadFormCreator uploadFormCreator = new WbsFileUploadFormCreator();
        int i = 0;
        while (i < 2) {
            if (i > 0) {
                fileds.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
            }
            String fileIdSuffix = Integer.toString(i + 1);
            String dndArea = WebImagePreviewUtil.temp(this.getHtmlBuilder(), uploadFormCreator, "file" + fileIdSuffix, fileIdSuffix);
            fileds.append(WebImagePreviewUtil.fileBox(this.getHtmlBuilder(), String.valueOf(BcWords.getInstance().file) + "-" + fileIdSuffix, dndArea, WebFileCheckUtil.maxSize));
            ++i;
        }
        fileds.append(JqProgressUtil.getInstance().createProgressTags(this.getHtmlBuilder()));
        fileds.append(JqProgressUtil.getInstance().createResultDiv(this.getHtmlBuilder(), null));
        formData.fileds = fileds.toString();
        StringBuilder controls = new StringBuilder();
        String onclick = "tmp_start();";
        String executeButton = MdcCreator.getInstance().button(HtmlConstants.HtmlButtonType.button, BcWords.getInstance().execute, onclick, null, WbxConstants.ElementId.executeButton.id, null, true);
        controls.append(executeButton);
        controls.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        formData.controls = controls.toString();
        WbxFormBuilder formBuilder = new WbxFormBuilder(this.getHtmlBuilder2());
        StringBuilder sb = new StringBuilder();
        sb.append(formBuilder.build(formData));
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        ArrayList<String> bodyScriptList = new ArrayList<String>();
        String urlBase = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.getProgress)) + "?" + (Object)((Object)WbxConstants.SessionAttributeKey.token) + "=";
        String script = JqProgressUtil.getInstance().getScript(urlBase);
        bodyScriptList.add(script);
        String url = XwebUtil.toRelativePath(wcbArg.getRequest(), Method.upload);
        script = JqUploadUtil.getInstance().getScript(url, String.valueOf(WebDndUtil.inputFileId) + 1, String.valueOf(WebDndUtil.inputFileId) + 2);
        bodyScriptList.add(script);
        bodyScriptList.add(WebImagePreviewUtil.getScript1());
        int i2 = 0;
        while (i2 < 2) {
            String fileIdSuffix = Integer.toString(i2 + 1);
            bodyScriptList.add(WebDndUtil.getScript(String.valueOf(WebDndUtil.dndAreaIdPrefix) + fileIdSuffix, String.valueOf(WebDndUtil.inputFileId) + fileIdSuffix, null, null));
            ++i2;
        }
        String maxMsg = WebFileCheckUtil.getMaxMsg(WebFileCheckUtil.maxSize);
        bodyScriptList.add(WebFileCheckUtil.getScript(WebFileCheckUtil.maxSize, maxMsg, new String[0]));
        bodyScriptList.add(WebFormValidationUtil.getScript(String.valueOf(WebDndUtil.inputFileId) + 1, String.valueOf(WebDndUtil.inputFileId) + 2));
        bodyScriptList.add(WebProcessUtil.getScript2());
        StringBuilder html = this.getBaseHtml(wcbArg);
        String metaDescription = "\uff12\u3064\u306eCSV\u3092\u6bd4\u8f03\u3057\u3001\u5dee\u5206\u3092 Excel \u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u51fa\u529b\u3057\u307e\u3059\u3002";
        html = this.replace(wcbArg, formData.getTitle(), metaDescription, html, null, bodyScriptList);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    public void upload(WbsArgument wcbArg) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.status);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        TbcpCsvComparatorTask csvComparatorTask = new TbcpCsvComparatorTask();
        csvComparatorTask.tokenContext = tokenContext;
        csvComparatorTask.condition = TbcpUtil.createCondition();
        if (!BcCollectionUtil.isEmpty(requestParameter.uploadContextList)) {
            int i = 0;
            while (i < requestParameter.uploadContextList.size()) {
                WbsUploadContext uploadContext = requestParameter.uploadContextList.get(i);
                this.getLogger().debug("fileName=" + uploadContext.fileName);
                File newFime = new File(AfbApplication.getInstance().getTempDir(), uploadContext.fileName);
                BcFileUtil.deleteIfExists(newFime);
                uploadContext.tempFile.renameTo(newFime);
                if (i == 0) {
                    csvComparatorTask.file1 = newFime;
                } else if (i == 1) {
                    csvComparatorTask.file2 = newFime;
                }
                ++i;
            }
        }
        BcResult result = new BcResult();
        WbsProgress progress = new WbsProgress();
        if (!result.hasError()) {
            ExecutorService executorService = Executors.newCachedThreadPool();
            csvComparatorTask.future = executorService.submit(csvComparatorTask);
            executorService.shutdown();
            XwebUtil.putToMap(tokenContext.map, csvComparatorTask);
            progress.statusId = WbxConstants.ProgressStatus.OK.id;
            progress.data = XwebUtil.createTokenString(tokenContext);
            this.getLogger().debug("upload:token=" + progress.data);
        } else {
            progress.statusId = WbxConstants.ProgressStatus.NG.id;
            progress.message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
        }
        ObjectMapper objectMapper = JacksonUtil.getObjectMapper();
        String jsonStr = objectMapper.writeValueAsString((Object)progress);
        WbfwUtil.outputJsonStr(wcbArg, jsonStr);
        XwebMailHelper.getInstance().addMailToWebMaster(wcbArg.getSiteContext(), this.getClass().getName(), "");
    }

    public void getProgress(WbsArgument wcbArg) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.status);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        TbcpCsvComparatorTask csvComparatorTask = (TbcpCsvComparatorTask)tokenContext.map.get(TbcpCsvComparatorTask.class.getName());
        File zipFile = (File)tokenContext.map.get(File.class.getName());
        WbsProgress progress = new WbsProgress();
        this.getLogger().debug("csvComparatorTask.statusId=" + csvComparatorTask.statusId);
        if (csvComparatorTask.statusId == WbxConstants.ProgressStatus.OK.id) {
            if (zipFile == null) {
                progress.statusId = WbxConstants.ProgressStatus.OK.id;
                progress.percent = csvComparatorTask.percent;
                progress.message = csvComparatorTask.message;
            } else {
                String link;
                progress.statusId = WbxConstants.ProgressStatus.Finished.id;
                progress.percent = 100.0;
                progress.message = "\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002\u4e0b\u8a18\u306e\u30ea\u30f3\u30af\u304b\u3089\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3092\u884c\u3063\u3066\u4e0b\u3055\u3044\u3002\uff08\u30d5\u30a1\u30a4\u30eb\u3092\u5dee\u3057\u66ff\u3048\u3066\u3001\u5f15\u304d\u7d9a\u304d\u3054\u5229\u7528\u306b\u306a\u308c\u307e\u3059\uff09";
                String token = XwebUtil.createTokenString(tokenContext);
                String param1 = WbfwUtil.createParameter((Enum)WbxConstants.SessionAttributeKey.token, token);
                String url = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.download)) + WbfwUtil.createUrlQuery(param1);
                String linkText = String.valueOf(zipFile.getName()) + " (" + BcSIUnitUtil.toByteString(zipFile.length()) + ")";
                progress.data = link = this.getHtmlBuilder().a(url, linkText);
            }
        } else {
            progress.statusId = WbxConstants.ProgressStatus.NG.id;
            progress.percent = csvComparatorTask.percent;
            progress.message = csvComparatorTask.message;
        }
        ObjectMapper objectMapper = JacksonUtil.getObjectMapper();
        String jsonStr = objectMapper.writeValueAsString((Object)progress);
        WbfwUtil.outputJsonStr(wcbArg, jsonStr);
    }

    public void download(WbsArgument wcbArg) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.status);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        this.getLogger().debug("download:map=" + requestParameter.map);
        File zipfile = (File)tokenContext.map.get(File.class.getName());
        WbfwUtil.outputFile(wcbArg, zipfile);
    }

    public static enum Method implements WbxPath
    {
        form("csv-diffex"),
        upload("csv-diffex-upload"),
        getProgress("csv-diffex-progress"),
        download("csv-diffex-download");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return AsemCsvDiffWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

