/*------------------------------------------------------------
  ExtMath
------------------------------------------------------------*/
class ExtMath {

  /**
   * 任意の桁で四捨五入する関数
   * @param {number} value 四捨五入する数値
   * @param {number} base どの桁で四捨五入するか（10→10の位、0.1→小数第１位）
   * @return {number} 四捨五入した値
   */
  static round(value, base) {
    return Math.round(value * base) / base;
  }

  /**
   * 任意の桁で切り上げする関数
   * @param {number} value 切り上げする数値
   * @param {number} base どの桁で切り上げするか（10→10の位、0.1→小数第１位）
   * @return {number} 切り上げした値
   */
  static ceil(value, base) {
    return Math.ceil(value * base) / base;
  }

  /**
   * 任意の桁で切り捨てする関数
   * @param {number} value 切り捨てする数値
   * @param {number} base どの桁で切り捨てするか（10→10の位、0.1→小数第１位）
   * @return {number} 切り捨てした値
   */
  static floor(value, base) {
    return Math.floor(value * base) / base;
  }
}




/*------------------------------------------------------------
  ExtCommon
------------------------------------------------------------*/
class ExtCommon {

  /**
   * isEmpty
   * @param obj {any} - Target Object
   */
  static isEmpty(obj) {
    if (obj === undefined || obj === null) {
      return true
    } else if (Object.prototype.toString.call(obj).slice(8, -1) === 'String') {
      if (obj === '') {
        return true
      }
    } else if (Object.prototype.toString.call(obj).slice(8, -1) === 'Array') {
      if (obj.length === 0) {
        return true
      }
    } else if (Object.prototype.toString.call(obj).slice(8, -1) === 'Object') {
      if (!Object.keys(obj).length) {
        return true
      }
    }
    return false
  }


}



/*------------------------------------------------------------
  ExtUtil
------------------------------------------------------------*/
class ExtUtil {

  /**
   * HTML文字列を Element に変換します。
   * @param html HTML文字列
   * @returns Element
   */
  static createElementFromHTML(html) {
    const tmpElem = document.createElement('div');
    tmpElem.innerHTML = html;
    //console.log('firstElementChild='+tmpElem.firstElementChild);
    return tmpElem.firstElementChild;
  }


  // タッチデバイスかを判定します
  static isTouchDevice() {
    return (('ontouchstart' in window) || window.DocumentTouch && document instanceof DocumentTouch);
  }


  // デバイスに応じたクリックイベントタイプを返します。
  static getClickEventType() {
    const isTouchDevice = isTouchDevice();
    return (isTouchDevice) ? 'touchend' : 'click';
  }

}



/*------------------------------------------------------------
  LogLevel
------------------------------------------------------------*/
const LogLevel = {
   OFF   : 0
 , ERROR : 1
 , WARN  : 2
 , INFO  : 3
 , DEBUG : 4
 , ALL   : 5
};

let logger = function logger() {}

logger.error  = function(msg){
  //const logLevel = LogLevel.ERROR;
  if (logLevel >= LogLevel.ERROR) console.error(msg);
}
logger.warn  = function(msg){
  //const logLevel = LogLevel.WARN;
  if (logLevel >= LogLevel.WARN) console.warn(msg);
}
logger.info  = function(msg){
  //const logLevel = LogLevel.INFO;
  if (logLevel >= LogLevel.INFO) console.info(msg);
}
logger.debug  = function(msg){
  //const logLevel = LogLevel.DEBUG;
  if (logLevel >= LogLevel.DEBUG) console.debug(msg);
}

const logLevel = LogLevel.INFO;


/*------------------------------------------------------------
  ProgressStatus
------------------------------------------------------------*/
const ProgressStatus = { 
   OK : 1
 , NG : 2
 , Finished : 3
};




/*------------------------------------------------------------
  ExtWrapper
------------------------------------------------------------*/
class ExtWrapper {

  constructor(value) {
    this.value = value;
  }

}



let jsgv_currentForm = null;
let jsgv_currentElement = null;
let submited = false;


function jsfn_alert(msg) {
  alert(msg);
}


function jsfn_submitEnabled() {
  //alert(submited);
  if(!submited) {
    submited = true;
    return true;
  } else {
    return false;
  }
}


function jsfn_href(url) {
  if(jsfn_submitEnabled()) {
    document.location.href = url;
  }
  return false;
}


function jsfn_isNull(value) {
  if (value == null || value == '') {
    return true;
  } else {
    return false;
  } 
}


function jsfn_submit(form) {
  if (!jsfn_submitEnabled()) {
    return;
  }
  form.submit();
}


function jsfn_submit2(form, url) {
  //alert(url);
  if (!jsfn_submitEnabled()) {
    return;
  }
  form.action = url;
  form.submit();
}


function jsfn_submit3(form, url, element, value) {
  if (!jsfn_submitEnabled()) {
    return;
  }
  form.action = url;
  element.value = value;
  form.submit();
}


function jsfn_setFormDisabled(form, disabled) {
  len = form.elements.length;
  for (i=0; i<len; i++) {
    form.elements[i].disabled = disabled;
  }
}


function jsfn_setCurrentForm(form) {
  jsgv_currentForm = form;
}


// element の 親である form が取得できるなら引数に form は必要無い
function jsfn_setCurrentElement(form, element) {
  jsgv_currentForm = form;
  jsgv_currentElement = element;
}


function jsfn_setElementValueAndSubmit(element, value) {
  element.value = value;
  jsgv_currentForm.submit();
}


function jsfn_setCurrrentElementValueAndSubmit(value) {
  jsgv_currentElement.value = value;
  jsgv_currentForm.submit();
}


function jsfn_setParentCurrrentElementValueAndClose(value) {
  window.opener.jsfn_setCurrrentFieldValue(value);
  window.close();
}


function jsfn_setParentCurrrentElementValueAndClose(value) {
  window.opener.jsfn_setCurrrentFieldValue(value);
  window.close();
}


