const timeout = 3000;
const tryMax = 10;
const map = new WeakMap();


function resourceStandy() {
  //console.log('resourceStandy:#1');
  const elements = document.querySelectorAll('.${className}');
  //console.log('resourceStandy:elements.length='+elements.length);
  for (let i = 0; i < elements.length; i += 1) {
    const element = elements[i];
    //console.log('['+i+']:element='+element);
    resourceStandy2(element);
  }
}


function resourceStandy2(element) {
  //console.log(element='+element);
  const promise = fetchResourceProgress(element);
  //console.log('promise='+promise);
  promise.then((v) => {
    //console.log("v="+v);
    if (v == 1) {
      setTimeout(resourceStandy2(element), 3000);
    }
  })
  .catch((v) => {
    console.log("v="+v)
  })
}


async function fetchResourceProgress(element) {
  //console.log('getResourceProgress:entity_id='+element.dataset.entity_id);
  //const url = './file-progress?id='+element.dataset.entity_id;
  const url = '${url}' + element.dataset.entity_id;
  //console.log('url='+url);
  let res = null
  
  try {
    res = await fetch(url);
    //console.log('res.status='+res.status);
    if (!res.ok) {
      throw new Error(`Abnormal response: ${res.status}`);
    }
  } catch (err) {
    console.log('err='+err);
  }

  let num = 0;
  if (res == null || !res.ok) {
    const wrapper = map.get(element);
    //console.log('wrapper='+wrapper);
    if (wrapper == null) {
      map.set(element, new ExtWrapper(1));
      num = 1;
    } else {
      wrapper.value++;
      //console.log('wrapper.value='+wrapper.value);
      if (wrapper.value <= tryMax) {
        num = 1;
      }
    }
    return num;
  }

  const progress = await res.json();
  //console.log('fetchResourceProgress:#1:progress.statusId='+progress.statusId);
  if (progress.statusId == ProgressStatus.OK) {
    num = 1;

  } else if (progress.statusId == ProgressStatus.Finished) {
    //console.log('Finished:data='+progress.data);
    const newElement = ExtUtil.createElementFromHTML(progress.data)
    //console.log('replaceElement2:newElement='+newElement);
    element.parentNode.replaceChild(newElement, element);
    newElement.addEventListener('click', function() {
      replaceElement2(newElement);
    }, false);

  } else {
    console.log(progress.message);
    const newElement = ExtUtil.createElementFromHTML(progress.data)
    element.parentNode.replaceChild(newElement, element);
  }

  return num;
}


setTimeout(resourceStandy, timeout);



/* ----------------------------------------------------

// resolve1!!をreturnしているため、この値がresolveされる
async function resolveSample() {
    return 'resolve!!';
}

// resolveSampleがPromiseを返し、resolve!!がresolveされるため
// then()が実行されコンソールにresolve!!が表示される
resolveSample().then(value => {
    console.log(value); // => resolve!!
});


// reject!!をthrowしているため、この値がrejectされる
async function rejectSample() {
    throw new Error('reject!!');
}

// rejectSampleがPromiseを返し、reject!!がrejectされるため
// catch()が実行されコンソールにreject!!が表示される
rejectSample().catch(err => {
    console.log(err); // => reject!!
});


// resolveErrorはasync functionではないため、Promiseを返さない
function resolveError() {
    return 'resolveError!!';
}

// resolveErrorはPromiseを返さないため、エラーが発生して動かない
// Uncaught TypeError: resolveError(...).then is not a function
resolveError().then(value => {
    console.log(value);
});
*/
