/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTaskMirror;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.KeepAliveOutputStream;

public class FormatterElement {
    private String classname;
    private String extension;
    private OutputStream out = new KeepAliveOutputStream(System.out);
    private File outFile;
    private boolean useFile = true;
    private Object ifCond;
    private Object unlessCond;
    private Project project;
    public static final String XML_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter";
    public static final String BRIEF_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.BriefJUnitResultFormatter";
    public static final String PLAIN_FORMATTER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.PlainJUnitResultFormatter";
    public static final String FAILURE_RECORDER_CLASS_NAME = "org.apache.tools.ant.taskdefs.optional.junit.FailureRecorder";

    public void setType(TypeAttribute type) {
        if ("xml".equals(type.getValue())) {
            this.setClassname(XML_FORMATTER_CLASS_NAME);
        } else if ("brief".equals(type.getValue())) {
            this.setClassname(BRIEF_FORMATTER_CLASS_NAME);
        } else if ("failure".equals(type.getValue())) {
            this.setClassname(FAILURE_RECORDER_CLASS_NAME);
        } else {
            this.setClassname(PLAIN_FORMATTER_CLASS_NAME);
        }
    }

    public void setClassname(String classname) {
        this.classname = classname;
        if (XML_FORMATTER_CLASS_NAME.equals(classname)) {
            this.setExtension(".xml");
        } else if (PLAIN_FORMATTER_CLASS_NAME.equals(classname)) {
            this.setExtension(".txt");
        } else if (BRIEF_FORMATTER_CLASS_NAME.equals(classname)) {
            this.setExtension(".txt");
        }
    }

    public String getClassname() {
        return this.classname;
    }

    public void setExtension(String ext) {
        this.extension = ext;
    }

    public String getExtension() {
        return this.extension;
    }

    void setOutfile(File out) {
        this.outFile = out;
    }

    public void setOutput(OutputStream out) {
        if (out == System.out || out == System.err) {
            out = new KeepAliveOutputStream(out);
        }
        this.out = out;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    boolean getUseFile() {
        return this.useFile;
    }

    public void setIf(Object ifCond) {
        this.ifCond = ifCond;
    }

    public void setIf(String ifCond) {
        this.setIf((Object)ifCond);
    }

    public void setUnless(Object unlessCond) {
        this.unlessCond = unlessCond;
    }

    public void setUnless(String unlessCond) {
        this.setUnless((Object)unlessCond);
    }

    public boolean shouldUse(Task t) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper(t.getProject());
        return ph.testIfCondition(this.ifCond) && ph.testUnlessCondition(this.unlessCond);
    }

    JUnitTaskMirror.JUnitResultFormatterMirror createFormatter() throws BuildException {
        return this.createFormatter(null);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    JUnitTaskMirror.JUnitResultFormatterMirror createFormatter(ClassLoader loader) throws BuildException {
        if (this.classname == null) {
            throw new BuildException("you must specify type or classname");
        }
        Class<?> f = null;
        try {
            f = loader == null ? Class.forName(this.classname) : Class.forName(this.classname, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Using loader " + loader + " on class " + this.classname + ": " + e, e);
        }
        catch (NoClassDefFoundError e) {
            throw new BuildException("Using loader " + loader + " on class " + this.classname + ": " + e, e);
        }
        Object o = null;
        try {
            o = f.newInstance();
        }
        catch (InstantiationException e) {
            throw new BuildException(e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException(e);
        }
        if (!(o instanceof JUnitTaskMirror.JUnitResultFormatterMirror)) {
            throw new BuildException(String.valueOf(this.classname) + " is not a JUnitResultFormatter");
        }
        JUnitTaskMirror.JUnitResultFormatterMirror r = o;
        if (this.useFile && this.outFile != null) {
            this.out = new DelayedFileOutputStream(this.outFile);
        }
        r.setOutput(this.out);
        boolean needToSetProjectReference = true;
        try {
            Field field = r.getClass().getField("project");
            Object value = field.get(r);
            if (value instanceof Project) {
                needToSetProjectReference = false;
            }
        }
        catch (NoSuchFieldException field) {
        }
        catch (IllegalAccessException e) {
            throw new BuildException(e);
        }
        if (needToSetProjectReference) {
            try {
                Method setter = r.getClass().getMethod("setProject", Project.class);
                setter.invoke((Object)r, this.project);
            }
            catch (NoSuchMethodException value) {
            }
            catch (IllegalAccessException e) {
                throw new BuildException(e);
            }
            catch (InvocationTargetException e) {
                throw new BuildException(e);
            }
        }
        return r;
    }

    private static class DelayedFileOutputStream
    extends OutputStream {
        private BufferedOutputStream outputStream;
        private final File file;

        public DelayedFileOutputStream(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            DelayedFileOutputStream delayedFileOutputStream = this;
            synchronized (delayedFileOutputStream) {
                if (this.outputStream == null) {
                    this.outputStream = new BufferedOutputStream(new FileOutputStream(this.file));
                }
            }
            this.outputStream.write(b);
        }

        @Override
        public void flush() throws IOException {
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
    }

    public static class TypeAttribute
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"plain", "xml", "brief", "failure"};
        }
    }
}

