/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Visitor;

public class LocalVariableTable
extends Attribute {
    private LocalVariable[] local_variable_table;

    public LocalVariableTable(LocalVariableTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTable(), c.getConstantPool());
    }

    public LocalVariableTable(int name_index, int length, LocalVariable[] local_variable_table, ConstantPool constant_pool) {
        super((byte)5, name_index, length, constant_pool);
        this.local_variable_table = local_variable_table;
    }

    LocalVariableTable(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (LocalVariable[])null, constant_pool);
        int local_variable_table_length = input.readUnsignedShort();
        this.local_variable_table = new LocalVariable[local_variable_table_length];
        int i = 0;
        while (i < local_variable_table_length) {
            this.local_variable_table[i] = new LocalVariable(input, constant_pool);
            ++i;
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitLocalVariableTable(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.local_variable_table.length);
        LocalVariable[] localVariableArray = this.local_variable_table;
        int n = this.local_variable_table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable variable = localVariableArray[n2];
            variable.dump(file);
            ++n2;
        }
    }

    public final LocalVariable[] getLocalVariableTable() {
        return this.local_variable_table;
    }

    @Deprecated
    public final LocalVariable getLocalVariable(int index) {
        LocalVariable[] localVariableArray = this.local_variable_table;
        int n = this.local_variable_table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable variable = localVariableArray[n2];
            if (variable.getIndex() == index) {
                return variable;
            }
            ++n2;
        }
        return null;
    }

    public final LocalVariable getLocalVariable(int index, int pc) {
        LocalVariable[] localVariableArray = this.local_variable_table;
        int n = this.local_variable_table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable variable = localVariableArray[n2];
            if (variable.getIndex() == index) {
                int start_pc = variable.getStartPC();
                int end_pc = start_pc + variable.getLength();
                if (pc >= start_pc && pc <= end_pc) {
                    return variable;
                }
            }
            ++n2;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] local_variable_table) {
        this.local_variable_table = local_variable_table;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.local_variable_table.length) {
            buf.append(this.local_variable_table[i]);
            if (i < this.local_variable_table.length - 1) {
                buf.append('\n');
            }
            ++i;
        }
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        LocalVariableTable c = (LocalVariableTable)this.clone();
        c.local_variable_table = new LocalVariable[this.local_variable_table.length];
        int i = 0;
        while (i < this.local_variable_table.length) {
            c.local_variable_table[i] = this.local_variable_table[i].copy();
            ++i;
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    public final int getTableLength() {
        return this.local_variable_table == null ? 0 : this.local_variable_table.length;
    }
}

