/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.dao;

import jp.co.extreme.base.net.BcAddressPort;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.scf4.model.ScfRedirect;
import jp.co.extreme.sql.context.SqlContext;

public class ScfRedirectDAO
extends OrmAbstractDAO<ScfRedirect> {
    private ScfRedirectDAO() {
        super(new ScfRedirect[0]);
        this.setTableName("rmix_redirect");
    }

    public static ScfRedirectDAO getInstance() {
        return SingletonHolder.instance;
    }

    public int deleteRmiRedirect(DtsSession dtsSession, int rmiRedirectId) throws Exception {
        ScfRedirect rmiRedirect = new ScfRedirect();
        rmiRedirect.setEntityId(rmiRedirectId);
        int deleteCount = this.getPersistenceProxy().deleteEntity(dtsSession, this.tableName, rmiRedirect);
        return deleteCount;
    }

    public ScfRedirect getRmiRedirectByRemoteAddress(DtsSession dtsSession, String remoteHostAddress, BcAddressPort exclusionAddressPort) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        StringBuilder query = new StringBuilder();
        query.append("SELECT " + this.getPersistenceProxy().createSelectColumnPhrase(this.getEntityClass()) + " FROM " + this.tableName + " WHERE remote_host_address" + sqlContext.toCondition_string("=", remoteHostAddress));
        if (exclusionAddressPort != null) {
            query.append(" AND NOT (redirect_host_address" + sqlContext.toCondition_string("=", exclusionAddressPort.address) + " AND redirect_port = " + exclusionAddressPort.port + ")");
        }
        return (ScfRedirect)this.getEntity(dtsSession, query.toString());
    }

    /* synthetic */ ScfRedirectDAO(ScfRedirectDAO scfRedirectDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final ScfRedirectDAO instance = new ScfRedirectDAO(null);

        private SingletonHolder() {
        }
    }
}

