/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.common.HtmlTagAttribute;
import jp.co.extreme.module.xweb.common.FontawesomeUtil;

public class XwebIconManager
extends BcLoggableObject {
    private HtmlBuilder htmlBuilder;

    public XwebIconManager() {
        this.setHtmlBuilder(HtmlBuilder.getInstance());
    }

    public static XwebIconManager getInstance() {
        return SingletonHolder.instance;
    }

    public void setHtmlBuilder(HtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.htmlBuilder;
    }

    public static List<String> createClassList(WebIcon icon) throws Exception {
        switch (icon) {
            case angleLeft: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_angle_left);
            }
            case angleRight: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_angle_right);
            }
            case address: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_location_dot);
            }
            case attendanceSchedule: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_calendar_check);
            }
            case bars: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_bars);
            }
            case clock: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_clock);
            }
            case coins: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_coins);
            }
            case coupon: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_ticket);
            }
            case database: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_database);
            }
            case emailAddress: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_envelope);
            }
            case female: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_person_dress);
            }
            case femaleSymbol: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_venus);
            }
            case home: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_house);
            }
            case login: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_right_to_bracket);
            }
            case logout: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_right_from_bracket);
            }
            case mail: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_envelope);
            }
            case male: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_person);
            }
            case maleSymbol: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_mars_stroke_up);
            }
            case message: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_message);
            }
            case myPage: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_circle_user);
            }
            case nearestStation: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_train_subway);
            }
            case operatingOrganization: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_people_group);
            }
            case passwordForgot: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_file_circle_question);
            }
            case personalIdentification: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_person_dress);
            }
            case personalInformation: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_user_shield);
            }
            case play: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_play);
            }
            case privacyPolicy: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_user_shield);
            }
            case search: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_magnifying_glass);
            }
            case skull: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_skull);
            }
            case skullCrossbones: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_skull_crossbones);
            }
            case square: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_square);
            }
            case table: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_table_list);
            }
            case termsOfService: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_file_circle_check);
            }
            case upload: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_upload);
            }
            case userAccount: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_key);
            }
            case userRegistration: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_user_pen);
            }
            case video: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_video);
            }
            case video_slash: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_video_slash);
            }
            case dummy: {
                return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_circle_dot);
            }
        }
        return FontawesomeUtil.createClassList(FontawesomeUtil.FaIcon.fa_bug);
    }

    public static String createTag(HtmlGlobalAttribute globalAttribute, List<HtmlTagAttribute> tagAttributeList) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(HtmlBuilder.getInstance().i_start(globalAttribute, tagAttributeList, false));
        sb.append(HtmlBuilder.getInstance().i_end());
        return sb.toString();
    }

    public static String createTag(WebIcon icon, List<String> classList2, String style) throws Exception {
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        List<String> classList1 = XwebIconManager.createClassList(icon);
        if (classList2 != null) {
            classList1.addAll(classList2);
        }
        globalAttribute.clazz = BcStringUtil.toSsv(classList1);
        globalAttribute.style = style;
        return XwebIconManager.createTag(globalAttribute, null);
    }

    public static String createTag(WebIcon icon) throws Exception {
        return XwebIconManager.createTag(icon, null, null);
    }

    public static String createCss(String fontSize) throws Exception {
        CssBuiler cssBuiler = new CssBuiler();
        cssBuiler.color("var(--icon-color)");
        if (!BcStringUtil.isEmpty(fontSize)) {
            cssBuiler.font_size(fontSize);
        }
        return cssBuiler.build();
    }

    private static final class SingletonHolder {
        private static final XwebIconManager instance = new XwebIconManager();

        private SingletonHolder() {
        }
    }

    public static enum WebIcon {
        angleLeft,
        angleRight,
        address,
        attendanceSchedule,
        bars,
        clock,
        coins,
        coupon,
        database,
        emailAddress,
        female,
        femaleSymbol,
        home,
        login,
        logout,
        mail,
        male,
        maleSymbol,
        message,
        myPage,
        nearestStation,
        operatingOrganization,
        passwordForgot,
        personalIdentification,
        personalInformation,
        play,
        privacyPolicy,
        search,
        skull,
        skullCrossbones,
        square,
        table,
        termsOfService,
        upload,
        userAccount,
        userRegistration,
        video,
        video_slash,
        dummy;

    }
}

