/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.rmo;

import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.model.Wbs1ArticleCondition;
import jp.co.extreme.module.wbs1.server.Wbs1ServerUtil;
import jp.co.extreme.module.xsod.common.XsodWords;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf3.rmo.ScfSqlUtil;
import jp.co.extreme.scf3.server.ScfSqlServerTask;
import jp.co.extreme.scf8.util.KscfKeywordUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class XsodMerchandiseListRMO
extends RmiAbstractRMO {
    public static final String METHOD_merchandiseList = "merchandiseList";
    Wbs1ArticleCondition articleCondition;

    public void merchandiseList(RmiRmoArgument rmoArg) throws Exception {
        this.articleCondition = (Wbs1ArticleCondition)rmoArg.getRequest().getData();
        DtsSession dtsSession = Wbs1ServerUtil.getInstance().createSession(rmoArg, this);
        SqlContext sqlContext = dtsSession.getSqlContext();
        ScfSqlServerTask queryServerTask = ScfSqlUtil.createQueryTask(rmoArg, dtsSession);
        queryServerTask.wordManager = rmoArg.getDtsSession((Object)this).getSessionFactory().wordManager;
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        this.setColumnNameList(selectQuery);
        this.parseCondition(dtsSession, selectQuery);
        this.getFromClause(selectQuery);
        this.setOrderByPhrase(selectQuery);
        queryServerTask.query = sqlContext.buildSelectQuery(selectQuery);
        BcLogUtil.debug("query=" + queryServerTask.query);
        queryServerTask.tableColumnNameList = selectQuery.getSelectColumnList();
        queryServerTask.tableContext.title = XsodWords.getInstance().\u5546\u54c1\u30ea\u30b9\u30c8.toString();
        queryServerTask.tableContext.setConditionList(selectQuery.getConditionList());
        ScfSqlUtil.generalListNew(queryServerTask, (Object)this);
    }

    public Wbs1ArticleCondition getEventCondition() {
        return this.articleCondition;
    }

    public void setEventCondition(Wbs1ArticleCondition articleCondition) {
        this.articleCondition = articleCondition;
    }

    public void parseCondition(DtsSession dtsSession, SqlSelectQuery selectQuery) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        if (!BcStringUtil.isEmpty(this.articleCondition.keyword)) {
            String keywords = KscfKeywordUtil.conv(this.articleCondition.keyword);
            List<String> columnNameList = BcCollectionUtil.asList(String.valueOf(this.articleCondition.tableName) + ".text_1", String.valueOf(this.articleCondition.tableName) + ".text_2");
            String tmpStr = sqlContext.createKeywordClause(columnNameList, keywords);
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(tmpStr);
            selectQuery.addWhereElement(whereElement);
        }
    }

    public void setColumnNameList(SqlSelectQuery selectQuery) throws Exception {
        ArrayList<String> tmpSelectColumnNameList = new ArrayList<String>();
        tmpSelectColumnNameList.addAll(selectQuery.getSelectColumnList());
        selectQuery.getSelectColumnList().clear();
        selectQuery.getSelectColumnList().add("xsod_merchandise.id");
        selectQuery.getSelectColumnList().add("xsod_merchandise.code");
        selectQuery.getSelectColumnList().add("xsod_merchandise.name_01");
        selectQuery.getSelectColumnList().add("xsod_merchandise.name_02");
        selectQuery.getSelectColumnList().add("xsod_merchandise.unit_amount");
        selectQuery.getSelectColumnList().add("xsod_merchandise.image_file_name");
        selectQuery.getSelectColumnList().add("xsod_merchandise.description_01");
        selectQuery.getSelectColumnList().add("xsod_merchandise.description_02");
        selectQuery.getSelectColumnList().addAll(tmpSelectColumnNameList);
    }

    public void getFromClause(SqlSelectQuery selectQuery) throws Exception {
        String tmpFromClause = selectQuery.getFromClause();
        StringBuilder sb = new StringBuilder();
        sb.append("xsod_merchandise");
        selectQuery.setFromClause(sb.toString());
    }

    public void setOrderByPhrase(SqlSelectQuery selectQuery) {
        selectQuery.getOrderByList().add("xsod_merchandise.id");
    }
}

