/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.server;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcLockManger;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.dao.XfilUriEntityDAO;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.parser.XfilFileParser;
import jp.co.extreme.module.xfil.parser.XfilMsExcelParser;
import jp.co.extreme.module.xfil.parser.XfilMsPowerPointParser;
import jp.co.extreme.module.xfil.parser.XfilMsPublisherParser;
import jp.co.extreme.module.xfil.parser.XfilMsVisioParser;
import jp.co.extreme.module.xfil.parser.XfilMsWordParser;
import jp.co.extreme.module.xfil.server.SnapshotTask;
import jp.co.extreme.module.xfil.server.XfilVideoParser;
import jp.co.extreme.poi.PoiConstants;
import jp.co.extreme.task.TskAbstractCallable2;

public class XfilVideoCaptureTask
extends TskAbstractCallable2 {
    public Future future;
    DtsSession dtsSessionMain;
    DtsSession dtsSessionWk;
    XfilUriEntityDAO uriEntityDao;
    boolean initThumbnail = true;
    XfilVideoParser videoParser = new XfilVideoParser();
    XfilMsExcelParser msExcelParser = new XfilMsExcelParser();
    XfilMsWordParser msWordParser = new XfilMsWordParser();
    XfilMsPowerPointParser msPowerPointParser = new XfilMsPowerPointParser();
    XfilMsPublisherParser msPublisherParser = new XfilMsPublisherParser();
    XfilMsVisioParser msVisioParser = new XfilMsVisioParser();
    int waitCnt = 0;

    public Object taskProcess() throws Exception {
        long exceptEntityId = -1L;
        while (true) {
            XfilUriEntity uriEntity;
            if ((uriEntity = (XfilUriEntity)this.uriEntityDao.getForThumbnail(this.dtsSessionWk, -1L, exceptEntityId)) == null) {
                ++this.waitCnt;
                if (this.waitCnt > 1) break;
                Thread.sleep(3000L);
                exceptEntityId = -1L;
                continue;
            }
            this.waitCnt = 0;
            XfilUriEntity preEntity = EtcLockManger.getInstance().check(uriEntity, uriEntity.id);
            if (preEntity == null) {
                block8: {
                    try {
                        try {
                            this.proc1(uriEntity);
                        }
                        catch (Exception ex) {
                            this.getLogger().error(ex);
                            EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                        throw throwable;
                    }
                    EtcLockManger.getInstance().remove(uriEntity.getClass(), uriEntity.id);
                }
                exceptEntityId = -1L;
                continue;
            }
            exceptEntityId = preEntity.id;
        }
        this.future = null;
        return null;
    }

    protected void proc1(XfilUriEntity uriEntity) throws Exception {
        XfilFileParser fileParser = this.getFileParser(uriEntity.extention);
        if (fileParser != null) {
            File file = XfilUtil.toFile(uriEntity);
            if (file.exists()) {
                fileParser.setLogger(this.getLogger());
                fileParser.setResource(this.dtsSessionMain, this.dtsSessionWk, this.uriEntityDao);
                fileParser.parse(uriEntity, file);
            } else {
                uriEntity.missingTimestamp = BcTimeUtil.createCalendar();
                this.uriEntityDao.putEntity(this.dtsSessionWk, uriEntity);
                this.dtsSessionWk.commit();
            }
        } else {
            this.getLogger().warning("No FileParser.");
        }
    }

    protected void initThumbnail() throws Exception {
        long entityId = -1L;
        long crawlId = -1L;
        List uriEntityList = this.uriEntityDao.getList(this.dtsSessionWk, XfilUriEntityDAO.Mode.id, entityId, -1L, crawlId, null, null, null, null, -1, false, new long[0]);
        this.getLogger().info("\u30d5\u30a1\u30a4\u30eb\u6570=" + uriEntityList.size());
        int i = 0;
        while (i < uriEntityList.size()) {
            XfilUriEntity uriEntity = (XfilUriEntity)uriEntityList.get(i);
            uriEntity.thumbnailTimestamp = null;
            uriEntity.error2 = null;
            ++i;
        }
        this.getLogger().info("\u6c38\u7d9a\u5316\u4e2d...");
        this.uriEntityDao.putEntityCollection(this.dtsSessionWk, uriEntityList);
        this.dtsSessionWk.commit();
    }

    public void snapshotOrig(XfilUriEntity uriEntity) throws Exception {
        File imputFile = XfilUtil.toFile(uriEntity);
        SnapshotTask snapshotTask = new SnapshotTask();
        URI uri = XfilUtil.toUri(uriEntity);
        File dir = XfilUtil.getThumbnailDir(uriEntity.id);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future future = executorService.submit(snapshotTask);
        Object res = future.get();
        uriEntity.thumbnailTimestamp = BcTimeUtil.createCalendar();
    }

    protected XfilFileParser getFileParser(String extention) throws Exception {
        XfilFileParser fileParser = null;
        if (XfilUtil.isTargetExtention(XfilConstants.getMovieExtentionList(), extention)) {
            fileParser = this.videoParser;
        } else if (BcStringUtil.equalsIgnoreCase(PoiConstants.Extention.xls.name(), extention) || BcStringUtil.equalsIgnoreCase(PoiConstants.Extention.xlsx.name(), extention)) {
            fileParser = this.msExcelParser;
        } else if (BcStringUtil.equalsIgnoreCase(PoiConstants.Extention.doc.name(), extention) || BcStringUtil.equalsIgnoreCase(PoiConstants.Extention.docx.name(), extention)) {
            fileParser = this.msWordParser;
        } else if (BcStringUtil.equalsIgnoreCase(PoiConstants.Extention.ppt.name(), extention) || BcStringUtil.equalsIgnoreCase(PoiConstants.Extention.pptx.name(), extention)) {
            fileParser = this.msPowerPointParser;
        } else if (BcStringUtil.equalsIgnoreCase(PoiConstants.Extention.pub.name(), extention)) {
            fileParser = this.msPublisherParser;
        } else {
            BcStringUtil.equalsIgnoreCase(PoiConstants.Extention.vsd.name(), extention);
        }
        return fileParser;
    }
}

