/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.parser;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import jp.co.extreme.awt.AwtImageUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.doc.poi.DcfExcel2Book;
import jp.co.extreme.doc.renderer.DcfShapeRenderer;
import jp.co.extreme.doc.util.DcfBookUtil;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.module.xfil.parser.XfilFileParser;
import jp.co.extreme.poi.PoiWorkbookUtil;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XfilMsExcelParser
extends XfilFileParser {
    DcfExcel2Book excel2Book = new DcfExcel2Book();
    DcfShapeRenderer shapeRenderer = new DcfShapeRenderer();

    @Override
    public void parse(XfilUriEntity uriEntity, File file) throws Exception {
        if (file.exists()) {
            this.parse_L2(uriEntity, file);
            uriEntity.thumbnailTimestamp = BcTimeUtil.createCalendar();
        } else {
            BcLogUtil.warning("Not found file:" + file.getPath());
            uriEntity.missingTimestamp = BcTimeUtil.createCalendar();
        }
    }

    protected void parse_L2(XfilUriEntity uriEntity, File file) throws Exception {
        Workbook workbook = PoiWorkbookUtil.createWorkbook(file);
        XSSFWorkbook xssWorkbook = (XSSFWorkbook)workbook;
        XSSFExcelExtractor xssfExcelExtractor = new XSSFExcelExtractor(xssWorkbook);
        uriEntity.text02 = xssfExcelExtractor.getText();
        xssfExcelExtractor.close();
        DcfBook dcfBook = new DcfBook();
        this.excel2Book.convToDcfBook(workbook, dcfBook);
        BcLogUtil.debug("#2:dcfBook.getPageCount()=" + dcfBook.getPageCount());
        ArrayList<String> fileNameList = new ArrayList<String>();
        int i = 0;
        while (i < dcfBook.getPageCount()) {
            DcfPage dcfPage = dcfBook.getPage(i);
            BcLogUtil.debug("#3-1");
            BufferedImage bufferedImage = DcfBookUtil.createBufferedImage(dcfPage.getPageFormat(), XfilConstants.thumbnailResolution.width);
            int dpi = DcfBookUtil.calcDpi(dcfPage.getMediaSize(), dcfPage.getPageFormat(), XfilConstants.thumbnailResolution.width);
            Object[] values = DcfBookUtil.createAffineTransform(dcfPage.getMediaSize(), dcfPage.getPageFormat(), dpi);
            AffineTransform affineTransform = (AffineTransform)values[1];
            bufferedImage = DcfBookUtil.createImage(dcfPage, bufferedImage, affineTransform, this.shapeRenderer);
            BcLogUtil.debug("#3-2");
            long timeMillis = -1L;
            String extention = AwtImageUtil.ImageFileType.JPG.extentions[0];
            String fileName = XfilUtil.createFileName(timeMillis, bufferedImage.getWidth(), bufferedImage.getHeight(), uriEntity.id, extention, file.getName());
            File dir = XfilUtil.getThumbnailDir(uriEntity.id);
            File destFile = new File(dir, fileName);
            BcLogUtil.debug("destFile=" + destFile.getPath());
            BcFileUtil.deleteIfExists(destFile);
            float compressionQuality = 0.75f;
            AwtImageUtil.outputImageJpg(bufferedImage, destFile, compressionQuality);
            fileNameList.add(fileName);
            ++i;
        }
        uriEntity.thumbnailFiles = BcCsvUtil.toCsv(fileNameList);
        BcLogUtil.debug("#3");
    }
}

