/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.swg;

import com.fasterxml.jackson.core.type.TypeReference;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcSortUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.etc.model.EtcWord;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.xdts.common.XdtsWordXmlCreator;
import jp.co.extreme.module.xdts.common.XdtsWordXmlParser;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.model.XysWordContext;
import jp.co.extreme.module.xdts.stub.XdtsWordStub;
import jp.co.extreme.module.xdts.swg.XdtsLogicalNameExportPanel;
import jp.co.extreme.module.xdts.swg.XdtsLogicalNameTablePanel;
import jp.co.extreme.swing.SwgDecoratePanel;
import jp.co.extreme.swing.SwgFrame;
import jp.co.extreme.swing.SwgOptionPane;
import jp.co.extreme.swing.SwgUtil;
import org.xml.sax.helpers.DefaultHandler;

public class XdtsLogicalNamePanel
extends SwgDecoratePanel {
    XdtsLogicalNameTablePanel logicalNameTablePanel = new XdtsLogicalNameTablePanel();
    XdtsProfile profile;
    String title;
    Window window;

    public XdtsLogicalNamePanel() throws Exception {
        this.setBorderSize(32, 48, 0, 0);
        this.setPreviousButton(XdtsWords.getInstance().exportLogicalNameXml);
        this.setNextButton(XdtsWords.getInstance().importLogicalNameXml);
        this.setOkButton(BcWords.getInstance().save);
        this.setCancelButton(BcWords.getInstance().close);
        BorderLayout borderLayout = new BorderLayout();
        this.centerPanel.setLayout(borderLayout);
        this.centerPanel.add((Component)this.logicalNameTablePanel, "Center");
    }

    public void setProfile(XdtsProfile profile) throws Exception {
        this.profile = profile;
        this.title = String.valueOf(XdtsWords.getInstance().logicalNameTable) + ":" + profile.name;
        List<EtcWord> wordList = XdtsWordStub.getInstance().getWordList(profile.getEntityId());
        this.logicalNameTablePanel.setData(wordList);
    }

    protected BcResult toWordMap(Map<String, EtcWord> wordMap) throws Exception {
        BcResult result = new BcResult();
        int i = 0;
        while (i < this.logicalNameTablePanel.tableModel.getRowCount()) {
            EtcWord word = new EtcWord();
            word.dataSourceId = this.profile.getEntityId();
            word.code = (String)this.logicalNameTablePanel.tableModel.getValueAt(i, 0);
            word.lang = (String)this.logicalNameTablePanel.tableModel.getValueAt(i, 1);
            word.value = (String)this.logicalNameTablePanel.tableModel.getValueAt(i, 2);
            word.note = (String)this.logicalNameTablePanel.tableModel.getValueAt(i, 3);
            if (BcStringUtil.isEmpty(word.code) || BcStringUtil.isEmpty(word.lang) || BcStringUtil.isEmpty(word.value)) {
                result.addError(String.valueOf(BcWords.getInstance().logicalName) + "\u3001\u8a00\u8a9e\u3001\u8a9e\u53e5\u306e\u4f55\u308c\u304b\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u884c=" + (i + 1));
            } else {
                String key = String.valueOf(word.code) + "-" + word.lang;
                if (wordMap.containsKey(key)) {
                    result.addError(String.valueOf(BcWords.getInstance().logicalName) + "\u3001\u8a00\u8a9e\u304c\u91cd\u8907\u3057\u3066\u307e\u3059\u3002\u884c=" + (i + 1));
                } else {
                    wordMap.put(key, word);
                }
            }
            ++i;
        }
        return result;
    }

    protected BcResult varidate(Map<String, EtcWord> wordMap) throws Exception {
        BcResult result = this.toWordMap(wordMap);
        if (result.hasError()) {
            Component msgComponent = SwgUtil.createMessageComponent(null, result.getErrorList());
            SwgOptionPane.showMessageDialog(this, msgComponent, BcWords.getInstance().warning, 2);
        }
        return result;
    }

    protected List<EtcWord> wordCollectionToList(Collection<EtcWord> wordCollection) throws Exception {
        List wordList2 = BcSortUtil.sort(wordCollection, true, "code", "lang");
        return wordList2;
    }

    @Override
    protected void previousButtonAction() throws Exception {
        HashMap<String, EtcWord> wordMap = new HashMap<String, EtcWord>();
        BcResult result = this.varidate(wordMap);
        if (result.hasError()) {
            return;
        }
        List<EtcWord> wordList2 = this.wordCollectionToList(wordMap.values());
        XdtsLogicalNameExportPanel exportPanel = new XdtsLogicalNameExportPanel(1);
        if (!exportPanel.showAsDialog(this)) {
            return;
        }
        File destFile = new File(exportPanel.filePathField.getText());
        XdtsWordXmlCreator wordXmlCreator = new XdtsWordXmlCreator();
        wordXmlCreator.createXml(wordList2, destFile);
    }

    @Override
    protected void nextButtonAction() throws Exception {
        HashMap<String, EtcWord> wordMap = new HashMap<String, EtcWord>();
        BcResult result = this.varidate(wordMap);
        if (result.hasError()) {
            return;
        }
        XdtsLogicalNameExportPanel exportPanel = new XdtsLogicalNameExportPanel(2);
        if (!exportPanel.showAsDialog(this)) {
            return;
        }
        File inputFile = new File(exportPanel.filePathField.getText());
        String jsonStr = BcFileUtil.readAsString(inputFile, BcConstants.charset);
        List wordContextList = (List)JacksonUtil.getObjectMapper().readValue(jsonStr, (TypeReference)new TypeReference<List<XysWordContext>>(){});
        ArrayList<EtcWord> etcWordList = new ArrayList<EtcWord>();
        ArrayList<MmdField> mmdFieldList = new ArrayList<MmdField>();
        BcLogUtil.debug("wordContextList.size()=" + wordContextList.size());
        int i = 0;
        while (i < wordContextList.size()) {
            XysWordContext wordContext = (XysWordContext)wordContextList.get(i);
            mmdFieldList.add(wordContext.field);
            for (Map.Entry<String, String> mapEntry : wordContext.map.entrySet()) {
                EtcWord etcWord = new EtcWord();
                etcWord.code = wordContext.wordCode;
                etcWord.lang = mapEntry.getKey();
                etcWord.value = mapEntry.getValue();
                etcWordList.add(etcWord);
            }
            ++i;
        }
        XdtsWordStub.getInstance().putWordCollection(this.profile.getEntityId(), etcWordList, mmdFieldList);
    }

    protected void oldXml(Map<String, EtcWord> wordMap) throws Exception {
        XdtsLogicalNameExportPanel exportPanel = new XdtsLogicalNameExportPanel(2);
        if (!exportPanel.showAsDialog(this)) {
            return;
        }
        File inputFile = new File(exportPanel.filePathField.getText());
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XdtsWordXmlParser wordXmlParser = new XdtsWordXmlParser();
        saxParser.parse(inputFile, (DefaultHandler)wordXmlParser);
        BcLogUtil.debug("wordXmlParser.wordList.size()=" + wordXmlParser.wordList.size());
        int i = 0;
        while (i < wordXmlParser.wordList.size()) {
            EtcWord word = wordXmlParser.wordList.get(i);
            String key = String.valueOf(word.code) + "-" + word.lang;
            wordMap.put(key, word);
            ++i;
        }
        List<EtcWord> wordList2 = this.wordCollectionToList(wordMap.values());
        this.logicalNameTablePanel.setData(wordList2);
    }

    @Override
    protected void okButtonAction() throws Exception {
        HashMap<String, EtcWord> wordMap = new HashMap<String, EtcWord>();
        BcResult result = this.varidate(wordMap);
        if (result.hasError()) {
            return;
        }
        List<EtcWord> wordList2 = this.wordCollectionToList(wordMap.values());
    }

    @Override
    public void cancelButtonAction() throws Exception {
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
        this.window = null;
    }

    protected void showAsFrame2() throws Exception {
        SwgFrame frame = new SwgFrame();
        frame.getContentPane().add((Component)this, "Center");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent ev) {
            }

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    XdtsLogicalNamePanel.this.close();
                }
                catch (Exception ex) {
                    XdtsLogicalNamePanel.this.handleException(ex);
                }
            }
        });
        frame.setTitle(this.title);
        frame.setIconImage(AwtImageHelper.getImage("dictionary_64x64.png"));
        this.window = frame;
        SwgUtil.setCenter(this.window, 960.0, 680.0);
        this.window.setVisible(true);
    }

    public void showAsFrame(XdtsProfile profile) throws Exception {
        if (this.window != null) {
            this.window.toFront();
            return;
        }
        this.setProfile(profile);
        this.showAsFrame2();
    }
}

