/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.server;

import java.io.File;
import java.io.StringReader;
import java.sql.Driver;
import java.util.List;
import java.util.Properties;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.datasource.DtsConnectionManager;
import jp.co.extreme.datasource.DtsConnectionManagerImpl;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.etc.model.EtcWord;
import jp.co.extreme.module.xdts.dao.XdtsProfileDAO;
import jp.co.extreme.module.xdts.dao.XdtsWordDAO;
import jp.co.extreme.module.xdts.model.XdtsProfile;
import jp.co.extreme.module.xdts.server.XdtsTempProc;
import jp.co.extreme.module.xsys.common.XsysConstants;
import jp.co.extreme.scf.datasource.ScfDatasourceConfigParser;
import jp.co.extreme.sql.SqlConstants;
import jp.co.extreme.sql.SqlUtil;

public class XdtsSessionFactoryManager
extends BcLoggableObject {
    private static XdtsSessionFactoryManager instance = new XdtsSessionFactoryManager();

    private XdtsSessionFactoryManager() {
    }

    public static XdtsSessionFactoryManager getInstance() {
        return instance;
    }

    public DtsSessionFactory createSessionFactory(XdtsProfile profile) throws Exception {
        Driver driver = null;
        if (BcStringUtil.isEmpty(profile.driverFilePath)) {
            driver = SqlUtil.createDriver(profile.driver);
        } else {
            String filePath = AfbApplication.getInstance().toReal(profile.driverFilePath);
            File file = new File(filePath);
            BcFileUtil.notEexistsException(file);
            driver = SqlUtil.createDriver(file, profile.driver);
        }
        String jdbcUrl = AfbApplication.getInstance().toReal(profile.url);
        Properties dtsProps = new Properties();
        if (!BcStringUtil.isEmpty(profile.parameters)) {
            StringReader reader = new StringReader(profile.parameters);
            dtsProps.load(reader);
        }
        if (BcStringUtil.isEmpty(profile.user)) {
            dtsProps.remove(SqlConstants.DataSourceProperty.user.name());
        } else {
            dtsProps.setProperty(SqlConstants.DataSourceProperty.user.name(), profile.user);
        }
        if (BcStringUtil.isEmpty(profile.password)) {
            dtsProps.remove(SqlConstants.DataSourceProperty.password.name());
        } else {
            dtsProps.setProperty(SqlConstants.DataSourceProperty.password.name(), profile.password);
        }
        DtsConnectionManagerImpl connectionManager = new DtsConnectionManagerImpl();
        ((DtsConnectionManager)connectionManager).setup(driver, jdbcUrl, dtsProps);
        String datasourceName = XsysConstants.createDatasourceName(profile.getEntityId());
        DtsSessionFactory dtsSessionFactory = new DtsSessionFactory(datasourceName, connectionManager);
        ScfDatasourceConfigParser.setupLogger(dtsSessionFactory, AfbApplication.getInstance().getLogDir());
        return dtsSessionFactory;
    }

    public DtsSessionFactory getSessionFactory(DtsSession dtsSession, long dataSourceId, boolean doCreate) throws Exception {
        String datasourceName = XsysConstants.createDatasourceName(dataSourceId);
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory(datasourceName);
        if (dtsSessionFactory != null) {
            return dtsSessionFactory;
        }
        if (!doCreate) {
            return null;
        }
        XdtsProfile profile = (XdtsProfile)XdtsProfileDAO.getInstance().getById(dtsSession, dataSourceId, true);
        dtsSessionFactory = this.createSessionFactory(profile);
        if (profile.getEntityId() > 0L) {
            List<EtcWord> etcWordList = XdtsWordDAO.getInstance().getListByProfileId(dtsSession, profile.getEntityId());
            DtsWordManagerImpl wordManager = (DtsWordManagerImpl)dtsSessionFactory.wordManager;
            XdtsTempProc tempProc = new XdtsTempProc();
            tempProc.setWords(etcWordList, wordManager.wordMap, dtsSessionFactory.mmdFieldMap);
        }
        ScfDatasourceConfigParser.setupLogger(dtsSessionFactory, AfbApplication.getInstance().getLogDir());
        DtsSessionFactoryManegaer.getInstance().addSessionFactory(dtsSessionFactory);
        return dtsSessionFactory;
    }

    public DtsSessionFactory getSessionFactory(DtsSession dtsSession, long dataSourceId) throws Exception {
        return this.getSessionFactory(dtsSession, dataSourceId, false);
    }

    public void disconnect(long dataSourceId) throws Exception {
        String msg;
        String datasourceName = XsysConstants.createDatasourceName(dataSourceId);
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory(datasourceName);
        if (dtsSessionFactory != null) {
            msg = String.format("Disconnecting... datasourceName=%s", dtsSessionFactory.getName());
            this.getLogger().info(msg);
            dtsSessionFactory.close();
            DtsSessionFactory dtsSessionFactory2 = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMap().remove(datasourceName);
            if (dtsSessionFactory2 == null) {
                msg = String.format("Does not exist in map. datasourceName=%s", dtsSessionFactory.getName());
                throw new Exception(msg);
            }
        } else {
            throw new Exception("SessionFactory is exits. dataSourceId=" + dataSourceId);
        }
        msg = String.format("Disconnected. datasourceName=%s", dtsSessionFactory.getName());
        this.getLogger().info(msg);
    }
}

