/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcPagination;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.common.HtmlImageAttribute;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwConstants;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.common.Wbs1Words;
import jp.co.extreme.module.wbs1.dao.Wbs1ShopDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Shop;
import jp.co.extreme.module.wbs1.model.WbsJudgementCondition;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.module.wbs1.model.WbsUrlParam;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1LinkUtil;
import jp.co.extreme.module.wbs1.wcb.Wbs1RecruitmentListWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1ShopDataHelper;
import jp.co.extreme.module.wbs1.wcb.Wbs1ShopWCB;
import jp.co.extreme.module.xdts.web.XdsDataViewUtil;
import jp.co.extreme.module.xsys.validation.XsysValidationResult;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.HtmlDlCreator;
import jp.co.extreme.module.xweb.common.HtmlUtil2;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebJudgementUtil;
import jp.co.extreme.module.xweb.common.XwebPaginationBuilder;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;
import jp.co.extreme.web.server.WbsUrlParameterMap;

public class Wbs1ShopListWCB
extends Wbs1AbstractWCB {
    @Override
    protected String createHeadStyle(WbsArgument wcbArg) throws Exception {
        StringBuilder sb = new StringBuilder();
        BcStringUtil.append(sb, super.createHeadStyle(wcbArg));
        sb.append("\n\n.mdl-layout__content {\nposition: relative;\nbackground-size:cover;\nbackground-image: url(images/main_bg.jpg);\n}");
        return sb.toString();
    }

    public void form(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            StringBuilder content = this.form_L2(wcbArg, dtsSessionSite);
            StringBuilder sb = this.getBaseHtml(wcbArg);
            String headTitle = "\u30ad\u30e3\u30d0\u30af\u30e9\u691c\u7d22";
            String metaDescription = "\u30ad\u30e3\u30d0\u30af\u30e9\u3001\u30ac\u30fc\u30eb\u30ba\u30d0\u30fc\u3001\u30af\u30e9\u30d6\u3001\u30b9\u30ca\u30c3\u30af\u3092\u3054\u7d39\u4ecb\u3002";
            WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
            String area = requestParameter.getAsString("area");
            if (!BcStringUtil.isEmpty(area)) {
                headTitle = String.valueOf(headTitle) + " : " + area;
                metaDescription = String.valueOf(area) + "\u306e" + metaDescription;
            }
            sb = this.replace(wcbArg, headTitle, metaDescription, sb);
            sb = BcStringUtil.replace((CharSequence)sb, WbxConstants.PlaceHolder.content.value, content);
            WbfwUtil.outputHtml(wcbArg, sb.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected StringBuilder form_L2(WbsArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        WbsUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
        WbsUrlParam urlParam = null;
        WbsJudgementCondition judgementCondition = null;
        WbsTempCondition tempCondition = null;
        if (tokenContext.validationResult == null) {
            tokenContext.validationResult = new XsysValidationResult();
            urlParam = new WbsUrlParam();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, urlParam);
            XwebUtil.putToMap(tokenContext.map, urlParam);
            judgementCondition = new WbsJudgementCondition();
            XwebUtil.putToMap(tokenContext.map, judgementCondition);
            tempCondition = new WbsTempCondition();
            WbxParameterUtil.getInstance().setFieldValue(decryptMap, tempCondition);
            XwebUtil.putToMap(tokenContext.map, tempCondition);
        } else {
            urlParam = (WbsUrlParam)XwebUtil.getMapValue(tokenContext.map, WbsUrlParam.class);
            judgementCondition = (WbsJudgementCondition)XwebUtil.getMapValue(tokenContext.map, WbsJudgementCondition.class);
            tempCondition = (WbsTempCondition)XwebUtil.getMapValue(tokenContext.map, WbsTempCondition.class);
        }
        EtcPagination pagination = XwebUtil.cretaePagination(wcbArg);
        if (pagination.getPageNumReq() <= 0) {
            WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, tempCondition);
        }
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, judgementCondition);
        this.getLogger().debug("tempCondition.area=" + tempCondition.area);
        StringBuilder sb = new StringBuilder();
        int contentColumn = 10;
        sb.append((CharSequence)MdlCreator.getInstance().div_grid_cell_start(contentColumn));
        String title = Wbs1Words.getInstance().shopList;
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            title = String.valueOf(title) + ":" + urlParam.mode;
        }
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        sb.append(this.getHtmlBuilder().h(3, title, "headline1"));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append((CharSequence)this.createConditionForm(wcbArg, tokenContext, dtsSessionSite, Method.form.path, urlParam, judgementCondition, tempCondition));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append((CharSequence)this.createDetailList(wcbArg, tokenContext, pagination, dtsSessionSite, urlParam, judgementCondition, tempCondition));
        sb.append(this.getHtmlBuilder().div_end());
        MdlCreator mdlCreator = MdlCreator.getInstance();
        MdlCreator.getInstance();
        sb.append((CharSequence)mdlCreator.div_grid_cell_start(12 - contentColumn));
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1RecruitmentListWCB.Method.form);
        StringBuilder sb2 = Wbs1LinkUtil.getInstance().createLink(wcbArg, dtsSessionSite);
        sb.append((CharSequence)sb2);
        sb.append(this.getHtmlBuilder().div_end());
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        return sb;
    }

    protected StringBuilder createConditionForm(WbsArgument wcbArg, WbxTokenContext tokenContext, DtsSession dtsSessionSite, String url, WbsUrlParam urlParam, WbsJudgementCondition judgementCondition, WbsTempCondition tempCondition) throws Exception {
        StringBuilder sb = this.createConditionForm_L2(wcbArg, tokenContext, dtsSessionSite, urlParam, judgementCondition, tempCondition);
        String formName = "form1";
        StringBuilder controls = new StringBuilder();
        String onclickAction = WbfJslUtil.submit2(formName, url);
        String searchButton = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().search, onclickAction);
        controls.append(searchButton);
        sb.append((CharSequence)this.getHtmlBuilder().div(controls.toString(), HtmlConstants.HtmlAlign.center, -1));
        sb.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        sb = HtmlUtil2.form(formName, sb.toString());
        return sb;
    }

    protected StringBuilder createConditionForm_L2(WbsArgument wcbArg, WbxTokenContext tokenContext, DtsSession dtsSessionSite, WbsUrlParam urlParam, WbsJudgementCondition judgementCondition, WbsTempCondition tempCondition) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (Wbs1Constants.OperationMode.administrator.name().equals(urlParam.mode)) {
            sb.append(XwebJudgementUtil.createJudgementCondition(this.getHtmlBuilder(), judgementCondition.judgementStatusId));
        } else {
            if (tempCondition != null) {
                if (BcStringUtil.isEmpty(tempCondition.area) && tokenContext.cnt <= 1L) {
                    WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
                    String area = requestParameter.getAsString("area");
                    tempCondition.area = !BcStringUtil.isEmpty(area) ? area : "\u6e0b\u8c37";
                }
                List<String> areaList = Wbs1ShopDataHelper.getInstance().getAreaList(dtsSessionSite);
                sb.append(XdsDataViewUtil.createCondition(this.getHtmlBuilder(), WbsTempCondition.FieldName.area.fieldName, areaList, null, tempCondition.area, "\u3010\u5730\u57df\u3011"));
                String[] strArray = new String[]{"\u30ad\u30e3\u30d0\u30af\u30e9", "\u30ac\u30fc\u30eb\u30ba\u30d0\u30fc", "\u30af\u30e9\u30d6", "\u30b9\u30ca\u30c3\u30af", "\u671d\u30ad\u30e3\u30d0\u30fb\u663c\u30ad\u30e3\u30d0", "\u30d0\u30fc", "\u30b3\u30f3\u30bb\u30d7\u30c8\u30ab\u30d5\u30a7"};
                List<String> businessTypeList = Arrays.asList(strArray);
                sb.append(XdsDataViewUtil.createCondition(this.getHtmlBuilder(), WbsTempCondition.FieldName.businessType.fieldName, businessTypeList, null, tempCondition.businessType, "\u3010" + Wbs1Words.getInstance().\u696d\u614b + "\u3011"));
            }
            if (urlParam != null) {
                String[] strArray = new String[]{"\u30d5\u30ed\u30a2\u30ec\u30c7\u30a3", "\u30ab\u30a6\u30f3\u30bf\u30fc\u30ec\u30c7\u30a3", "\u30c1\u30fc\u30de\u30de", "\u30a6\u30a8\u30a4\u30c8\u30ec\u30b9", "\u30d0\u30fc\u30c6\u30f3\u30c0\u30fc", "\u30db\u30fc\u30eb\u30b9\u30bf\u30c3\u30d5"};
                List<String> occupationList = Arrays.asList(strArray);
                sb.append(XdsDataViewUtil.createCondition(this.getHtmlBuilder(), WbsTempCondition.FieldName.occupation.fieldName, occupationList, null, tempCondition.occupation, "\u3010" + Wbs1Words.getInstance().\u8077\u7a2e + "\u3011"));
            }
        }
        return sb;
    }

    protected StringBuilder createDetailList(WbsArgument wcbArg, WbxTokenContext tokenContext, EtcPagination pagination, DtsSession dtsSessionSite, WbsUrlParam urlParam, WbsJudgementCondition judgementCondition, WbsTempCondition tempCondition) throws Exception {
        List shopList1 = Wbs1ShopDAO.getInstance().getList(dtsSessionSite, Wbs1ShopDAO.Mode.priority, -1L, tempCondition.area, tempCondition.businessType, judgementCondition);
        XwebUtil.putToMap(tokenContext.map, shopList1);
        pagination.setDataCount(shopList1.size());
        List shopList2 = pagination.newList(shopList1);
        StringBuilder sb = new StringBuilder();
        InnerPaginationBuilder paginationBuilder = new InnerPaginationBuilder();
        paginationBuilder.tokenContext = tokenContext;
        sb.append(paginationBuilder.create(wcbArg, pagination));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        int i = 0;
        while (i < shopList2.size()) {
            Wbs1Shop shop = (Wbs1Shop)shopList2.get(i);
            sb.append((CharSequence)this.createDetailCell(wcbArg, urlParam, shop));
            sb.append("\n\n");
            ++i;
        }
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append(paginationBuilder.create(wcbArg, pagination));
        return sb;
    }

    protected StringBuilder createDetailCell(WbsArgument wcbArg, WbsUrlParam tempCondition, Wbs1Shop shop) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, ExtwCssUtil.ExtwClass.extw_padding_06rem.className));
        String param1 = WbfwUtil.createParameter("shopId", (Object)Long.toString(shop.id));
        String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1ShopWCB.Method.view)) + WbfwUtil.createUrlQuery(param1);
        String onclickAction = WbfJslUtil.locationHref(href);
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(ExtwCssUtil.ExtwClass.extw_button_box.className, ExtwCssUtil.ExtwClass.extw_hover_opacity.className);
        String buttonStart = this.getHtmlBuilder().button_start(globalAttribute, HtmlConstants.HtmlButtonType.button, null, null, false, onclickAction).toString();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className, ExtwCssUtil.ExtwClass.extw_row_wrap.className, ExtwCssUtil.ExtwClass.extw_flex_baseline.className));
        sb.append(this.getHtmlBuilder().h(3, shop.name));
        if (!BcStringUtil.isEmpty(shop.nameKana) && !BcStringUtil.equals(shop.name, shop.nameKana)) {
            sb.append(this.getHtmlBuilder().h(6, " \uff08" + shop.nameKana + "\uff09"));
        }
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        ArrayList<String> imageUrlList = new ArrayList<String>();
        if (!BcStringUtil.isEmpty(shop.shopImageUrl)) {
            imageUrlList.add(shop.shopImageUrl);
        }
        if (!BcStringUtil.isEmpty(shop.castImageUrl)) {
            imageUrlList.add(shop.castImageUrl);
        }
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = ExtwCssUtil.ExtwClass.extw_border_radius_10px.className;
        int i = 0;
        while (i < imageUrlList.size()) {
            String imageUrl = (String)imageUrlList.get(i);
            if (i > 0) {
                sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_1rem.className));
            }
            HtmlImageAttribute imageAttribute = new HtmlImageAttribute();
            imageAttribute.src = imageUrl;
            imageAttribute.width = "100%";
            sb.append(this.getHtmlBuilder().div_start());
            sb.append(this.getHtmlBuilder().image(globalAttribute, imageAttribute, null));
            sb.append(this.getHtmlBuilder().div_end());
            ++i;
        }
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(buttonStart);
        sb.append(this.getHtmlBuilder().p(shop.introduction, true));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        WbfwConstants.TerminalType terminalType = XwebUtil.getTerminalType(wcbArg);
        switch (terminalType) {
            default: 
        }
        sb.append(this.getHtmlBuilder().div_start("data"));
        ArrayList<BcPair<String, String>> pairList = new ArrayList<BcPair<String, String>>();
        pairList.add(new BcPair<String, String>("\u30a8\u30ea\u30a2", HtmlUtil.encode(shop.area)));
        pairList.add(new BcPair<String, String>(Wbs1Words.getInstance().\u696d\u614b, HtmlUtil.encode(shop.businessType)));
        pairList.add(new BcPair<String, String>("\u55b6\u696d\u6642\u9593", XwebUtil.toOpeningHours(shop.startTime, shop.endTime)));
        pairList.add(new BcPair<String, String>("\u6700\u5bc4\u308a\u99c5", HtmlUtil.encode(shop.nearestStation)));
        HtmlDlCreator dlCreator = new HtmlDlCreator();
        dlCreator.dlClass = "dl_1";
        dlCreator.dtSameWidth = true;
        dlCreator.dtAfter = ":";
        dlCreator.dtHorizonalAlignment = 4;
        sb.append((CharSequence)dlCreator.create(pairList));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().button_end());
        if (Wbs1Constants.OperationMode.administrator.name().equals(tempCondition.mode)) {
            sb.append(XwebJudgementUtil.createJudgementHtml(this.getHtmlBuilder(), shop, wcbArg, shop.judgementPersonId));
            WbsUrlParam urlParam = new WbsUrlParam();
            urlParam.mode = Wbs1Constants.OperationMode.administrator.name();
            urlParam.param1 = Long.toString(shop.id);
            WbsUrlParameterMap paramMap = WbxParameterUtil.getInstance().createParamMap(urlParam);
            String param2 = WbfwUtil.createEncryptQuery(paramMap);
            href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1ShopWCB.Method.form)) + WbfwUtil.createUrlQuery(param2);
            onclickAction = WbfJslUtil.locationHref(href);
            String button = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().edit, onclickAction);
            sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
            sb.append(button);
            sb.append(this.getHtmlBuilder().lineSep);
        }
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    class InnerPaginationBuilder
    extends XwebPaginationBuilder {
        WbxTokenContext tokenContext;
        String area1;

        InnerPaginationBuilder() {
        }

        @Override
        protected String createHref(WbsArgument wcbArg, int pageNo) throws Exception {
            String param1 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.token.name(), (Object)XwebUtil.createTokenString(this.tokenContext));
            String param2 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.page.name(), (Object)Integer.toString(pageNo));
            String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.form)) + WbfwUtil.createUrlQuery(param1, param2);
            return href;
        }
    }

    public static enum Method implements WbxPath
    {
        form("shop-list");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1ShopListWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

