/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import javax.servlet.http.HttpSession;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.dao.Wbs1AttendanceDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.Wbs1Attendance;
import jp.co.extreme.module.wbs1.model.Wbs1Workspace;
import jp.co.extreme.module.wbs1.server.PersonManager;
import jp.co.extreme.module.wbs1.server.WorkspaceManager;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractDashboardWCB;
import jp.co.extreme.module.xsys.common.XsysWords;
import jp.co.extreme.module.xsys.validation.XsysFieldKeyCreator;
import jp.co.extreme.module.xsys.validation.XsysValidationResult;
import jp.co.extreme.module.xsys.validation.XsysValidator;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.HtmlDlCreator;
import jp.co.extreme.module.xweb.common.WbsAbstractFormData;
import jp.co.extreme.module.xweb.common.WbsFiledHtmlCreator;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxFormBuilder;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebIconManager;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.orm.entity.OrmAbstractEntity;
import jp.co.extreme.web.javascript.WbfJslUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;
import nlc.module.apcm.model.ApcmFieldAnnotation;
import nlc.module.apcm.model.ApcmFieldInput;

public class Wbs1AttendanceFormWCB
extends Wbs1AbstractDashboardWCB {
    @Override
    protected StringBuilder createBodyScript(WbsArgument wcbArg) throws Exception {
        StringBuilder sb = super.createBodyScript(wcbArg);
        sb.append(MdlCreator.getInstance().getDialogScript());
        return sb;
    }

    public void form(WbsArgument wcbArg) throws Exception {
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, true);
        XsysValidationResult validationResult = XwebUtil.getValidationResult(wcbArg);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        AttendanceInput attendanceInput = null;
        if (validationResult == null) {
            String tmpStr = requestParameter.getAsString(WbxConstants.QueryParam.attendanceId.name());
            long attendanceId = BcNumberUtil.parseLong(tmpStr, -1);
            Wbs1Attendance attendance = null;
            if (attendanceId > 0L) {
                Throwable throwable = null;
                Object var11_12 = null;
                try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
                    attendance = Wbs1AttendanceDAO.getInstance().getById(dtsSession, attendanceId);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (attendance == null) {
                    throw new Exception("attendanceId=" + attendanceId);
                }
            } else {
                attendance = new Wbs1Attendance();
                tmpStr = requestParameter.getAsString(WbxConstants.QueryParam.personId.name());
                attendance.personId = BcNumberUtil.parseLong(tmpStr, -1);
                tmpStr = requestParameter.getAsString(WbxConstants.QueryParam.workspaceId.name());
                attendance.workspaceId = BcNumberUtil.parseLong(tmpStr, -1);
                tmpStr = requestParameter.getAsString(WbxConstants.QueryParam.date.name());
                attendance.endDate = attendance.startDate = BcNumberUtil.parseInteger(tmpStr, -1);
                tmpStr = wcbArg.getSiteContext().propertyMap.get(WbxConstants.SitePropertyKey.attendanceStartTime.key);
                attendance.startTime = BcNumberUtil.parseShort(tmpStr, 0);
                tmpStr = wcbArg.getSiteContext().propertyMap.get(WbxConstants.SitePropertyKey.attendanceEndTime.key);
                attendance.endTime = BcNumberUtil.parseShort(tmpStr, 0);
            }
            attendanceInput = new AttendanceInput();
            attendanceInput.id = attendance.id;
            attendanceInput.personId = attendance.personId;
            attendanceInput.workspaceId = attendance.workspaceId;
            attendanceInput.date = attendance.startDate;
            attendanceInput.startTime = Short.toString(attendance.startTime);
            attendanceInput.endTime = Short.toString(attendance.endTime);
            attendanceInput.requirementId = attendance.requirementId;
            attendanceInput.note1 = attendance.note1;
            attendanceInput.note2 = attendance.note2;
        } else {
            attendanceInput = XwebUtil.getAttribute1(httpSession, AttendanceInput.class);
        }
        InnerFiledHtmlCreator filedHtmlCreator = new InnerFiledHtmlCreator(this.getHtmlBuilder());
        filedHtmlCreator.isEditable = true;
        if (attendanceInput.id > 0L && attendanceInput.date < BcTimeUtil.createYyyyMMdd()) {
            filedHtmlCreator.isEditable = false;
        }
        String components = filedHtmlCreator.create(attendanceInput, validationResult);
        AttendanceInput attendanceInput2 = attendanceInput;
        class FormData
        extends WbsAbstractFormData {
            private final /* synthetic */ WbsArgument val$wcbArg;
            private final /* synthetic */ AttendanceInput val$attendanceInput2;
            private final /* synthetic */ String val$components;
            private final /* synthetic */ InnerFiledHtmlCreator val$filedHtmlCreator;

            FormData(WbsArgument wbsArgument, AttendanceInput attendanceInput, String string, InnerFiledHtmlCreator innerFiledHtmlCreator) {
                this.val$wcbArg = wbsArgument;
                this.val$attendanceInput2 = attendanceInput;
                this.val$components = string;
                this.val$filedHtmlCreator = innerFiledHtmlCreator;
            }

            @Override
            public String getIcon() throws Exception {
                return XwebIconManager.createTag(XwebIconManager.WebIcon.attendanceSchedule);
            }

            @Override
            public String getTitle() throws Exception {
                StringBuilder sb = new StringBuilder();
                sb.append(XsysWords.getInstance().\u30b7\u30d5\u30c8\u767b\u9332);
                return sb.toString();
            }

            @Override
            public String getDescription() throws Exception {
                StringBuilder sb = new StringBuilder();
                return sb.toString();
            }

            @Override
            public String getFileds() throws Exception {
                StringBuilder sb = new StringBuilder();
                Wbs1Workspace workspace = WorkspaceManager.getInstance().getWorkspace(this.val$wcbArg.getSiteContext(), this.val$attendanceInput2.workspaceId);
                PersonManager personManager = PersonManager.getInstance(this.val$wcbArg.getSiteContext().getDataSourceName());
                Wbs1Account account = personManager.getAccountByPersonId(this.val$attendanceInput2.personId);
                ArrayList<BcPair<String, String>> pairList = new ArrayList<BcPair<String, String>>();
                pairList.add(new BcPair<String, String>(XsysWords.getInstance().\u52e4\u52d9\u5148, workspace.name));
                pairList.add(new BcPair<String, String>(XsysWords.getInstance().\u30b9\u30bf\u30c3\u30d5\u540d, account.nickname));
                HtmlDlCreator dlCreator = new HtmlDlCreator();
                dlCreator.dlClass = "dl_1";
                dlCreator.dtSameWidth = true;
                dlCreator.dtAfter = ":";
                dlCreator.dtHorizonalAlignment = 4;
                dlCreator.ddFontSizeRem = dlCreator.dtFontSizeRem = 0.8;
                sb.append((CharSequence)dlCreator.create(pairList));
                sb.append(Wbs1AttendanceFormWCB.this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
                sb.append(this.val$components);
                return sb.toString();
            }

            @Override
            public String getControls() throws Exception {
                StringBuilder sb = new StringBuilder();
                if (this.val$filedHtmlCreator.isEditable) {
                    String href = XwebUtil.toRelativePath(this.val$wcbArg.getRequest(), Method.submit);
                    String onclickAction = WbfJslUtil.submit2(this.getFormName(), href);
                    sb.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().save, onclickAction));
                    if (this.val$attendanceInput2.id > 0L) {
                        String param1 = WbfwUtil.createParameter((Enum)WbxConstants.QueryParam.attendanceId, Long.toString(this.val$attendanceInput2.id));
                        href = String.valueOf(XwebUtil.toRelativePath(this.val$wcbArg.getRequest(), Method.delete)) + WbfwUtil.createUrlQuery(param1);
                        StringBuilder deleteButton = MdlCreator.getInstance().button_showModal(BcWords.getInstance().delete);
                        sb.append((CharSequence)deleteButton);
                        String msg = BcMessageCreator.getInstance().bindMessage(XsysWords.getInstance()._0_\u3092\u524a\u9664\u3057\u3066\u3088\u308d\u3057\u3044\u3067\u3059\u304b, "\u30b9\u30ad\u30eb\uff29\uff24-" + this.val$attendanceInput2.id);
                        onclickAction = WbfJslUtil.locationHref(href);
                        StringBuilder dialogActions = new StringBuilder();
                        dialogActions.append((CharSequence)MdlCreator.getInstance().button_close(BcWords.getInstance().no));
                        dialogActions.append(Wbs1AttendanceFormWCB.this.getHtmlBuilder2().button_button(BcWords.getInstance().yes, onclickAction));
                        sb.append((CharSequence)MdlCreator.getInstance().dialog("\u524a\u9664\u306e\u78ba\u8a8d", msg, dialogActions.toString()));
                    }
                }
                String onclickAction = XwebUtil.onclickActionToBack(this.val$wcbArg);
                sb.append(XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().cancel, onclickAction));
                return sb.toString();
            }
        }
        FormData formData = new FormData(wcbArg, attendanceInput2, components, filedHtmlCreator);
        WbxFormBuilder formBuilder = new WbxFormBuilder(this.getHtmlBuilder2());
        StringBuilder sb = new StringBuilder();
        sb.append(formBuilder.build(formData));
        sb = MdlCreator.getInstance().grid_cell(12, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        StringBuilder html = this.getBaseHtml(wcbArg);
        html = this.replace(wcbArg, formData.getTitle(), null, html);
        html = BcStringUtil.replace((CharSequence)html, WbxConstants.PlaceHolder.content.value, sb);
        WbfwUtil.outputHtml(wcbArg, html.toString());
    }

    public void submit(WbsArgument wcbArg) throws Exception {
        Serializable calendar;
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, true);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        AttendanceInput attendanceInput = new AttendanceInput();
        WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, attendanceInput);
        this.getLogger().debug("tempAttendance.startTime=" + attendanceInput.startTime + " tempAttendance.endTime=" + attendanceInput.endTime);
        XsysValidator validator = XsysValidator.getInstance();
        XsysValidationResult validationResult = validator.validate(attendanceInput);
        XwebUtil.saveValidationResult(httpSession, validationResult);
        if (!XwebUtil.isAcceptDate(attendanceInput.date)) {
            validationResult.addFieldError("AttendanceInput.date", "\u8a2d\u5b9a\u53ef\u80fd\u306a\u65e5\u4ed8\u3067\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        if (validationResult.hasError()) {
            XwebUtil.setAttribute(wcbArg, (Object)attendanceInput);
            String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Method.form);
            XwebUtil.redirectForError(wcbArg, validationResult, href);
            return;
        }
        Wbs1Attendance attendance = new Wbs1Attendance();
        attendance.id = attendanceInput.id;
        attendance.personId = attendanceInput.personId;
        attendance.workspaceId = attendanceInput.workspaceId;
        attendance.startDate = attendanceInput.date;
        attendance.startTime = XwebUtil.parserTiem(attendanceInput.startTime);
        attendance.endTime = XwebUtil.parserTiem(attendanceInput.endTime);
        attendance.requirementId = attendanceInput.requirementId;
        attendance.note1 = attendanceInput.note1;
        attendance.note2 = attendanceInput.note2;
        if (attendance.startTime < attendance.endTime) {
            attendance.endDate = attendance.startDate;
        } else {
            calendar = BcTimeUtil.toCalendar(attendance.startDate);
            ((Calendar)calendar).add(5, 1);
            attendance.endDate = BcTimeUtil.toYyyyMMdd((Calendar)calendar);
        }
        this.getLogger().debug("attendance.startTime=" + attendance.startTime + " attendance.endTime=" + attendance.endTime);
        httpSession.removeAttribute(attendanceInput.getClass().getName());
        calendar = null;
        Object var9_12 = null;
        try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            Wbs1AttendanceDAO.getInstance().putEntity(dtsSession, attendance);
            dtsSession.commit();
        }
        catch (Throwable throwable) {
            if (calendar == null) {
                calendar = throwable;
            } else if (calendar != throwable) {
                ((Throwable)calendar).addSuppressed(throwable);
            }
            throw calendar;
        }
        XwebUtil.redirectPreUrl(wcbArg);
    }

    public void delete(WbsArgument wcbArg) throws Exception {
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, true);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        String tmpStr = requestParameter.getAsString(WbxConstants.QueryParam.attendanceId.name());
        long attendanceId = BcNumberUtil.parseLong(tmpStr, -1);
        this.getLogger().debug("\u524a\u9664:attendanceId=" + attendanceId);
        Throwable throwable = null;
        Object var8_9 = null;
        try (DtsSession dtsSession = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            Wbs1Attendance attendance = Wbs1AttendanceDAO.getInstance().getById(dtsSession, attendanceId);
            this.getLogger().debug("delete:attendance=" + attendance);
            if (attendance != null) {
                Wbs1AttendanceDAO.getInstance().deleteEntity(dtsSession, attendance);
                dtsSession.commit();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        XwebUtil.redirectPreUrl(wcbArg);
    }

    public class AttendanceInput
    extends OrmAbstractEntity
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -6862705998377743116L;
        @ApcmFieldInput(inputType="hidden")
        public long id;
        @ApcmFieldInput(inputType="hidden")
        public long personId;
        @ApcmFieldInput(inputType="hidden")
        public long workspaceId;
        @ApcmFieldAnnotation(name="\u65e5\u4ed8")
        @ApcmFieldInput(inputType="date", required="true")
        public int date;
        @ApcmFieldAnnotation(name="\u958b\u59cb\u6642\u523b")
        @ApcmFieldInput(inputType="time", required="true")
        public String startTime;
        @ApcmFieldAnnotation(name="\u7d42\u4e86\u6642\u523b")
        @ApcmFieldInput(inputType="time", required="true")
        public String endTime;
        @ApcmFieldAnnotation(name="\u8981\u6c42\u5ea6")
        public Short requirementId;
        @ApcmFieldAnnotation(name="\u540c\u4f34\u306e\u304a\u5ba2\u69d8", dataSize="26")
        public String note1;
        @ApcmFieldAnnotation(name="\u5099\u8003", dataSize="40")
        @ApcmFieldInput(rowCount="2")
        public String note2;
    }

    class InnerFiledHtmlCreator
    extends WbsFiledHtmlCreator {
        boolean isEditable;

        public InnerFiledHtmlCreator(HtmlBuilder htmlBuilder) {
            super(htmlBuilder);
        }

        @Override
        protected String create_L3(Object entity, String entityName, XsysValidationResult validationResult, Field field, MmdField mmdField) throws Exception {
            StringBuilder sb = new StringBuilder();
            if (field.getName().equals("startTime")) {
                sb.append("<div style=\"display: flex; gap: 0rem 1rem;\">\n");
                sb.append("<div>\n");
            } else if (field.getName().equals("endTime")) {
                sb.append("<div style=\"display: flex; justify-content: center; align-items: center;\">\n");
                sb.append("<p>\uff5e</p>\n");
                sb.append("</div>\n");
                sb.append("<div>\n");
            }
            sb.append(super.create_L3(entity, entityName, validationResult, field, mmdField));
            if (field.getName().equals("startTime")) {
                sb.append(this.getHtmlBuilder().div_end());
            } else if (field.getName().equals("endTime")) {
                sb.append(this.getHtmlBuilder().div_end());
                sb.append(this.getHtmlBuilder().div_end());
            }
            return sb.toString();
        }

        @Override
        protected String createFiledHtml(Object entity, String entityName, XsysValidationResult validationResult, Field field, MmdField mmdField, int arrayIndex) throws Exception {
            if (field.getName().equals("requirementId")) {
                String inputName = XsysFieldKeyCreator.getInstance().createKey(arrayIndex, entityName, mmdField.fieldName);
                String strValue = this.toStringValue(entity, field, mmdField, arrayIndex);
                ArrayList<BcPair<String, String>> pairList = new ArrayList<BcPair<String, String>>();
                pairList.add(new BcPair<String, String>(Short.toString(Wbs1Constants.Requirement.n1_\u7d76\u5bfe\u51fa\u52e4\u3057\u305f\u3044.id), Wbs1Constants.Requirement.n1_\u7d76\u5bfe\u51fa\u52e4\u3057\u305f\u3044.dispName));
                pairList.add(new BcPair<String, String>(Short.toString(Wbs1Constants.Requirement.n2_\u51fa\u6765\u305f\u3089\u51fa\u52e4\u3057\u305f\u3044.id), Wbs1Constants.Requirement.n2_\u51fa\u6765\u305f\u3089\u51fa\u52e4\u3057\u305f\u3044.dispName));
                pairList.add(new BcPair<String, String>(Short.toString(Wbs1Constants.Requirement.n3_\u5fc5\u8981\u306a\u3089\u51fa\u52e4\u53ef\u80fd.id), Wbs1Constants.Requirement.n3_\u5fc5\u8981\u306a\u3089\u51fa\u52e4\u53ef\u80fd.dispName));
                StringBuilder sb = new StringBuilder();
                sb.append(this.getHtmlBuilder().div_start());
                sb.append(this.getHtmlBuilder().select(inputName, pairList, strValue));
                sb.append(this.getHtmlBuilder().div_end());
                sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
                return sb.toString();
            }
            return super.createFiledHtml(entity, entityName, validationResult, field, mmdField, arrayIndex);
        }

        @Override
        protected String toStringValue(Object entity, Field field, MmdField mmdField, int arrayIndex) throws Exception {
            if (field.getName().equals("startTime") || field.getName().equals("endTime")) {
                Object value = this.getFieldValue(entity, field, mmdField, arrayIndex);
                Short hhmm = BcNumberUtil.parseShort(value, null);
                return WbfwUtil.toTimeValue(hhmm);
            }
            return super.toStringValue(entity, field, mmdField, arrayIndex);
        }

        @Override
        protected boolean isReadonly(Object entity, Field field, MmdField mmdField, int arrayIndex) throws Exception {
            if (this.isEditable) {
                return mmdField.readonly;
            }
            return true;
        }
    }

    public static enum Method implements WbxPath
    {
        form("attendancForm"),
        submit("attendancSubmit"),
        delete("attendancDelete");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1AttendanceFormWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

