/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.util.Arrays;
import java.util.List;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCsvUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.etc.util.EtcPagination;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.component.WhcBuilder;
import jp.co.extreme.html.component.WhcComponent;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.common.Wbs1Words;
import jp.co.extreme.module.wbs1.dao.Wbs1AccountDAO;
import jp.co.extreme.module.wbs1.dao.Wbs1ArticleDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.Wbs1Article;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.module.wbs1.wcb.Wbs1AbstractWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1EditorFormWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1ImageWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1LinkUtil;
import jp.co.extreme.module.wbs1.wcb.Wbs1RecruitmentListWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1ShopDataHelper;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsControlContext;
import jp.co.extreme.module.xdts.web.XdsDataViewUtil;
import jp.co.extreme.module.xsys.validation.XsysValidationResult;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.HtmlUtil2;
import jp.co.extreme.module.xweb.common.PersonProfileUtil;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxParameterUtil;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebPaginationBuilder;
import jp.co.extreme.module.xweb.common.XwebUtil;
import jp.co.extreme.person.common.PsnPersonConstants;
import jp.co.extreme.person.util.PsnPersonUtil;
import jp.co.extreme.web.javascript.WbfJslUtil;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;

public class Wbs1ArticleListWCB
extends Wbs1AbstractWCB {
    @Override
    protected String createHeadStyle(WbsArgument wcbArg) throws Exception {
        StringBuilder sb = new StringBuilder();
        BcStringUtil.append(sb, super.createHeadStyle(wcbArg));
        return sb.toString();
    }

    public void form(WbsArgument wcbArg) throws Exception {
        Throwable throwable = null;
        Object var3_5 = null;
        try (DtsSession dtsSessionSite = XwebUtil.createDataSourceSession(wcbArg.getSiteContext(), this);){
            this.form_L2(wcbArg, dtsSessionSite);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void form_L2(WbsArgument wcbArg, DtsSession dtsSessionSite) throws Exception {
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        BcLogUtil.debug("requestParameter.map=" + requestParameter.map);
        String tmpStr = requestParameter.getAsString(Wbs1Constants.ArticleParam.articleCategoryId.name());
        int articleCategoryId = BcNumberUtil.parseInteger(tmpStr, -1);
        Wbs1Constants.ArticleCategory articleCategory = Wbs1Constants.ArticleCategory.getById(articleCategoryId);
        BcLogUtil.debug("articleCategory=" + (Object)((Object)articleCategory));
        Wbs1Constants.ArticleContext articleContext = Wbs1Constants.ceateArticleContext(articleCategory);
        StringBuilder content = this.form_L3(wcbArg, dtsSessionSite, articleContext);
        StringBuilder sb = this.getBaseHtml(wcbArg);
        sb = this.replace(wcbArg, articleContext.title, articleContext.description, sb);
        sb = BcStringUtil.replace((CharSequence)sb, WbxConstants.PlaceHolder.content.value, content);
        WbfwUtil.outputHtml(wcbArg, sb.toString());
    }

    protected StringBuilder form_L3(WbsArgument wcbArg, DtsSession dtsSessionSite, Wbs1Constants.ArticleContext articleContext) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.getToken(wcbArg, WbxConstants.TokenType.search);
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        WbsTempCondition tempCondition = null;
        if (tokenContext.validationResult == null) {
            tokenContext.validationResult = new XsysValidationResult();
            tempCondition = new WbsTempCondition();
            XwebUtil.putToMap(tokenContext.map, tempCondition);
        } else {
            tempCondition = (WbsTempCondition)XwebUtil.getMapValue(tokenContext.map, WbsTempCondition.class);
        }
        EtcPagination pagination = XwebUtil.cretaePagination(wcbArg);
        if (pagination.getPageNumReq() <= 0) {
            WbxParameterUtil.getInstance().setFieldValue(requestParameter.map, tempCondition);
        }
        StringBuilder sb = new StringBuilder();
        int contentColumn = 10;
        sb.append((CharSequence)MdlCreator.getInstance().div_grid_cell_start(contentColumn));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        sb.append(this.getHtmlBuilder().h(3, articleContext.title, "headline1"));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append((CharSequence)this.createConditionForm(wcbArg, tokenContext, dtsSessionSite, Method.form.path, tempCondition));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append((CharSequence)this.createDetailList(wcbArg, tokenContext, pagination, dtsSessionSite, articleContext, tempCondition));
        sb.append(this.getHtmlBuilder().div_end());
        MdlCreator mdlCreator = MdlCreator.getInstance();
        MdlCreator.getInstance();
        sb.append((CharSequence)mdlCreator.div_grid_cell_start(12 - contentColumn));
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1RecruitmentListWCB.Method.form);
        StringBuilder sb2 = Wbs1LinkUtil.getInstance().createLink(wcbArg, dtsSessionSite);
        sb.append((CharSequence)sb2);
        sb.append(this.getHtmlBuilder().div_end());
        sb = MdlCreator.getInstance().grid_portfolio(sb, true);
        return sb;
    }

    protected StringBuilder createConditionForm(WbsArgument wcbArg, WbxTokenContext tokenContext, DtsSession dtsSessionSite, String url, WbsTempCondition tempCondition) throws Exception {
        StringBuilder sb = this.createConditionForm_L2(wcbArg, tokenContext, dtsSessionSite, tempCondition);
        String formName = "form1";
        StringBuilder controls = new StringBuilder();
        String onclickAction = WbfJslUtil.submit2(formName, url);
        String searchButton = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().search, onclickAction);
        controls.append(searchButton);
        sb.append((CharSequence)this.getHtmlBuilder().div(controls.toString(), HtmlConstants.HtmlAlign.center, -1));
        sb.append(XwebUtil.createTokenHiddn(this.getHtmlBuilder(), tokenContext));
        sb = HtmlUtil2.form(formName, sb.toString());
        return sb;
    }

    protected StringBuilder createConditionForm_L2(WbsArgument wcbArg, WbxTokenContext tokenContext, DtsSession dtsSessionSite, WbsTempCondition tempCondition) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (tempCondition != null) {
            if (BcStringUtil.isEmpty(tempCondition.area) && tokenContext.cnt <= 1L) {
                WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
                String area = requestParameter.getAsString("area");
                tempCondition.area = !BcStringUtil.isEmpty(area) ? area : "\u6e0b\u8c37";
            }
            List<String> areaList = Wbs1ShopDataHelper.getInstance().getAreaList(dtsSessionSite);
            sb.append((CharSequence)this.createConditionForm_L3(WbsTempCondition.FieldName.area.fieldName, areaList, tempCondition.area, "\u3010\u5730\u57df\u3011"));
            String[] strArray = new String[]{"\u30ad\u30e3\u30d0\u30af\u30e9", "\u30ac\u30fc\u30eb\u30ba\u30d0\u30fc", "\u30af\u30e9\u30d6", "\u30b9\u30ca\u30c3\u30af", "\u671d\u30ad\u30e3\u30d0\u30fb\u663c\u30ad\u30e3\u30d0", "\u30d0\u30fc", "\u30b3\u30f3\u30bb\u30d7\u30c8\u30ab\u30d5\u30a7"};
            List<String> businessTypeList = Arrays.asList(strArray);
            sb.append((CharSequence)this.createConditionForm_L3(WbsTempCondition.FieldName.businessType.fieldName, businessTypeList, tempCondition.businessType, "\u3010" + Wbs1Words.getInstance().\u696d\u614b + "\u3011"));
        }
        if (tempCondition != null) {
            String[] strArray = new String[]{"\u30d5\u30ed\u30a2\u30ec\u30c7\u30a3", "\u30ab\u30a6\u30f3\u30bf\u30fc\u30ec\u30c7\u30a3", "\u30c1\u30fc\u30de\u30de", "\u30a6\u30a8\u30a4\u30c8\u30ec\u30b9", "\u30d0\u30fc\u30c6\u30f3\u30c0\u30fc", "\u30db\u30fc\u30eb\u30b9\u30bf\u30c3\u30d5"};
            List<String> occupationList = Arrays.asList(strArray);
            sb.append((CharSequence)this.createConditionForm_L3(WbsTempCondition.FieldName.occupation.fieldName, occupationList, tempCondition.occupation, "\u3010" + Wbs1Words.getInstance().\u8077\u7a2e + "\u3011"));
        }
        return sb;
    }

    protected StringBuilder createConditionForm_L3(String whcComponentName, List<String> optionList, String defaultValue, String title) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, ExtwCssUtil.ExtwClass.extw_padding_08rem.className));
        sb.append(this.getHtmlBuilder().p(title, true));
        XdtsControlContext controlContext = new XdtsControlContext();
        controlContext.controlType = XdtsConstants.ControlType.CheckBox;
        controlContext.options = BcCsvUtil.toCsv(optionList, true);
        controlContext.defaultValue = defaultValue;
        XdtsUserSetting userSetting = null;
        WhcComponent whcComponent = XdsDataViewUtil.createHtmlComponent(controlContext, userSetting, whcComponentName);
        WhcBuilder whcBuilder = new WhcBuilder(this.getHtmlBuilder());
        sb.append(whcBuilder.createComponentHtml(whcComponent, true));
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    protected StringBuilder createDetailList(WbsArgument wcbArg, WbxTokenContext tokenContext, EtcPagination pagination, DtsSession dtsSessionSite, Wbs1Constants.ArticleContext articleContext, WbsTempCondition tempCondition) throws Exception {
        Wbs1ArticleDAO articleDao = Wbs1ArticleDAO.getInstance(articleContext.articleCategory.tableName);
        List articleList1 = articleDao.getList(dtsSessionSite, Wbs1ArticleDAO.Mode.id, -1L, null, null);
        XwebUtil.putToMap(tokenContext.map, articleList1);
        pagination.setDataCount(articleList1.size());
        List articleList2 = pagination.newList(articleList1);
        StringBuilder sb = new StringBuilder();
        InnerPaginationBuilder paginationBuilder = new InnerPaginationBuilder();
        paginationBuilder.tokenContext = tokenContext;
        paginationBuilder.articleContext = articleContext;
        sb.append(paginationBuilder.create(wcbArg, pagination));
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        int i = 0;
        while (i < articleList2.size()) {
            Wbs1Article article = (Wbs1Article)articleList2.get(i);
            switch (articleContext.articleCategory) {
                case bulletinBoard: {
                    sb.append((CharSequence)this.createDetailCell(wcbArg, dtsSessionSite, articleContext, article));
                    break;
                }
                default: {
                    sb.append((CharSequence)this.createDetailCell(wcbArg, dtsSessionSite, articleContext, article));
                }
            }
            sb.append("\n\n");
            ++i;
        }
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        sb.append(paginationBuilder.create(wcbArg, pagination));
        return sb;
    }

    protected StringBuilder createDetailCell(WbsArgument wcbArg, DtsSession dtsSessionSite, Wbs1Constants.ArticleContext articleContext, Wbs1Article article) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, ExtwCssUtil.ExtwClass.extw_padding_04rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_table.className));
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(ExtwCssUtil.ExtwClass.extw_table_cell.className);
        CssBuiler cssBuiler = new CssBuiler();
        globalAttribute.style = cssBuiler.width("6rem").build();
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append((CharSequence)this.tableCellLeft(wcbArg, dtsSessionSite, articleContext, article));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_table_cell.className));
        sb.append((CharSequence)this.tableCellMiddle(wcbArg, dtsSessionSite, articleContext, article));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        sb.append(this.getHtmlBuilder().div_start(globalAttribute));
        sb.append((CharSequence)this.tableCellRight(wcbArg, dtsSessionSite, articleContext, article));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    protected StringBuilder tableCellLeft(WbsArgument wcbArg, DtsSession dtsSessionSite, Wbs1Constants.ArticleContext articleContext, Wbs1Article article) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(article.texts[Wbs1Constants.ArticleItem.\u8868\u984c.ordinal()])) {
            sb.append((CharSequence)MdlCreator.getInstance().card_title(article.texts[Wbs1Constants.ArticleItem.\u8868\u984c.ordinal()]));
        }
        if (article.int4 > 0) {
            String param1 = WbfwUtil.createParameter((Enum)WbxConstants.QueryParam.fileId, Long.toString(article.int4));
            String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1ImageWCB.Method.getImage)) + WbfwUtil.createUrlQuery(param1);
            StringBuilder media = new StringBuilder();
            media.append(this.getHtmlBuilder().image_class(href, "article-image"));
            sb.append((CharSequence)MdlCreator.getInstance().card_media(media));
        }
        return sb;
    }

    protected StringBuilder tableCellMiddle(WbsArgument wcbArg, DtsSession dtsSessionSite, Wbs1Constants.ArticleContext articleContext, Wbs1Article article) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (!BcStringUtil.isEmpty(article.texts[Wbs1Constants.ArticleItem.HTML.ordinal()])) {
            StringBuilder supportingText = new StringBuilder();
            MdlCreator.getInstance();
            supportingText.append("<small>");
            supportingText.append(article.texts[Wbs1Constants.ArticleItem.HTML.ordinal()]);
            MdlCreator.getInstance();
            supportingText.append("</small>");
            sb.append(MdlCreator.getInstance().card_supporting_text(supportingText.toString()));
        }
        return sb;
    }

    protected StringBuilder tableCellRight(WbsArgument wcbArg, DtsSession dtsSessionSite, Wbs1Constants.ArticleContext articleContext, Wbs1Article article) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.articleEditButton(wcbArg, articleContext, article));
        return sb;
    }

    protected StringBuilder createDetailCell_bulletinBoard(WbsArgument wcbArg, DtsSession dtsSessionSite, Wbs1Constants.ArticleContext articleContext, Wbs1Article article) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, ExtwCssUtil.ExtwClass.extw_padding_08rem.className));
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        sb.append(this.getHtmlBuilder().h(6, article.texts[Wbs1Constants.ArticleItem.\u8868\u984c.ordinal()]));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        sb.append(this.getHtmlBuilder().p(article.texts[Wbs1Constants.ArticleItem.\u672c\u6587.ordinal()], true));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append(this.getHtmlBuilder().div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        Wbs1Account account = (Wbs1Account)Wbs1AccountDAO.getInstance().getByPersonId(dtsSessionSite, article.personId);
        PsnPersonConstants.Sex sex = PsnPersonUtil.toSexByCode(account.sexCode);
        if (sex != null) {
            String sexSymbolTag = PersonProfileUtil.toSexSymbolTag(sex);
            sb.append(sexSymbolTag);
            sb.append(this.getHtmlBuilder().p(":" + sex.nameJpn1, true));
        }
        sb.append(this.getHtmlBuilder().p(account.nickname, true));
        sb.append(this.getHtmlBuilder().p(" ", true));
        String datetimeStr = BcTimeUtil.toString(article.addDatetime, "yyyy/MM/dd HH:mm");
        sb.append(this.getHtmlBuilder().p(datetimeStr, true));
        sb.append(this.getHtmlBuilder().div_end());
        sb.append((CharSequence)this.articleEditButton(wcbArg, articleContext, article));
        sb.append(this.getHtmlBuilder().div_end());
        return sb;
    }

    protected StringBuilder articleEditButton(WbsArgument wcbArg, Wbs1Constants.ArticleContext articleContext, Wbs1Article article) throws Exception {
        StringBuilder sb = new StringBuilder();
        Wbs1Account loginAccount = XwebUtil.getLoginAccount(wcbArg, false);
        if (loginAccount != null) {
            String param1 = WbfwUtil.createParameter((Enum)Wbs1Constants.ArticleParam.articleCategoryId, (Number)articleContext.articleCategory.id);
            String param2 = WbfwUtil.createParameter((Enum)Wbs1Constants.ArticleParam.articleId, Long.toString(article.id));
            String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1EditorFormWCB.Method.form)) + WbfwUtil.createUrlQuery(param1, param2);
            String onclickAction = WbfJslUtil.locationHref(href);
            String button = XwebHtmlBuilder.getInstance().button_button(BcWords.getInstance().edit, onclickAction);
            sb.append(button);
        }
        return sb;
    }

    class InnerPaginationBuilder
    extends XwebPaginationBuilder {
        WbxTokenContext tokenContext;
        Wbs1Constants.ArticleContext articleContext;

        InnerPaginationBuilder() {
        }

        @Override
        protected String createHref(WbsArgument wcbArg, int pageNo) throws Exception {
            String param1 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.token.name(), (Object)XwebUtil.createTokenString(this.tokenContext));
            String param2 = WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.page.name(), (Number)pageNo);
            String param3 = WbfwUtil.createParameter(Wbs1Constants.ArticleParam.articleCategoryId.name(), (Number)this.articleContext.articleCategory.id);
            String href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Method.form)) + WbfwUtil.createUrlQuery(param1, param2);
            return href;
        }
    }

    public static enum Method implements WbxPath
    {
        form("article-list");

        private final String path;

        private Method(String path) {
            this.path = XwebUtil.createPath(this, path);
        }

        @Override
        public String getClassName() {
            return Wbs1ArticleListWCB.class.getName();
        }

        @Override
        public String getMethodName() {
            return this.name();
        }

        @Override
        public String getPath() {
            return this.path;
        }
    }
}

