/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.wcbx;

import java.util.Calendar;
import java.util.Vector;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.mmd.MmdUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableColumnModel;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.datasource.DtsConnectionManagerImpl;
import jp.co.extreme.module.wbfw.html.WbfwHtmlTableCreator;
import jp.co.extreme.module.wbfw.wcb.WbfwAbstractWCB;
import jp.co.extreme.rmi.common.RmiMethodContext;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.web.server.WbsArgument;
import jp.co.extreme.web.server.WbsRequestParameter;
import jp.co.extreme.web.server.WbsResourceHolder;
import jp.co.extreme.web.server.WbxxCmcManager;

public class WbfwDBConnectionMonitorWCB
extends WbfwAbstractWCB {
    public static final String SBMD_sqlConnnectionList = "sqlConnnectionList";
    public static final String SBMD_propertyDisplay = "propertyDisplay";
    public static final String SBMD_propertySet = "propertySet";
    public static final String SBMD_logClear = "logClear";

    public static String getInvokeMethodCode(WbsArgument wcbArg) throws Exception {
        WbxxCmcManager cmcManager = WbsResourceHolder.getInstance().cmcManager;
        RmiMethodContext methodContext = cmcManager.getMethodContextByName(wcbArg, String.valueOf(WbfwDBConnectionMonitorWCB.class.getName()) + ".primaryMethod");
        return methodContext.id;
    }

    protected StringBuilder sqlConnnectionSummary(WbsArgument wcbArg, DtsConnectionManagerImpl connectionManager) throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = null;
        MmdField mmdField = null;
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("No.");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("item");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("value");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        Vector<Object> valueVec = new Vector<Object>();
        valueVec.add(2);
        valueVec.add("\u6700\u5c0f\u63a5\u7d9a\u6570");
        valueVec.add(BcNumberUtil.toString(connectionManager.getMinIdle()));
        tableModel.addRow(valueVec);
        valueVec = new Vector();
        valueVec.add(1);
        valueVec.add("\u6700\u5927\u63a5\u7d9a\u6570");
        valueVec.add(BcNumberUtil.toString(connectionManager.getMaxIdle()));
        tableModel.addRow(valueVec);
        valueVec = new Vector();
        valueVec.add(3);
        valueVec.add("SQL\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8");
        valueVec.add(BcNumberUtil.toString(connectionManager.getLendingTimeout()));
        tableModel.addRow(valueVec);
        valueVec = new Vector();
        valueVec.add(4);
        valueVec.add("\u8cb8\u51fa\u78ba\u8a8d\u9593\u9694");
        valueVec.add(BcNumberUtil.toString(connectionManager.getValidationInterval()));
        tableModel.addRow(valueVec);
        WbfwHtmlTableCreator htmlTableCreator = new WbfwHtmlTableCreator();
        return htmlTableCreator.createTable(wcbArg, BcTableUtil.createTableColumnList(tableColumnModel, true), tableModel, null);
    }

    protected StringBuilder sqlConnnectionDeatil(WbsArgument wcbArg, DtsConnectionManagerImpl connectionManager) throws Exception {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<BR>");
        sb.append("\u5f85\u6a5f\u4e2d");
        SqlConnection[] sqlConnnections1 = connectionManager.getIdlingQueue().toArray(new SqlConnection[0]);
        sb.append((CharSequence)this.createDBConnectionTable(wcbArg, sqlConnnections1));
        sb.append("<BR>");
        sb.append("\u4f7f\u7528\u4e2d");
        SqlConnection[] sqlConnnections2 = connectionManager.getLendingQueue().toArray(new SqlConnection[0]);
        sb.append((CharSequence)this.createDBConnectionTable(wcbArg, sqlConnnections2));
        sb.append("<BR>");
        sb.append("DB\u63a5\u7d9a\u6570\u8b66\u544a\u95be\u5024\u8d85\u904e\u306b\u95a2\u3059\u308b\u60c5\u5831");
        sb.append("<BR>");
        sb.append("<BR>");
        sb.append("SQL\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u306b\u95a2\u3059\u308b\u60c5\u5831");
        sb.append("<BR>");
        sb.append("<BR>");
        sb.append("DB\u63a5\u7d9a\u6570\u8d85\u904e\u306b\u95a2\u3059\u308b\u60c5\u5831");
        sb.append("<BR>");
        return sb;
    }

    protected StringBuilder createDBConnectionTable(WbsArgument wcbArg, SqlConnection[] sqlConnArray) throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = null;
        MmdField mmdField = null;
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("No.");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Integer.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("hashcode");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Calendar.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("connect");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Long.class;
        mmdField.fieldDisplay.formatStr = "#,###";
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("SQL timeout(ms)");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = Calendar.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("SQL timeout time");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("start");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.dataClass = String.class;
        tableColumn.setMmdField(mmdField);
        tableColumn.setHeaderValue("owner");
        tableColumn.setModelIndex(tableColumnModel.getColumnCount());
        tableColumnModel.addColumn(tableColumn);
        BcTableModel tableModel = new BcTableModel(tableColumnModel);
        int cnt = 0;
        int i = 0;
        while (i < sqlConnArray.length) {
            SqlConnection sqlConn = sqlConnArray[i];
            Vector<Object> valueVec = new Vector<Object>();
            valueVec.add(++cnt);
            valueVec.add(sqlConn.hashCode());
            if (sqlConn.getCreateTime() == Long.MAX_VALUE) {
                valueVec.add(null);
            } else {
                valueVec.add(BcTimeUtil.toCalendar(sqlConn.getCreateTime()));
            }
            if (sqlConn.getLendingTimeout() <= 0L) {
                valueVec.add(null);
            } else {
                valueVec.add(sqlConn.getLendingTimeout());
            }
            if (sqlConn.getLendingTimeoutTime() == Long.MAX_VALUE) {
                valueVec.add(null);
            } else {
                valueVec.add(BcTimeUtil.toCalendar(sqlConn.getLendingTimeoutTime()));
            }
            if (sqlConn.getLendingStartTime() == Long.MAX_VALUE) {
                valueVec.add(null);
            } else {
                valueVec.add(BcTimeUtil.toCalendar(sqlConn.getLendingStartTime()));
            }
            valueVec.add(sqlConn.getOwner());
            tableModel.addRow(valueVec);
            ++i;
        }
        WbfwHtmlTableCreator htmlTableCreator = new WbfwHtmlTableCreator();
        return htmlTableCreator.createTable(wcbArg, BcTableUtil.createTableColumnList(tableColumnModel, true), tableModel, null);
    }

    protected StringBuilder propertyDisplay(WbsArgument wcbArg, DtsConnectionManagerImpl connectionManager) throws Exception {
        MmdModel mmdModel = new MmdModel();
        MmdField mmdField = new MmdField();
        mmdField.columnName = "conMin";
        mmdField.dataClass = Integer.class;
        mmdField.fieldDisplay.displayName = "\u6700\u5c0f\u30d7\u30fc\u30eb\u6570";
        mmdField.defaultValue = Integer.toString(connectionManager.getMinIdle());
        mmdModel.addField(mmdField);
        mmdField = new MmdField();
        mmdField.columnName = "conMax";
        mmdField.dataClass = Integer.class;
        mmdField.fieldDisplay.displayName = "\u6700\u5927\u30d7\u30fc\u30eb\u6570";
        mmdField.defaultValue = Integer.toString(connectionManager.getMaxIdle());
        mmdModel.addField(mmdField);
        mmdField = new MmdField();
        mmdField.columnName = "sqlTimeout";
        mmdField.dataClass = Integer.class;
        mmdField.fieldDisplay.displayName = "SQL\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8";
        mmdField.defaultValue = Long.toString(connectionManager.getLendingTimeout());
        mmdModel.addField(mmdField);
        mmdField = new MmdField();
        mmdField.columnName = "sqlTimeoutCheckInterval";
        mmdField.dataClass = Integer.class;
        mmdField.fieldDisplay.displayName = "\u8cb8\u51fa\u78ba\u8a8d\u9593\u9694";
        mmdField.defaultValue = Long.toString(connectionManager.getValidationInterval());
        mmdModel.addField(mmdField);
        StringBuilder sb = this.createEditHtml(mmdModel);
        return sb;
    }

    protected StringBuilder createEditHtml(MmdModel mmdModel) throws Exception {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(this.getHtmlBuilder().div_start("box01"));
        sb.append(this.getHtmlBuilder().table_start());
        int i = 0;
        while (i < mmdModel.getFieldCount()) {
            MmdField mmdField = mmdModel.getField(i);
            sb.append(this.getHtmlBuilder().tr_start());
            sb.append(this.getHtmlBuilder().tableCell(1, 1, "form_01_td_item"));
            sb.append(MmdUtil.getProvisionalHeaderValue(mmdField));
            sb.append(this.getHtmlBuilder().td_end());
            sb.append(this.getHtmlBuilder().tableCell(1, 1, "form_01_td_value"));
            sb.append(this.getHtmlBuilder().textField(mmdField.columnName, mmdField.defaultValue));
            sb.append(this.getHtmlBuilder().td_end());
            sb.append(this.getHtmlBuilder().tr_end());
            ++i;
        }
        sb.append(this.getHtmlBuilder().table_end());
        sb.append(this.getHtmlBuilder().div_end());
        sb.append("\n");
        return sb;
    }

    protected StringBuilder propertySet(WbsArgument wcbArg, DtsConnectionManagerImpl connectionManager) throws Exception {
        WbsRequestParameter requestParameter = wcbArg.getRequestParameter();
        String tmpStr = requestParameter.getAsString("conMin");
        connectionManager.setMinIdle(BcNumberUtil.parseInt(tmpStr, 0));
        tmpStr = requestParameter.getAsString("conMax");
        connectionManager.setMaxIdle(BcNumberUtil.parseInt(tmpStr, 0));
        tmpStr = requestParameter.getAsString("sqlTimeout");
        connectionManager.setLendingTimeout(BcNumberUtil.parseInt(tmpStr, 0));
        tmpStr = requestParameter.getAsString("sqlTimeoutCheckInterval");
        StringBuilder sb = this.propertyDisplay(wcbArg, connectionManager);
        return sb;
    }
}

