/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mmdx.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.mmdx.model.MmdxModel;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class MmdxModelDAO
extends OrmAbstractDAO<MmdxModel> {
    public static final int MODE_default = 1;

    private MmdxModelDAO() {
        super(new MmdxModel[0]);
        this.setTableName("mdx_model");
    }

    public static MmdxModelDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, Long dataSourceId, String tableName2) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (dataSourceId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("schema_id = " + dataSourceId);
            selectQuery.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(tableName2)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("table_name " + sqlContext.toCondition_string("=", tableName2));
            selectQuery.addWhereElement(whereElement);
        }
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + BcStringUtil.appendCaseOfTestDataNotEmpty(alias, " AS " + alias));
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "schema_id");
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "table_name");
        }
        return selectQuery;
    }

    public List<MmdxModel> getList(DtsSession dtsSession, Long dataSourceId, String modelName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = null;
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, 1, alias, dataSourceId, modelName);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public MmdxModel getByName(DtsSession dtsSession, Long dataSourceId, String modelName) throws Exception {
        List<MmdxModel> entityList = this.getList(dtsSession, dataSourceId, modelName);
        return BcCollectionUtil.getFirst(entityList);
    }

    public long deleteByModelName(DtsSession dtsSession, String tableName2) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "DELETE FROM " + this.getTableName() + " WHERE table_name" + sqlContext.toCondition_string("=", tableName2);
        BcLogUtil.debug("query=" + query);
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    /* synthetic */ MmdxModelDAO(MmdxModelDAO mmdxModelDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final MmdxModelDAO instance = new MmdxModelDAO(null);

        private SingletonHolder() {
        }
    }
}

