/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.ffmpeg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.fx.skin.FxCssUtil;
import jp.co.extreme.module.ffmpeg.FfmpegHelper;
import jp.co.extreme.module.ffmpeg.FfpegText;

public class FfmpegParamBuiler
extends BcLoggableObject {
    private List<String> list1 = new ArrayList<String>();
    private List<String> vfList = new ArrayList<String>();

    public FfmpegParamBuiler clear() {
        this.list1.clear();
        return this;
    }

    public StringBuilder toElem(String propertyName, String values) {
        StringBuilder sb = new StringBuilder();
        sb.append(propertyName);
        sb.append(':');
        sb.append(values);
        return sb;
    }

    protected FfmpegParamBuiler addParam(String ... params) {
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.list1.add(str);
            ++n2;
        }
        return this;
    }

    public List<String> build() {
        ArrayList<String> list2 = new ArrayList<String>();
        list2.addAll(this.list1);
        if (this.vfList.size() > 0) {
            StringBuilder vf = new StringBuilder();
            for (String param : this.vfList) {
                if (vf.length() > 0) {
                    vf.append(",");
                }
                vf.append(param);
            }
            list2.add("-vf");
            list2.add(vf.toString());
        }
        return list2;
    }

    public FfmpegParamBuiler version() {
        return this.addParam("-version");
    }

    public FfmpegParamBuiler input(String path) {
        return this.addParam("-i", path);
    }

    public FfmpegParamBuiler startTimeMillis(long startMillis) {
        return this.addParam("-ss", FfmpegHelper.getInstance().formatDuration(startMillis));
    }

    public FfmpegParamBuiler trimmingDuration(long duration) {
        return this.addParam("-t", FfmpegHelper.getInstance().formatDuration(duration));
    }

    public FfmpegParamBuiler scale(int width, int height) {
        StringBuilder sb = new StringBuilder();
        sb.append("scale=");
        if (width > 0) {
            sb.append(width);
            sb.append(":");
            if (height > 0) {
                sb.append(height);
            } else {
                sb.append("-2");
            }
        } else {
            sb.append("-2:");
            if (height > 0) {
                sb.append(height);
            } else {
                return this;
            }
        }
        this.vfList.add(sb.toString());
        return this;
    }

    public String eq(long frameNo) {
        StringBuilder sb = new StringBuilder();
        sb.append("eq(n,");
        sb.append(frameNo);
        sb.append(")");
        return sb.toString();
    }

    public FfmpegParamBuiler eq(Collection<Long> frameNoCollection) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (Long frameNo : frameNoCollection) {
            if (sb.length() > 0) {
                sb.append("+");
            }
            sb.append(this.eq(frameNo));
        }
        this.vfList.add("select=" + BcStringUtil.singleQuotation(sb.toString()));
        return this;
    }

    public FfmpegParamBuiler text(FfpegText ffpegText) throws Exception {
        if (BcStringUtil.isEmpty(ffpegText.text)) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("drawtext=");
        sb.append("text=" + BcStringUtil.singleQuotation(ffpegText.text));
        if (!BcStringUtil.isEmpty(ffpegText.x)) {
            sb.append(":x=" + ffpegText.x);
        }
        if (!BcStringUtil.isEmpty(ffpegText.y)) {
            sb.append(":y=" + ffpegText.y);
        }
        if (ffpegText.fontSize > 0) {
            sb.append(":fontsize=" + ffpegText.fontSize);
        }
        if (ffpegText.fontColor != null) {
            sb.append(":fontcolor=" + BcStringUtil.singleQuotation(FxCssUtil.toColorCode(ffpegText.fontColor)));
        }
        if (ffpegText.borderw > 0) {
            sb.append(":borderw=" + ffpegText.borderw);
            sb.append(":bordercolor=" + BcStringUtil.singleQuotation(FxCssUtil.toColorCode(ffpegText.borderColor)));
        }
        if (ffpegText.shadowX > 0) {
            sb.append(":shadowx=" + ffpegText.shadowX);
        }
        if (ffpegText.shadowY > 0) {
            sb.append(":shadowy=" + ffpegText.shadowY);
        }
        this.vfList.add(sb.toString());
        return this;
    }
}

