/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import jp.co.extreme.fx.util.FxUtil;

public class FxControlPane
extends FlowPane {
    static final int DEFAULT_GROUP_NUMBER = 0;
    private double height = 36.0;
    private double controlGap = 8.0;
    private Pos alignmentPos = Pos.CENTER;
    private Map<Integer, FlowPane> groupNumberMap = new HashMap<Integer, FlowPane>();

    public FxControlPane() throws Exception {
        this.setOrientation(Orientation.HORIZONTAL);
        this.setAlignment(this.alignmentPos);
        this.setPrefHeight(this.height);
    }

    public void clear() throws Exception {
        for (FlowPane flowPane : this.groupNumberMap.values()) {
            flowPane.getChildren().clear();
        }
        this.groupNumberMap.clear();
        this.getChildren().clear();
    }

    public FlowPane getControlPane(int groupNumber, boolean doCreate) throws Exception {
        FlowPane flowPane = this.groupNumberMap.get(groupNumber);
        if (flowPane != null) {
            return flowPane;
        }
        if (!doCreate) {
            return flowPane;
        }
        flowPane = new FlowPane();
        flowPane.setHgap(this.controlGap);
        flowPane.setVgap(this.controlGap);
        flowPane.setOrientation(Orientation.HORIZONTAL);
        flowPane.setAlignment(this.alignmentPos);
        this.groupNumberMap.put(groupNumber, flowPane);
        ArrayList<Integer> groupNumberList = new ArrayList<Integer>();
        groupNumberList.addAll(this.groupNumberMap.keySet());
        Collections.sort(groupNumberList);
        this.getChildren().clear();
        int i = 0;
        while (i < groupNumberList.size()) {
            Integer groupNumber2 = (Integer)groupNumberList.get(i);
            flowPane = this.groupNumberMap.get(groupNumber2);
            this.getChildren().add((Object)flowPane);
            ++i;
        }
        return flowPane;
    }

    public void addControl(int groupNumber, Node node) throws Exception {
        FlowPane flowPane = this.getControlPane(groupNumber, true);
        flowPane.getChildren().add((Object)node);
        FxUtil.defaultInitialize((Node)flowPane);
    }

    public void addControl(Node node) throws Exception {
        this.addControl(0, node);
    }

    public boolean removeControl(Node node) throws Exception {
        boolean isSuccess = false;
        for (FlowPane flowPane : this.groupNumberMap.values()) {
            isSuccess = flowPane.getChildren().remove((Object)node);
            if (!isSuccess) continue;
            return isSuccess;
        }
        return isSuccess;
    }

    public void setAlignmentPos(Pos alignmentPos) throws Exception {
        this.alignmentPos = alignmentPos;
        for (FlowPane flowPane : this.groupNumberMap.values()) {
            flowPane.setAlignment(alignmentPos);
        }
        this.setAlignment(alignmentPos);
    }
}

